/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.persistence.IdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.TransactionFailureException;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipTypeHolder {
    private ArrayMap<String, Integer> relTypes = new ArrayMap(5, true, true);
    private Map<Integer, String> relTranslation = new ConcurrentHashMap<Integer, String>();
    private final TransactionManager transactionManager;
    private final PersistenceManager persistenceManager;
    private final IdGenerator idGenerator;

    RelationshipTypeHolder(TransactionManager transactionManager, PersistenceManager persistenceManager, IdGenerator idGenerator) {
        this.transactionManager = transactionManager;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
    }

    void addRawRelationshipTypes(RelationshipTypeData[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.relTypes.put(types[i].getName(), types[i].getId());
            this.relTranslation.put(types[i].getId(), types[i].getName());
        }
    }

    void addRawRelationshipType(RelationshipTypeData type) {
        this.relTypes.put(type.getName(), type.getId());
        this.relTranslation.put(type.getId(), type.getName());
    }

    public RelationshipType addValidRelationshipType(String name, boolean create) {
        if (this.relTypes.get(name) == null) {
            if (!create) {
                return null;
            }
            int id = this.createRelationshipType(name);
            this.relTranslation.put(id, name);
        } else {
            this.relTranslation.put(this.relTypes.get(name), name);
        }
        return new RelationshipTypeImpl(name);
    }

    boolean isValidRelationshipType(RelationshipType type) {
        return this.relTypes.get(type.name()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int createRelationshipType(String name) {
        RelTypeCreater createrThread;
        Integer id = this.relTypes.get(name);
        if (id != null) {
            return id;
        }
        RelTypeCreater relTypeCreater = createrThread = new RelTypeCreater(name);
        synchronized (relTypeCreater) {
            createrThread.start();
            while (createrThread.isAlive()) {
                try {
                    createrThread.wait(50L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
        if (createrThread.succeded()) {
            this.addRelType(name, createrThread.getRelTypeId());
            return createrThread.getRelTypeId();
        }
        throw new TransactionFailureException("Unable to create relationship type " + name);
    }

    void addRelType(String name, Integer id) {
        this.relTypes.put(name, id);
    }

    void removeRelType(String name) {
        this.relTypes.remove(name);
    }

    void removeRelType(int id) {
        String name = this.relTranslation.remove(id);
        if (name != null) {
            this.relTypes.remove(name);
        }
    }

    int getIdFor(RelationshipType type) {
        return this.relTypes.get(type.name());
    }

    RelationshipType getRelationshipType(int id) {
        String name = this.relTranslation.get(id);
        if (name != null) {
            return new RelationshipTypeImpl(name);
        }
        return null;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        ArrayList<RelationshipType> relTypeList = new ArrayList<RelationshipType>();
        for (String name : this.relTypes.keySet()) {
            relTypeList.add(new RelationshipTypeImpl(name));
        }
        return relTypeList;
    }

    void clear() {
        this.relTypes = new ArrayMap();
        this.relTranslation = new HashMap<Integer, String>();
    }

    private class RelTypeCreater
    extends Thread {
        private boolean success = false;
        private String name;
        private int id = -1;

        RelTypeCreater(String name) {
            this.name = name;
        }

        synchronized boolean succeded() {
            return this.success;
        }

        synchronized int getRelTypeId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                RelationshipTypeHolder.this.transactionManager.begin();
                this.id = RelationshipTypeHolder.this.idGenerator.nextId(RelationshipType.class);
                RelationshipTypeHolder.this.persistenceManager.createRelationshipType(this.id, this.name);
                RelationshipTypeHolder.this.transactionManager.commit();
                this.success = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    RelationshipTypeHolder.this.transactionManager.rollback();
                }
                catch (Throwable tt) {
                    tt.printStackTrace();
                }
            }
            finally {
                this.notify();
            }
        }
    }

    private static class RelationshipTypeImpl
    implements RelationshipType {
        private String name;

        RelationshipTypeImpl(String name) {
            assert (name != null);
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipType)) {
                return false;
            }
            return this.name.equals(((RelationshipType)o).name());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

