/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.kernel.impl.event.Event;
import org.neo4j.kernel.impl.event.EventData;
import org.neo4j.kernel.impl.event.EventElement;
import org.neo4j.kernel.impl.event.EventListenerAlreadyRegisteredException;
import org.neo4j.kernel.impl.event.EventListenerNotRegisteredException;
import org.neo4j.kernel.impl.event.EventQueue;
import org.neo4j.kernel.impl.event.ProActiveEventListener;
import org.neo4j.kernel.impl.event.ReActiveEventListener;

public class EventManager {
    private static Logger log = Logger.getLogger(EventManager.class.getName());
    private Map<Event, List<ProActiveEventListener>> proActiveEventListeners = new HashMap<Event, List<ProActiveEventListener>>();
    private Map<Event, List<ReActiveEventListener>> reActiveEventListeners = new HashMap<Event, List<ReActiveEventListener>>();
    private LinkedList<EventElement> eventElements = new LinkedList();
    private volatile boolean startIsOk = true;
    private volatile boolean destroyed = true;
    private EventQueue eventQueue = new EventQueue(this);

    public boolean generateProActiveEvent(Event event, EventData data) {
        assert (!this.destroyed);
        List<ProActiveEventListener> listenerList = this.proActiveEventListeners.get(event);
        if (listenerList != null) {
            Iterator<ProActiveEventListener> listItr = listenerList.iterator();
            boolean result = true;
            while (listItr.hasNext() && result) {
                ProActiveEventListener listener = listItr.next();
                try {
                    if (listener.proActiveEventReceived(event, data)) continue;
                    result = false;
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Exception sending pro-active event to " + listener, t);
                    result = false;
                }
            }
            return result;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReActiveEvent(Event event, EventData data) {
        assert (!this.destroyed);
        this.markWithOriginatingThread(data);
        EventElement evtElement = new EventElement(event, data, false);
        LinkedList<EventElement> linkedList = this.eventElements;
        synchronized (linkedList) {
            this.eventElements.add(evtElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventElement getNextEventElement() {
        LinkedList<EventElement> linkedList = this.eventElements;
        synchronized (linkedList) {
            if (!this.eventElements.isEmpty()) {
                try {
                    return this.eventElements.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void registerProActiveEventListener(ProActiveEventListener listener, Event event) throws EventListenerAlreadyRegisteredException, EventListenerNotRegisteredException {
        assert (!this.destroyed);
        if (listener == null || event == null) {
            throw new EventListenerNotRegisteredException("Null parameter, listener=" + listener + ", event=" + event);
        }
        if (this.proActiveEventListeners.containsKey(event)) {
            List<ProActiveEventListener> listenerList = this.proActiveEventListeners.get(event);
            if (listenerList.contains(listener)) throw new EventListenerAlreadyRegisteredException(" listener=" + listener + ", event=" + event);
            ArrayList<ProActiveEventListener> newList = new ArrayList<ProActiveEventListener>();
            newList.addAll(listenerList);
            newList.add(listener);
            this.proActiveEventListeners.put(event, newList);
            return;
        } else {
            ArrayList<ProActiveEventListener> listenerList = new ArrayList<ProActiveEventListener>();
            listenerList.add(listener);
            this.proActiveEventListeners.put(event, listenerList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void unregisterProActiveEventListener(ProActiveEventListener listener, Event event) throws EventListenerNotRegisteredException {
        assert (!this.destroyed);
        if (!this.proActiveEventListeners.containsKey(event)) throw new EventListenerNotRegisteredException(" listener=" + listener + ", event=" + event);
        List<ProActiveEventListener> listenerList = this.proActiveEventListeners.get(event);
        if (!listenerList.contains(listener)) throw new EventListenerNotRegisteredException(" listener=" + listener + ", event=" + event);
        ArrayList<ProActiveEventListener> newList = new ArrayList<ProActiveEventListener>();
        newList.addAll(listenerList);
        newList.remove(listener);
        this.proActiveEventListeners.put(event, newList);
        if (newList.size() != 0) return;
        this.proActiveEventListeners.remove(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void registerReActiveEventListener(ReActiveEventListener listener, Event event) throws EventListenerAlreadyRegisteredException, EventListenerNotRegisteredException {
        assert (!this.destroyed);
        if (listener == null || event == null) {
            throw new EventListenerNotRegisteredException("Null parameter, listener=" + listener + ", event=" + event);
        }
        if (this.reActiveEventListeners.containsKey(event)) {
            List<ReActiveEventListener> listenerList = this.reActiveEventListeners.get(event);
            if (listenerList.contains(listener)) throw new EventListenerAlreadyRegisteredException(" listener=" + listener + ", event=" + event);
            ArrayList<ReActiveEventListener> newList = new ArrayList<ReActiveEventListener>();
            newList.addAll(listenerList);
            newList.add(listener);
            this.reActiveEventListeners.put(event, newList);
            return;
        } else {
            ArrayList<ReActiveEventListener> listenerList = new ArrayList<ReActiveEventListener>();
            listenerList.add(listener);
            this.reActiveEventListeners.put(event, listenerList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void unregisterReActiveEventListener(ReActiveEventListener listener, Event event) throws EventListenerNotRegisteredException {
        assert (!this.destroyed);
        if (!this.reActiveEventListeners.containsKey(event)) throw new EventListenerNotRegisteredException(" listener=" + listener + ", event=" + event);
        List<ReActiveEventListener> listenerList = this.reActiveEventListeners.get(event);
        if (!listenerList.contains(listener)) throw new EventListenerNotRegisteredException(" listener=" + listener + ", event=" + event);
        ArrayList<ReActiveEventListener> newList = new ArrayList<ReActiveEventListener>();
        newList.addAll(listenerList);
        newList.remove(listener);
        this.reActiveEventListeners.put(event, newList);
        if (newList.size() != 0) return;
        this.reActiveEventListeners.remove(event);
    }

    void sendReActiveEvent(Event event, EventData data) {
        List<ReActiveEventListener> listeners = this.reActiveEventListeners.get(event);
        if (listeners != null) {
            for (ReActiveEventListener listener : listeners) {
                try {
                    listener.reActiveEventReceived(event, data);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    log.severe("Exception sending re-active event to " + listener);
                }
            }
        }
    }

    synchronized void start() {
        if (this.startIsOk) {
            this.eventQueue.start();
            this.startIsOk = false;
            this.destroyed = false;
        } else {
            log.warning("EventModule already started");
        }
    }

    synchronized void stop() {
        assert (!this.destroyed);
        if (!this.startIsOk) {
            this.startIsOk = true;
            this.eventQueue.shutdown();
            this.eventQueue = new EventQueue(this);
        } else {
            log.warning("EventModule already stopped");
        }
    }

    synchronized void destroy() {
        assert (!this.destroyed);
        if (this.startIsOk) {
            this.removeListeners();
            this.destroyed = true;
            this.proActiveEventListeners = new HashMap<Event, List<ProActiveEventListener>>();
            this.reActiveEventListeners = new HashMap<Event, List<ReActiveEventListener>>();
            this.eventElements = new LinkedList();
            this.startIsOk = true;
            this.destroyed = true;
        } else {
            log.severe("EventModule not in stopped state");
        }
    }

    void setReActiveEventQueueWaitTime(int time) {
        assert (!this.destroyed);
        this.eventQueue.setWaitTime(time);
    }

    int getReActiveEventQueueWaitTime() {
        assert (!this.destroyed);
        return this.eventQueue.getWaitTime();
    }

    void setReActiveEventQueueNotifyOnCount(int count) {
        assert (!this.destroyed);
        this.eventQueue.setNotifyOnCount(count);
    }

    int getReActiveEventQueueNotifyOnCount() {
        assert (!this.destroyed);
        return this.eventQueue.getNotifyOnCount();
    }

    private void markWithOriginatingThread(EventData data) {
        if (data != null) {
            data.setOriginatingThread(Thread.currentThread());
        }
    }

    private void removeListeners() {
        int i;
        StringBuffer stringList;
        List<Object> listenerList;
        for (Event event : this.proActiveEventListeners.keySet()) {
            listenerList = this.proActiveEventListeners.get(event);
            stringList = new StringBuffer();
            for (i = 0; i < listenerList.size(); ++i) {
                stringList.append(listenerList.get(i));
                stringList.append("\n");
            }
        }
        for (Event event : this.reActiveEventListeners.keySet()) {
            listenerList = this.reActiveEventListeners.get(event);
            stringList = new StringBuffer();
            for (i = 0; i < listenerList.size(); ++i) {
                stringList.append(listenerList.get(i));
                stringList.append("\n");
            }
        }
    }
}

