/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Map;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeStore
extends AbstractStore
implements Store {
    private static final String VERSION = "NodeStore v0.9.5";
    private static final int RECORD_SIZE = 9;

    public NodeStore(String fileName, Map<?, ?> config) {
        super(fileName, config);
    }

    public NodeStore(String fileName) {
        super(fileName);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static void createStore(String fileName) {
        NodeStore.createEmptyStore(fileName, VERSION);
        NodeStore store = new NodeStore(fileName);
        NodeRecord nodeRecord = new NodeRecord(store.nextId());
        nodeRecord.setInUse(true);
        store.updateRecord(nodeRecord);
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRecord getRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            NodeRecord record;
            NodeRecord nodeRecord = record = this.getRecord(id, window, false);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLightNode(int id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return false;
        }
        try {
            NodeRecord record = this.getRecord(id, window, true);
            if (record == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private NodeRecord getRecord(int id, PersistenceWindow window, boolean check) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        boolean bl = inUse = buffer.get() == Record.IN_USE.byteValue();
        if (!inUse) {
            if (check) {
                return null;
            }
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        NodeRecord nodeRecord = new NodeRecord(id);
        nodeRecord.setInUse(inUse);
        nodeRecord.setNextRel(buffer.getInt());
        nodeRecord.setNextProp(buffer.getInt());
        return nodeRecord;
    }

    private void updateRecord(NodeRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            buffer.put(Record.IN_USE.byteValue()).putInt(record.getNextRel()).putInt(record.getNextProp());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    public String toString() {
        return "NodeStore";
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("NodeStore")) {
            return false;
        }
        if (version.equals("NodeStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }
}

