/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.kernel.impl.transaction.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.RWLock;
import org.neo4j.kernel.impl.transaction.RagManager;

public class LockManager {
    private final Map<Object, RWLock> resourceLockMap = new HashMap<Object, RWLock>();
    private final RagManager ragManager;

    public LockManager(TransactionManager tm) {
        this.ragManager = new RagManager(tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getReadLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                lock = new RWLock(resource, this.ragManager);
                this.resourceLockMap.put(resource, lock);
            }
            lock.mark();
        }
        lock.acquireReadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWriteLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                lock = new RWLock(resource, this.ragManager);
                this.resourceLockMap.put(resource, lock);
            }
            lock.mark();
        }
        lock.acquireWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReadLock(Object resource) throws LockNotFoundException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                throw new LockNotFoundException("Lock not found for: " + resource);
            }
            if (!lock.isMarked() && lock.getReadCount() == 1 && lock.getWriteCount() == 0 && lock.getWaitingThreadsCount() == 0) {
                this.resourceLockMap.remove(resource);
            }
            lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock(Object resource) throws LockNotFoundException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                throw new LockNotFoundException("Lock not found for: " + resource);
            }
            if (!lock.isMarked() && lock.getReadCount() == 0 && lock.getWriteCount() == 1 && lock.getWaitingThreadsCount() == 0) {
                this.resourceLockMap.remove(resource);
            }
            lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocksOnResource(Object resource) {
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            if (!this.resourceLockMap.containsKey(resource)) {
                System.out.println("No locks on " + resource);
                return;
            }
            lock = this.resourceLockMap.get(resource);
        }
        lock.dumpStack();
    }

    public void dumpRagStack() {
        this.ragManager.dumpStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAllLocks() {
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            Iterator<RWLock> itr = this.resourceLockMap.values().iterator();
            int emptyLockCount = 0;
            while (itr.hasNext()) {
                RWLock lock = itr.next();
                if (lock.getWriteCount() > 0 || lock.getReadCount() > 0) {
                    lock.dumpStack();
                    continue;
                }
                if (lock.getWaitingThreadsCount() > 0) {
                    lock.dumpStack();
                }
                ++emptyLockCount;
            }
            if (emptyLockCount > 0) {
                System.out.println("There are " + emptyLockCount + " empty locks");
            } else {
                System.out.println("There are no empty locks");
            }
        }
    }
}

