/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTxManager;
import org.neo4j.kernel.impl.transaction.TransactionFailureException;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxModule {
    private static final String MODULE_NAME = "TxModule";
    private boolean startIsOk = true;
    private String txLogDir = "var/tm";
    private final TransactionManager txManager;
    private final XaDataSourceManager xaDsManager;

    public TxModule(String txLogDir) {
        this.txLogDir = txLogDir;
        this.txManager = new TxManager(txLogDir);
        this.xaDsManager = new XaDataSourceManager();
    }

    public TxModule(boolean readOnly) {
        if (!readOnly) {
            throw new IllegalStateException("Read only must be set for this constructor");
        }
        this.txManager = new ReadOnlyTxManager();
        this.xaDsManager = new XaDataSourceManager();
    }

    public void init() {
    }

    public void start() {
        if (!this.startIsOk) {
            return;
        }
        if (this.txManager instanceof TxManager) {
            ((TxManager)this.txManager).init(this.xaDsManager);
        } else {
            ((ReadOnlyTxManager)this.txManager).init(this.xaDsManager);
        }
        this.startIsOk = false;
    }

    public void reload() {
        this.stop();
        this.start();
    }

    public void stop() {
        this.xaDsManager.unregisterAllDataSources();
        if (this.txManager instanceof TxManager) {
            ((TxManager)this.txManager).stop();
        } else {
            ((ReadOnlyTxManager)this.txManager).stop();
        }
    }

    public void destroy() {
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public XaDataSource registerDataSource(String dsName, String className, byte[] resourceId, Map<?, ?> params) {
        XaDataSourceManager xaDsMgr = this.xaDsManager;
        String name = dsName.toLowerCase();
        if (xaDsMgr.hasDataSource(name)) {
            throw new TransactionFailureException("Data source[" + name + "] has already been registered");
        }
        try {
            XaDataSource dataSource = xaDsMgr.create(className, params);
            xaDsMgr.registerDataSource(name, dataSource, resourceId);
            return dataSource;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Could not create data source [" + name + "], see nested exception for cause of error", e);
        }
    }

    public XaDataSource registerDataSource(String dsName, String className, byte[] resourceId, Map<?, ?> params, boolean useExisting) {
        XaDataSourceManager xaDsMgr = this.xaDsManager;
        String name = dsName.toLowerCase();
        if (xaDsMgr.hasDataSource(name)) {
            if (useExisting) {
                return xaDsMgr.getXaDataSource(name);
            }
            throw new TransactionFailureException("Data source[" + name + "] has already been registered");
        }
        try {
            XaDataSource dataSource = xaDsMgr.create(className, params);
            xaDsMgr.registerDataSource(name, dataSource, resourceId);
            return dataSource;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Could not create data source " + name + "[" + name + "]", e);
        }
    }

    public String getTxLogDirectory() {
        return this.txLogDir;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public XaDataSourceManager getXaDataSourceManager() {
        return this.xaDsManager;
    }
}

