/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.kernel.impl.transaction.TransactionFailureException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XaDataSourceManager {
    private final Map<String, XaDataSource> dataSources = new HashMap<String, XaDataSource>();
    private final Map<String, XaDataSource> branchIdMapping = new HashMap<String, XaDataSource>();
    private final Map<String, byte[]> sourceIdMapping = new HashMap<String, byte[]>();

    XaDataSourceManager() {
    }

    XaDataSource create(String className, Map<?, ?> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors;
        Class<?> clazz = Class.forName(className);
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != 1 || !parameters[0].equals(Map.class)) continue;
            return (XaDataSource)constructor.newInstance(params);
        }
        throw new InstantiationException("Unable to instantiate " + className + ", no valid constructor found.");
    }

    public boolean hasDataSource(String name) {
        return this.dataSources.containsKey(name);
    }

    public XaDataSource getXaDataSource(String name) {
        return this.dataSources.get(name);
    }

    public synchronized void registerDataSource(String name, XaDataSource dataSource, byte[] branchId) {
        dataSource.setBranchId(branchId);
        dataSource.setName(name);
        this.dataSources.put(name, dataSource);
        this.branchIdMapping.put(new String(branchId), dataSource);
        this.sourceIdMapping.put(name, branchId);
    }

    public synchronized void unregisterDataSource(String name) {
        XaDataSource dataSource = this.dataSources.get(name);
        byte[] branchId = this.getBranchId(dataSource.getXaConnection().getXaResource());
        this.dataSources.remove(name);
        this.branchIdMapping.remove(new String(branchId));
        this.sourceIdMapping.remove(name);
        dataSource.close();
    }

    synchronized void unregisterAllDataSources() {
        this.branchIdMapping.clear();
        this.sourceIdMapping.clear();
        for (XaDataSource dataSource : this.dataSources.values()) {
            dataSource.close();
        }
        this.dataSources.clear();
    }

    synchronized byte[] getBranchId(XAResource xaResource) {
        byte[] branchId;
        if (xaResource instanceof XaResource && (branchId = ((XaResource)xaResource).getBranchId()) != null) {
            return branchId;
        }
        for (Map.Entry<String, XaDataSource> entry : this.dataSources.entrySet()) {
            XaDataSource dataSource = entry.getValue();
            XAResource resource = dataSource.getXaConnection().getXaResource();
            try {
                if (!resource.isSameRM(xaResource)) continue;
                String name = entry.getKey();
                return this.sourceIdMapping.get(name);
            }
            catch (XAException e) {
                throw new TransactionFailureException("Unable to check is same resource", e);
            }
        }
        throw new TransactionFailureException("Unable to find mapping for XAResource[" + xaResource + "]");
    }

    synchronized XAResource getXaResource(byte[] branchId) {
        XaDataSource dataSource = this.branchIdMapping.get(new String(branchId));
        if (dataSource == null) {
            throw new TransactionFailureException("No mapping found for branchId[0x" + new String(branchId) + "]");
        }
        return dataSource.getXaConnection().getXaResource();
    }

    public Iterable<XaDataSource> getAllRegisteredDataSources() {
        return this.dataSources.values();
    }
}

