/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

class DirectMappedLogBuffer
implements LogBuffer {
    private static final int BUFFER_SIZE = 0x200000;
    private final FileChannel fileChannel;
    private ByteBuffer byteBuffer = null;
    private long bufferStartPosition;

    DirectMappedLogBuffer(FileChannel fileChannel) throws IOException {
        this.fileChannel = fileChannel;
        this.bufferStartPosition = fileChannel.position();
        this.byteBuffer = ByteBuffer.allocateDirect(0x200000);
        this.getNewMappedBuffer();
    }

    private void getNewMappedBuffer() throws IOException {
        this.byteBuffer.flip();
        this.bufferStartPosition += (long)this.fileChannel.write(this.byteBuffer, this.bufferStartPosition);
        this.byteBuffer.clear();
    }

    public LogBuffer put(byte b) throws IOException {
        if (this.byteBuffer == null || 0x200000 - this.byteBuffer.position() < 1) {
            this.getNewMappedBuffer();
        }
        this.byteBuffer.put(b);
        return this;
    }

    public LogBuffer putInt(int i) throws IOException {
        if (this.byteBuffer == null || 0x200000 - this.byteBuffer.position() < 4) {
            this.getNewMappedBuffer();
        }
        this.byteBuffer.putInt(i);
        return this;
    }

    public LogBuffer putLong(long l) throws IOException {
        if (this.byteBuffer == null || 0x200000 - this.byteBuffer.position() < 8) {
            this.getNewMappedBuffer();
        }
        this.byteBuffer.putLong(l);
        return this;
    }

    public LogBuffer put(byte[] bytes) throws IOException {
        if (this.byteBuffer == null || 0x200000 - this.byteBuffer.position() < bytes.length) {
            this.getNewMappedBuffer();
        }
        this.byteBuffer.put(bytes);
        return this;
    }

    public LogBuffer put(char[] chars) throws IOException {
        if (this.byteBuffer == null || 0x200000 - this.byteBuffer.position() < chars.length * 2) {
            this.getNewMappedBuffer();
        }
        int oldPos = this.byteBuffer.position();
        this.byteBuffer.asCharBuffer().put(chars);
        this.byteBuffer.position(oldPos + chars.length * 2);
        return this;
    }

    public void force() throws IOException {
        this.getNewMappedBuffer();
        this.fileChannel.force(false);
    }

    public long getFileChannelPosition() {
        if (this.byteBuffer != null) {
            return this.bufferStartPosition + (long)this.byteBuffer.position();
        }
        return this.bufferStartPosition;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

