/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.util.Map;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XaContainer {
    private XaCommandFactory cf = null;
    private XaLogicalLog log = null;
    private XaResourceManager rm = null;
    private XaTransactionFactory tf = null;

    public static XaContainer create(String logicalLog, XaCommandFactory cf, XaTransactionFactory tf, Map<Object, Object> config) {
        if (logicalLog == null || cf == null || tf == null) {
            throw new IllegalArgumentException("Null parameter, LogicalLog[" + logicalLog + "] CommandFactory[" + cf + "TransactionFactory[" + tf + "]");
        }
        return new XaContainer(logicalLog, cf, tf, config);
    }

    private XaContainer(String logicalLog, XaCommandFactory cf, XaTransactionFactory tf, Map<Object, Object> config) {
        this.cf = cf;
        this.tf = tf;
        this.rm = new XaResourceManager(tf, logicalLog);
        this.log = new XaLogicalLog(logicalLog, this.rm, cf, tf, config);
        this.rm.setLogicalLog(this.log);
        tf.setLogicalLog(this.log);
    }

    public void openLogicalLog() throws IOException {
        this.log.open();
    }

    public void close() {
        try {
            if (this.log != null) {
                this.log.close();
            }
        }
        catch (IOException e) {
            System.out.println("Unable to close logical log");
            e.printStackTrace();
        }
        this.log = null;
        this.rm = null;
        this.cf = null;
        this.tf = null;
    }

    public XaCommandFactory getCommandFactory() {
        return this.cf;
    }

    public XaLogicalLog getLogicalLog() {
        return this.log;
    }

    public XaResourceManager getResourceManager() {
        return this.rm;
    }

    public XaTransactionFactory getTransactionFactory() {
        return this.tf;
    }
}

