/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.traversal.NodeSortInfo;
import org.neo4j.kernel.impl.traversal.RandomEvaluator;
import org.neo4j.kernel.impl.traversal.SortedTraverser;
import org.neo4j.kernel.impl.traversal.TraversalPositionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTraverser
implements Traverser,
Iterator<Node> {
    private RelationshipType[] traversableRels = null;
    private Direction[] traversableDirs = null;
    private RelationshipType[] preservingRels = null;
    private Direction[] preservingDirs = null;
    private StopEvaluator stopEvaluator = null;
    private ReturnableEvaluator returnableEvaluator = null;
    private Set<Node> visitedNodes = new HashSet<Node>();
    private Node cachedNode = null;
    private int returnedNodesCount = 0;
    private TraversalPositionImpl traversalPosition = null;

    AbstractTraverser(Node startNode, RelationshipType[] traversableRels, Direction[] traversableDirs, RelationshipType[] preservingRels, Direction[] preservingDirs, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RandomEvaluator randomEvaluator) {
        if (startNode == null || traversableRels == null || stopEvaluator == null || returnableEvaluator == null) {
            String s = "startNode = " + startNode + ", traversableRels = " + Arrays.toString(traversableRels) + ", stopEvaluator = " + stopEvaluator + ", returnableEvaluator = " + returnableEvaluator;
            throw new IllegalArgumentException("null argument(s): " + s);
        }
        this.traversableRels = traversableRels;
        this.traversableDirs = traversableDirs;
        this.preservingRels = preservingRels;
        this.preservingDirs = preservingDirs;
        this.stopEvaluator = stopEvaluator;
        this.returnableEvaluator = returnableEvaluator;
        this.initializeList();
        TraversalPositionImpl firstPos = this.createPosition(startNode, null, null, 0);
        this.addPositionToList(firstPos);
    }

    @Override
    public Iterator<Node> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.cachedNode != null) {
            return true;
        }
        this.cachedNode = this.traverseToNextNode();
        return this.cachedNode != null;
    }

    @Override
    public Node next() {
        return this.nextNode();
    }

    public Node nextNode() {
        Node nodeToReturn = this.cachedNode;
        if (nodeToReturn == null) {
            nodeToReturn = this.traverseToNextNode();
        }
        if (nodeToReturn == null) {
            throw new NoSuchElementException();
        }
        this.cachedNode = null;
        return nodeToReturn;
    }

    private Node traverseToNextNode() {
        Node nodeToReturn = null;
        while (!this.listIsEmpty() && nodeToReturn == null) {
            TraversalPositionImpl currentPos;
            this.traversalPosition = currentPos = this.getNextPositionFromList();
            Node currentNode = currentPos.currentNode();
            if (!this.visitedNodes.add(currentNode)) continue;
            currentPos.setReturnedNodesCount(this.returnedNodesCount);
            if (!this.stopEvaluator.isStopNode(currentPos)) {
                try {
                    this.addEndNodesToList(currentPos, this.traversableRels, this.traversableDirs);
                    this.addEndNodesToList(currentPos, this.preservingRels, this.preservingDirs);
                }
                catch (NotFoundException e) {
                    continue;
                }
            }
            if (!this.returnableEvaluator.isReturnableNode(currentPos)) continue;
            ++this.returnedNodesCount;
            nodeToReturn = currentPos.currentNode();
        }
        return nodeToReturn;
    }

    private void addEndNodesToList(TraversalPositionImpl currentPos, RelationshipType[] relTypes, Direction[] dirs) {
        if (relTypes == null) {
            return;
        }
        Node currentNode = currentPos.currentNode();
        int newDepth = currentPos.depth() + 1;
        for (int i = 0; i < relTypes.length; ++i) {
            Iterable<Relationship> rels = null;
            try {
                rels = dirs == null || dirs[i] == Direction.BOTH || dirs[i] == null ? currentNode.getRelationships(relTypes[i]) : currentNode.getRelationships(relTypes[i], dirs[i]);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            if (rels == null) continue;
            for (Relationship rel : rels) {
                this.processRel(currentNode, rel, newDepth);
            }
        }
    }

    private void processRel(Node currentNode, Relationship rel, int newDepth) {
        Node endNode = rel.getOtherNode(currentNode);
        TraversalPositionImpl newPos = this.createPosition(endNode, currentNode, rel, newDepth);
        this.addPositionToList(newPos);
    }

    private TraversalPositionImpl createPosition(Node currentNode, Node previousNode, Relationship lastRelTraversed, int currentDepth) {
        return new TraversalPositionImpl(currentNode, previousNode, lastRelTraversed, currentDepth);
    }

    @Override
    public Collection<Node> getAllNodes() {
        ArrayList<Node> tempList = new ArrayList<Node>();
        while (this.hasNext()) {
            tempList.add(this.nextNode());
        }
        return tempList;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Traverser sort(NodeSortInfo<Node> nsi) {
        ArrayList<Node> tempList = new ArrayList<Node>();
        while (this.hasNext()) {
            tempList.add(this.nextNode());
        }
        Collections.sort(tempList, nsi);
        return new SortedTraverser(tempList);
    }

    @Override
    public TraversalPosition currentPosition() {
        return this.traversalPosition;
    }

    abstract void initializeList();

    abstract void addPositionToList(TraversalPositionImpl var1);

    abstract TraversalPositionImpl getNextPositionFromList();

    abstract boolean listIsEmpty();

    abstract boolean traverseChildrenInNaturalOrder();
}

