/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.LinkedList;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.kernel.impl.traversal.AbstractTraverser;
import org.neo4j.kernel.impl.traversal.RandomEvaluator;
import org.neo4j.kernel.impl.traversal.TraversalPositionImpl;

class BreadthFirstTraverser
extends AbstractTraverser {
    private LinkedList<TraversalPositionImpl> nodeQueue;

    BreadthFirstTraverser(Node startNode, RelationshipType[] traversableRels, Direction[] traversableDirections, RelationshipType[] preservingRels, Direction[] preservingDirections, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RandomEvaluator randomEvaluator) {
        super(startNode, traversableRels, traversableDirections, preservingRels, preservingDirections, stopEvaluator, returnableEvaluator, randomEvaluator);
    }

    void addPositionToList(TraversalPositionImpl position) {
        this.nodeQueue.addLast(position);
    }

    TraversalPositionImpl getNextPositionFromList() {
        return this.nodeQueue.removeFirst();
    }

    boolean listIsEmpty() {
        return this.nodeQueue.isEmpty();
    }

    final boolean traverseChildrenInNaturalOrder() {
        return true;
    }

    void initializeList() {
        this.nodeQueue = new LinkedList();
    }
}

