/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Stack;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.kernel.impl.traversal.AbstractTraverser;
import org.neo4j.kernel.impl.traversal.RandomEvaluator;
import org.neo4j.kernel.impl.traversal.TraversalPositionImpl;

class DepthFirstTraverser
extends AbstractTraverser {
    private Stack<TraversalPositionImpl> stack;

    DepthFirstTraverser(Node startNode, RelationshipType[] traversableRels, Direction[] traversableDirections, RelationshipType[] preservingRels, Direction[] preservingDirections, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RandomEvaluator randomEvaluator) {
        super(startNode, traversableRels, traversableDirections, preservingRels, preservingDirections, stopEvaluator, returnableEvaluator, randomEvaluator);
    }

    void addPositionToList(TraversalPositionImpl position) {
        this.stack.push(position);
    }

    TraversalPositionImpl getNextPositionFromList() {
        return this.stack.pop();
    }

    boolean listIsEmpty() {
        return this.stack.empty();
    }

    final boolean traverseChildrenInNaturalOrder() {
        return false;
    }

    void initializeList() {
        this.stack = new Stack();
    }
}

