/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.traversal.NodeSortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SortedTraverser
implements Traverser {
    private Iterator<Node> nodesIterator = null;

    SortedTraverser(List<Node> nodes) {
        this.nodesIterator = nodes.iterator();
    }

    public Object next() {
        return this.nextNode();
    }

    public boolean hasNext() {
        return this.nodesIterator.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Node nextNode() {
        return this.nodesIterator.next();
    }

    @Override
    public Collection<Node> getAllNodes() {
        ArrayList<Node> tempList = new ArrayList<Node>();
        while (this.hasNext()) {
            tempList.add(this.nextNode());
        }
        return tempList;
    }

    public Traverser sort(NodeSortInfo<Node> nsi) {
        ArrayList<Node> tempList = new ArrayList<Node>();
        while (this.hasNext()) {
            tempList.add(this.nextNode());
        }
        Collections.sort(tempList, nsi);
        return new SortedTraverser(tempList);
    }

    @Override
    public TraversalPosition currentPosition() {
        return null;
    }

    @Override
    public Iterator<Node> iterator() {
        return null;
    }
}

