/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.neo4j.graphdb.NotFoundException;

public class FileUtils {
    private static int WINDOWS_RETRY_COUNT = 3;

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        int count = 0;
        boolean deleted = false;
        do {
            if (deleted = file.delete()) continue;
            ++count;
            FileUtils.waitSome();
        } while (!deleted && count <= WINDOWS_RETRY_COUNT);
        return deleted;
    }

    public static boolean renameFile(File srcFile, File renameToFile) {
        if (!srcFile.exists()) {
            throw new NotFoundException("Source file[" + srcFile.getName() + "] not found");
        }
        if (renameToFile.exists()) {
            throw new NotFoundException("Source file[" + renameToFile.getName() + "] not found");
        }
        int count = 0;
        boolean renamed = false;
        do {
            if (renamed = srcFile.renameTo(renameToFile)) continue;
            ++count;
            FileUtils.waitSome();
        } while (!renamed && count <= WINDOWS_RETRY_COUNT);
        return renamed;
    }

    public static void truncateFile(FileChannel fileChannel, long position) throws IOException {
        int count = 0;
        boolean success = false;
        IOException cause = null;
        do {
            ++count;
            try {
                fileChannel.truncate(position);
                success = true;
            }
            catch (IOException e) {
                cause = e;
            }
        } while (!success && count <= WINDOWS_RETRY_COUNT);
        if (!success) {
            throw cause;
        }
    }

    private static void waitSome() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ee) {
            Thread.interrupted();
        }
        System.gc();
    }

    public static String fixSeparatorsInPath(String path) {
        String fileSeparator = System.getProperty("file.separator");
        if ("\\".equals(fileSeparator)) {
            path = path.replace('/', '\\');
        } else if ("/".equals(fileSeparator)) {
            path = path.replace('\\', '/');
        }
        return path;
    }
}

