/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.SplashScreen;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.ParadiseTool;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.wrapper.StaleProxyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AssembleAgent
extends AbstractParadiseToolAgent {
    public AssembleAgent(ParadiseWorkingSession pws, SplashScreen splashScreen, boolean launchedTheParadisePlatform) throws StaleProxyException {
        super((ParadiseTool)new Assemble(pws, splashScreen, launchedTheParadisePlatform), Arrays.asList("paradiseTool", "Secondary Viewer", "Tertiary Viewer"));
    }

    protected void onGuiEvent(GuiEvent guiEvent) {
        if (guiEvent.getType() == Paradise.functionnalities.indexOf("send selected residues to paradise tools")) {
            this.addBehaviour(new Behaviour(){

                public void action() {
                    DFAgentDescription[] hits = null;
                    DFAgentDescription template = new DFAgentDescription();
                    ServiceDescription templateSd = new ServiceDescription();
                    templateSd.setType("paradiseTool");
                    template.addServices(templateSd);
                    try {
                        hits = DFService.search((Agent)((AbstractParadiseToolAgent)AssembleAgent.this.paradiseTool.getAgent()), (DFAgentDescription)template);
                        for (int i = 0; i < hits.length; ++i) {
                            if (hits[i].getName().equals((Object)AssembleAgent.this.getAID())) continue;
                            ACLMessage query = new ACLMessage(16);
                            query.addReceiver(hits[i].getName());
                            ArrayList<String> residues = new ArrayList<String>();
                            List<Residue2D> residues2D = ((Assemble)AssembleAgent.this.paradiseTool).getMediator().getRna2DViewer().getSecondaryCanvas().getCurrentResidues();
                            for (Residue2D residue2D : residues2D) {
                                Residue r = (Residue)residue2D.getResidue2DFeature().getResidues().iterator().next();
                                residues.add(r.getAbsolutePosition() + " " + r.getMolecule().getParadiseID().getValue());
                            }
                            query.setContentObject(residues);
                            query.setConversationId("residues selected");
                            AssembleAgent.this.send(query);
                        }
                    }
                    catch (FIPAException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public boolean done() {
                    return true;
                }
            });
        } else {
            Iterator iterator = guiEvent.getAllParameter();
            AnswerBehaviour answerBehaviour = null;
            String targetedAgentName = null;
            AbstractParadiseToolAgent.ListAgentsBehaviour behaviour = null;
            if (iterator.hasNext()) {
                answerBehaviour = (AnswerBehaviour)iterator.next();
            }
            if (iterator.hasNext()) {
                targetedAgentName = (String)iterator.next();
            }
            if ((behaviour = targetedAgentName != null ? new AbstractParadiseToolAgent.ListAgentsBehaviour((AbstractParadiseToolAgent)this, targetedAgentName, (String)Paradise.functionnalities.get(guiEvent.getType()), answerBehaviour, this.paradiseTool.getProgressMonitor()) : new AbstractParadiseToolAgent.ListAgentsBehaviour((AbstractParadiseToolAgent)this, (String)Paradise.functionnalities.get(guiEvent.getType()), answerBehaviour, this.paradiseTool.getProgressMonitor())) != null) {
                this.addBehaviour((Behaviour)behaviour);
            }
        }
    }
}

