/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.behaviours;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Model3D;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralDomains3DPredictionRequestAnswerBehaviour
extends AnswerBehaviour {
    public StructuralDomains3DPredictionRequestAnswerBehaviour(ArrayList<Molecule> selectedMolecules, Parameters selectedParameters) {
        super(selectedMolecules, selectedParameters);
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        StructuralFeatureFactory factory = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getStructuralFeatureFactory();
        if (message != null && message.getPerformative() == 11) {
            try {
                Model3D m = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel();
                if (m != null) {
                    List tss;
                    ArrayList remoteMolecules = (ArrayList)message.getContentObject();
                    if (remoteMolecules.size() > 0 && (tss = ((Molecule)remoteMolecules.get(0)).getSelectedFeatures(TertiaryStructure.class)).size() > 0) {
                        TertiaryStructure remote3D = (TertiaryStructure)tss.get(0);
                        ArrayList<Residue3D> residues3D = new ArrayList<Residue3D>();
                        float[] p = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().getGeneralPivot();
                        for (Residue3D r : remote3D.getResidues3D()) {
                            Molecule localMolecule = null;
                            Molecule remoteMolecule = (Molecule)r.getMolecules().iterator().next();
                            for (Molecule _m : this.selectedMolecules) {
                                if (!remoteMolecule.equals(_m)) continue;
                                localMolecule = _m;
                                break;
                            }
                            try {
                                Residue3D r3d = m.getTertiaryStructure().getResidue3DAt(r.getFullLocation(remoteMolecule).getStart(), localMolecule);
                                if (r3d == null) {
                                    r3d = factory.createResidue3D(m.getTertiaryStructure(), localMolecule, r.getFullLocation(remoteMolecule).getStart());
                                }
                                for (Residue3D.Atom ra : r.getAtoms()) {
                                    if (!ra.hasCoordinatesFilled()) continue;
                                    Residue3D.Atom la = r3d.getAtom(ra.getName());
                                    la.setCoordinates(ra.getX() + p[0], ra.getY() + p[1], ra.getZ() + p[2]);
                                }
                                residues3D.add(r3d);
                            }
                            catch (BiologicalSymbolException e) {
                                this.monitor.printException((Exception)((Object)e));
                                return;
                            }
                        }
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().extendModel(residues3D);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().setGeneralPivot(((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().getSelectionCenter());
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().fireRenderingModified();
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().fireModelModified();
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                    }
                } else {
                    List tss;
                    ArrayList serverMolecules = (ArrayList)message.getContentObject();
                    if (serverMolecules.size() > 0 && (tss = ((Molecule)serverMolecules.get(0)).getSelectedFeatures(TertiaryStructure.class)).size() > 0) {
                        TertiaryStructure remote3D = (TertiaryStructure)tss.get(0);
                        TertiaryStructure local3D = null;
                        for (Residue3D r : remote3D.getResidues3D()) {
                            Molecule localMolecule = null;
                            Molecule remoteMolecule = (Molecule)r.getMolecules().iterator().next();
                            for (Molecule _m : this.selectedMolecules) {
                                if (!remoteMolecule.equals(_m)) continue;
                                localMolecule = _m;
                                break;
                            }
                            try {
                                if (local3D == null) {
                                    local3D = remote3D.getFactory().createTertiaryStructure("Tertiary Structure", Source.getGraphicalToolAsSource((String)((ParadiseToolAgent)this.myAgent).getParadiseTool().getDescription()), localMolecule, remote3D.getFullLocation(remoteMolecule));
                                    local3D.setParadiseID(remote3D.getParadiseID());
                                }
                                factory.createResidue3D(local3D, r, localMolecule, r.getFullLocation(remoteMolecule).getStart());
                            }
                            catch (BiologicalSymbolException e) {
                                this.monitor.printException((Exception)((Object)e));
                                return;
                            }
                        }
                        SecondaryStructure ss = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRna2DViewer().getRna2DViewerMediator().getSecondaryCanvas().getModel2D().getSecondaryStructure();
                        local3D.linkSecondaryStructure(ss);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().createModel(ss, local3D);
                        for (Chain c : ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().getChains()) {
                            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().add(c);
                        }
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().setGeneralPivot(((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().getSelectionCenter());
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().fireRenderingModified();
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                    }
                }
                this.monitor.printMessage("End of Analysis");
            }
            catch (Exception e) {
                this.monitor.printException(e);
            }
            this.monitor.stopAnimation();
            this.done = true;
            this.selectedMolecules.clear();
            this.selectedParameters.clear();
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
        }
    }
}

