/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.behaviours;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.ParadiseProjectIO;
import fr.unistra.ibmc.paradise.core.mypdb.MyPDB;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TertiaryStructureLoadedFromMyPDBRequestAnswerBehaviour
extends AnswerBehaviour {
    private String pdbID;
    private boolean displayInAssemble;
    private Collection<Residue> residuesToHightlight;

    public TertiaryStructureLoadedFromMyPDBRequestAnswerBehaviour(ArrayList<Molecule> selectedMolecules, Parameters selectedParameters, String pdbID, boolean displayInAssemble, Collection<Residue> residuesToHightlight) {
        super(selectedMolecules, selectedParameters);
        this.pdbID = pdbID;
        this.displayInAssemble = displayInAssemble;
        this.residuesToHightlight = residuesToHightlight;
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        if (message != null && message.getPerformative() == 11) {
            block12: {
                try {
                    SecondaryStructure remoteSecondaryStructure = (SecondaryStructure)((Molecule)((ArrayList)message.getContentObject()).get(0)).getSelectedFeatures().get(0);
                    SecondaryStructure copySecondaryStructure = null;
                    copySecondaryStructure = remoteSecondaryStructure.hasOnlyInterhelices() || remoteSecondaryStructure.hasAtLeastOneMoleculeOnlyWithInterhelices() ? remoteSecondaryStructure.getFactory().copySecondaryStructure((List)this.selectedMolecules, remoteSecondaryStructure, true) : remoteSecondaryStructure.getFactory().copySecondaryStructure((List)this.selectedMolecules, remoteSecondaryStructure, Paradise.COPY_PSEUDOKNOTS_AND_INTER_MOLECULAR_HELICES);
                    TertiaryStructure ts = (TertiaryStructure)((ParadiseFeature)((Molecule)this.selectedMolecules.get(0)).getSelectedFeatures().get(0)).getParentFeatures(TertiaryStructure.class).get(0);
                    ts.linkSecondaryStructure(copySecondaryStructure);
                    SecondaryStructureDisplay display = remoteSecondaryStructure.getSecondaryStructureDisplay();
                    if (display != null) {
                        remoteSecondaryStructure.getFactory().copySecondaryStructureDisplay((List)this.selectedMolecules, display, copySecondaryStructure);
                    }
                    if (this.displayInAssemble) {
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().loadRNASecondaryStructure(copySecondaryStructure);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().createModel(copySecondaryStructure, ts);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                        if (!this.residuesToHightlight.isEmpty()) {
                            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).receiveSelectedResiduesFromTheOutside(this.residuesToHightlight);
                            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().setGeneralPivot(((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().getSelectionCenter());
                            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getGlobalSelection().fireRenderingModified();
                        }
                    }
                    ParadiseProjectIO.saveWorkingSession((File)new File(new File(Paradise.getMyPDBDir(), this.pdbID), "model"), Arrays.asList(copySecondaryStructure));
                    new File(new File(Paradise.getMyPDBDir(), this.pdbID), this.pdbID + ".pdb").delete();
                    this.monitor.printMessage("Indexation of the new tertiary structure");
                    MyPDB.indexTertiaryStructure((String)this.pdbID, (ParadiseWorkingSession)((ParadiseToolAgent)this.myAgent).getParadiseTool().getWorkingSession());
                    this.monitor.printMessage("End of Analysis");
                }
                catch (Exception e) {
                    System.out.println("Problem: " + this.pdbID);
                    this.monitor.printException(e);
                    if (this.displayInAssemble) break block12;
                    ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).removeTertiaryStructureFromMyPDB(this.pdbID);
                }
            }
            this.monitor.stopAnimation();
            this.done = true;
            this.selectedMolecules.clear();
            this.selectedParameters.clear();
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                System.out.println("Problem: " + this.pdbID);
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
            this.selectedMolecules.clear();
            this.selectedParameters.clear();
        }
    }
}

