/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.SwingWorker;

public class AssembleKeyListener
implements KeyListener {
    private Mediator mediator;

    public AssembleKeyListener(Mediator mediator) {
        this.mediator = mediator;
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 83: {
                if (e.isShiftDown()) {
                    this.mediator.getAssemble().showSelectionOnly();
                    break;
                }
                if (Assemble.KEY_FOR_SHORTCUTS == 0 ? e.isAltDown() : e.isControlDown()) {
                    this.mediator.getAssemble().hideSelectionOnly();
                    break;
                }
                this.mediator.getAssemble().showAll();
                break;
            }
            case 69: {
                if (e.isShiftDown()) {
                    this.mediator.getAssemble().hideLabelsForSelection();
                    break;
                }
                this.mediator.getAssemble().showLabelsForSelection();
                break;
            }
            case 67: {
                this.mediator.getRna2DViewer().clearSelection();
                break;
            }
            case 73: {
                this.mediator.getAssemble().invertSelection();
                break;
            }
            case 88: {
                if (Assemble.KEY_FOR_SHORTCUTS == 0 ? e.isAltDown() : e.isControlDown()) {
                    this.mediator.getRenderer().setGeneralPivot(this.mediator.getGlobalSelection().getSelectionCenter());
                    this.mediator.getRna2DViewer().getSecondaryCanvas().centerViewOnSelection();
                } else {
                    this.mediator.getRenderer().setGeneralPivot(this.mediator.get3DModel().getCenter());
                    this.mediator.getRna2DViewer().getSecondaryCanvas().centerViewOnModel();
                }
                this.mediator.getGlobalSelection().fireRenderingModified();
                break;
            }
            case 85: {
                if (e.isShiftDown()) {
                    this.mediator.addUndoStep("undo");
                    this.mediator.addUndoStep("current");
                    final Color currentColor = this.mediator.getRenderer().getBackgroundColor().getAWTColor();
                    this.mediator.getRenderer().setBackgroundColor(new OpenGLColor(Color.WHITE));
                    new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            Thread.sleep(50L);
                            AssembleKeyListener.this.mediator.getRenderer().setBackgroundColor(new OpenGLColor(currentColor));
                            return null;
                        }
                    }.execute();
                    break;
                }
                this.mediator.restoreState("undo");
                break;
            }
            case 82: {
                this.mediator.restoreState("current");
                break;
            }
            case 86: {
                this.mediator.getAssemble().storeSelection();
                break;
            }
            case 87: {
                this.mediator.getAssemble().openTorsionAnglePanel();
                break;
            }
            case 79: {
                if (e.isShiftDown()) {
                    this.mediator.getAssemble().colorSelectionByAtomType();
                    break;
                }
                if (Assemble.KEY_FOR_SHORTCUTS == 0 ? e.isAltDown() : e.isControlDown()) {
                    this.mediator.getAssemble().colorSelectionByResidueType();
                    break;
                }
                this.mediator.getAssemble().colorSelectionByCustomColor();
                break;
            }
            case 68: {
                this.mediator.getAssemble().deleteResidues();
                break;
            }
            case 84: {
                this.mediator.getAssemble().cutChain();
                break;
            }
            case 76: {
                this.mediator.getAssemble().linkChains();
                break;
            }
            case 66: {
                if (e.isShiftDown()) {
                    this.mediator.getAssemble().bringNextMolecularChainCloser();
                    break;
                }
                if (Assemble.KEY_FOR_SHORTCUTS == 0 ? e.isAltDown() : e.isControlDown()) {
                    this.mediator.getAssemble().bringNextStructuralDomainCloser();
                    break;
                }
                this.mediator.getAssemble().bringNextResidueCloser();
                break;
            }
            case 49: {
                this.mediator.getRna2DViewer().selectAtoms();
                break;
            }
            case 50: {
                this.mediator.getRna2DViewer().selectResidues();
                break;
            }
            case 51: {
                this.mediator.getRna2DViewer().selectInteractions();
                break;
            }
            case 52: {
                this.mediator.getRna2DViewer().selectChains();
                break;
            }
            case 53: {
                this.mediator.getRna2DViewer().selectStructuralDomains();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

