/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.DKnob;
import fr.unistra.ibmc.assemble.gui.event.ModelListener;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.gui.event.SelectionTransmitter;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.ResidueNA;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidueManager
extends JXPanel
implements SelectionListener,
ModelListener,
SelectionTransmitter {
    private ResidueNA residue;
    private ResidueNA nextResidue;
    private ResidueNA previousResidue;
    JPanel top = new JPanel();
    JPanel middle = new JPanel();
    JCheckBox upstreamDirection = new JCheckBox("3'-> 5' scope");
    JCheckBox rotateTertiaryInteractions = new JCheckBox("rotate partners of tertiary interactions");
    JButton prev = new JButton("Previous Residue");
    JButton next = new JButton("Next Residue");
    Mediator mediator;

    public ResidueManager(final Mediator mediator) {
        this.mediator = mediator;
        this.mediator.setResidueManager(this);
        this.prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResidueManager.this.previousResidue != null) {
                    mediator.fireResiduesSelected(ResidueManager.this, Arrays.asList((Residue)ResidueManager.this.previousResidue.getResidue3D().getResidues().iterator().next()), false);
                    ResidueManager.this.setResidue(ResidueManager.this.previousResidue);
                }
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResidueManager.this.nextResidue != null) {
                    mediator.fireResiduesSelected(ResidueManager.this, Arrays.asList((Residue)ResidueManager.this.nextResidue.getResidue3D().getResidues().iterator().next()), false);
                    ResidueManager.this.setResidue(ResidueManager.this.nextResidue);
                }
            }
        });
        this.upstreamDirection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (Component c : ResidueManager.this.middle.getComponents()) {
                    ((AngleTwister)c).dihedralAngle.gatherAtomsToRotate(ResidueManager.this.upstreamDirection.isSelected(), ResidueManager.this.rotateTertiaryInteractions.isSelected());
                }
            }
        });
        this.rotateTertiaryInteractions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (Component c : ResidueManager.this.middle.getComponents()) {
                    ((AngleTwister)c).dihedralAngle.gatherAtomsToRotate(ResidueManager.this.upstreamDirection.isSelected(), ResidueManager.this.rotateTertiaryInteractions.isSelected());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.top.setLayout(new BorderLayout());
        this.top.add((Component)this.prev, "West");
        this.top.add((Component)this.next, "East");
        this.add(this.top, "North");
        this.add(this.middle, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.upstreamDirection, "North");
        bottomPanel.add((Component)this.rotateTertiaryInteractions, "Center");
        this.add(bottomPanel, "South");
    }

    public fr.unistra.ibmc.assemble.structures.Residue getResidue() {
        return this.residue;
    }

    public void clear() {
        this.middle.removeAll();
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public void setResidue(ResidueNA r) {
        this.residue = r;
        Residue paradiseResidue = (Residue)r.getResidue3D().getResidues().iterator().next();
        Residue nextParadiseResidue = paradiseResidue.getNextResidue();
        Residue previousParadiseResidue = paradiseResidue.getPreviousResidue();
        if (nextParadiseResidue != null) {
            this.nextResidue = (ResidueNA)this.mediator.get3DModel().getResidue(nextParadiseResidue);
            while (this.nextResidue == null && (nextParadiseResidue = nextParadiseResidue.getNextResidue()) != null) {
                this.nextResidue = (ResidueNA)this.mediator.get3DModel().getResidue(nextParadiseResidue);
            }
        }
        if (previousParadiseResidue != null) {
            this.previousResidue = (ResidueNA)this.mediator.get3DModel().getResidue(previousParadiseResidue);
            while (this.previousResidue == null && (previousParadiseResidue = previousParadiseResidue.getPreviousResidue()) != null) {
                this.previousResidue = (ResidueNA)this.mediator.get3DModel().getResidue(previousParadiseResidue);
            }
        }
        this.prev.setEnabled(this.previousResidue != null);
        this.next.setEnabled(this.nextResidue != null);
        int nbAngle = 6;
        int nbRow = nbAngle / 2;
        if (nbAngle % 2 != 0) {
            ++nbRow;
        }
        this.middle.removeAll();
        this.middle.setLayout(new GridLayout(nbRow, 2));
        this.middle.add(new AngleTwister(r.getAlpha53(), Color.yellow));
        this.middle.add(new AngleTwister(r.getBeta53(), Color.yellow));
        this.middle.add(new AngleTwister(r.getGamma53(), Color.yellow));
        this.middle.add(new AngleTwister(r.getEpsilon53(), Color.yellow));
        this.middle.add(new AngleTwister(r.getZeta53(), Color.yellow));
        this.middle.add(new AngleTwister(r.getChi(), Color.green));
        this.doLayout();
        this.validate();
        this.repaint();
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (this.mediator.getGlobalSelection().getSelectedResidues().size() == 1) {
            this.setResidue((ResidueNA)this.mediator.getGlobalSelection().getSelectedResidues().get(0));
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
    }

    @Override
    public void modelRejected() {
        for (Component c : this.middle.getComponents()) {
            ((AngleTwister)c).update();
        }
    }

    @Override
    public void modelModified() {
        for (Component c : this.middle.getComponents()) {
            ((AngleTwister)c).update();
            ((AngleTwister)c).dihedralAngle.gatherAtomsToRotate(this.upstreamDirection.isSelected(), this.rotateTertiaryInteractions.isSelected());
        }
    }

    public class AngleTwister
    extends JPanel
    implements ChangeListener {
        DihedralAngle dihedralAngle;
        DKnob knob;
        JLabel angleValue = new JLabel(" ");

        public AngleTwister(DihedralAngle ang, Color color) {
            this.dihedralAngle = ang;
            this.setLayout(new BorderLayout());
            if (!this.dihedralAngle.isValid()) {
                this.knob = new DKnob(this.getBackground());
                this.knob.setEnabled(false);
            } else {
                this.knob = new DKnob(color);
                this.knob.addChangeListener(this);
                this.dihedralAngle.gatherAtomsToRotate(ResidueManager.this.upstreamDirection.isSelected(), ResidueManager.this.rotateTertiaryInteractions.isSelected());
                float value = this.dihedralAngle.getDegreeValue(ResidueManager.this.upstreamDirection.isSelected());
                this.knob.setValueDegree(value);
                this.angleValue.setText(new DecimalFormat("###.0").format(value).replace(',', '.'));
            }
            JPanel center = new JPanel();
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(1);
            center.setLayout(fl);
            this.angleValue.setHorizontalAlignment(0);
            center.add(this.knob);
            this.add((Component)this.angleValue, "North");
            this.add((Component)center, "Center");
            this.setBorder(BorderFactory.createTitledBorder(this.dihedralAngle.getName()));
            this.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    AngleTwister.this.dihedralAngle.torsDegree(e.getWheelRotation(), ResidueManager.this.upstreamDirection.isSelected());
                    AngleTwister.this.knob.setValueDegree(AngleTwister.this.dihedralAngle.getDegreeValue(ResidueManager.this.upstreamDirection.isSelected()));
                }
            });
        }

        public void stateChanged(ChangeEvent e) {
            float future;
            float old = this.dihedralAngle.getDegreeValue(ResidueManager.this.upstreamDirection.isSelected());
            float rot = old - (future = this.knob.getValueDegree());
            if (rot != 0.0f) {
                this.dihedralAngle.torsDegree(rot, ResidueManager.this.upstreamDirection.isSelected());
            }
        }

        private void update() {
            try {
                float newValue = this.dihedralAngle.getDegreeValue(ResidueManager.this.upstreamDirection.isSelected());
                this.angleValue.setText(new DecimalFormat("###.0").format(newValue).replace(',', '.'));
                this.knob.setValueDegree(newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

