/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.AssembleAgent;
import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.assemble.utils.ModelingUtils;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.Paradise;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;

public class SingleStrandsBrowser
extends JXPanel {
    private static final byte LENGTH = 0;
    private static final byte RESOLUTION = 1;
    private static final byte DISTANCE = 2;
    private static final byte PDB_FILE = 3;
    private static final byte PDB_ID = 4;
    private static final byte SSTRAND_TYPE = 5;
    private static final byte ENDS = 6;
    private static final byte MOLECULE_NAME = 7;
    private static final byte SEQUENCE = 8;
    private static final byte OPPOSITE_SSTRAND_PDB_FILE = 9;
    private static final byte OPPOSITE_SSTRAND_LENGTH = 10;
    private static final byte CLASSICAL_SSTRAND = 0;
    private static final byte APICAL_LOOP = 1;
    private static final byte FIVE_PRIME_TERMINAL_SSTRAND = 2;
    private static final byte THREE_PRIME_TERMINAL_SSTRAND = 3;
    private static final byte DONT_MOVE_THE_3PRIME_END = -1;
    private static final byte MOVE_RESIDUE_ON_3PRIME_END = 0;
    private static final byte MOVE_MOLECULAR_CHAIN_ON_3PRIME_END = 1;
    private static final byte MOVE_STRUCTURAL_DOMAIN_ON_3PRIME_END = 2;
    private static final byte MOVE_USER_SELECTION_ON_3PRIME_END = 3;
    private JCheckBox sameDistance;
    private JCheckBox internalLoop;
    private Mediator mediator;
    private float distanceThreshold;
    private float singleStrandDistance;
    private DefaultTableModel model;
    private List<String[]> hits;
    private JPopupMenu popupMenu;
    private File sstrandsLibraryDirectory;
    private SingleStrand selectedSingleStrand;
    private SingleStrand oppositeSingleStrand;
    private File lastLocation;
    private JButton search;
    private JButton create;
    private int pdbFilesToAnnotate;
    private int pdbFilesAnnotated;

    public SingleStrandsBrowser(final Mediator mediator) {
        this.setBackground(Color.WHITE);
        this.mediator = mediator;
        this.setLayout(new BorderLayout());
        this.hits = new ArrayList<String[]>();
        this.lastLocation = new File(System.getProperty("user.home"));
        this.popupMenu = new JPopupMenu();
        JToolBar options = new JToolBar();
        options.setBackground(Color.WHITE);
        options.setFloatable(false);
        options.add(new JLabel("Same distance"));
        this.sameDistance = new JCheckBox();
        this.sameDistance.setBackground(Color.WHITE);
        this.sameDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SingleStrandsBrowser.this.sameDistance.isSelected()) {
                    String t = JOptionPane.showInputDialog(mediator.getAssemble().getFrame(), "Select the distance threshold (in Angstroms)", Float.valueOf(SingleStrandsBrowser.this.distanceThreshold));
                    if (t != null && t.length() == 0) {
                        SingleStrandsBrowser.this.distanceThreshold = 0.0f;
                    } else if (t != null && t.length() != 0) {
                        try {
                            SingleStrandsBrowser.this.distanceThreshold = Float.parseFloat(t);
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(mediator.getAssemble().getFrame(), "This is not a valid number!!");
                        }
                    }
                }
            }
        });
        options.add(this.sameDistance);
        this.internalLoop = new JCheckBox();
        this.internalLoop.setBackground(Color.WHITE);
        options.add(new JLabel("Reproduce internal loop"));
        options.add(this.internalLoop);
        this.search = new JButton("Search");
        this.search.setToolTipText("Search for single-strands in a local repository");
        this.search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List<StructuralDomain2D> sds = mediator.getRna2DViewer().getSecondaryCanvas().getCurrentStructures();
                if (!sds.isEmpty() && sds.size() == 1) {
                    StructuralDomain2D sd = sds.get(0);
                    if (SingleStrand.class.isInstance(sd.getStructuralDomain())) {
                        if (sd.getStructuralDomain().getLength() != mediator.getGlobalSelection().getSelectedResidues().size()) {
                            JOptionPane.showMessageDialog(null, "It seems that not all the residues of the selected single-strand are displayed in the 3D scene");
                            return;
                        }
                        SingleStrandsBrowser.this.clearHits();
                        JFileChooser fileChooser = new JFileChooser(SingleStrandsBrowser.this.lastLocation);
                        fileChooser.setFileSelectionMode(1);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        if (fileChooser.showOpenDialog(null) == 0) {
                            if (!new File(fileChooser.getSelectedFile(), "index").exists()) {
                                JOptionPane.showMessageDialog(null, "Assemble cannot use this directory!!");
                                return;
                            }
                            try {
                                SingleStrandsBrowser.this.sstrandsLibraryDirectory = fileChooser.getSelectedFile();
                                SingleStrandsBrowser.this.lastLocation = fileChooser.getSelectedFile().getParentFile();
                                SingleStrandsBrowser.this.selectedSingleStrand = (SingleStrand)sd.getStructuralDomain();
                                Molecule m = (Molecule)SingleStrandsBrowser.this.selectedSingleStrand.getMolecules().iterator().next();
                                StructuralDomain _sd = null;
                                StructuralDomain __sd = null;
                                if (SingleStrandsBrowser.this.sameDistance.isSelected()) {
                                    Residue3D r2;
                                    Residue3D r1 = mediator.get3DModel().getResidue3DAt(m, SingleStrandsBrowser.this.selectedSingleStrand.get5PrimeEnd() - 1);
                                    if (r1 != null & (r2 = mediator.get3DModel().getResidue3DAt(m, SingleStrandsBrowser.this.selectedSingleStrand.get3PrimeEnd() + 1)) != null) {
                                        Residue3D.Atom atom1 = r1.getAtom("O3'");
                                        Residue3D.Atom atom2 = r2.getAtom("O1P");
                                        if (atom1 != null && atom1.hasCoordinatesFilled() && atom2 != null && atom2.hasCoordinatesFilled()) {
                                            SingleStrandsBrowser.this.singleStrandDistance = TBMath.distance((float[])atom1.getCoordinates(), (float[])atom2.getCoordinates());
                                        } else {
                                            JOptionPane.showMessageDialog(null, "The distance option is ignored: not able to calculate the distance to fill!!");
                                            SingleStrandsBrowser.this.sameDistance.setSelected(false);
                                        }
                                    } else {
                                        JOptionPane.showMessageDialog(null, "The distance option is ignored: not able to calculate the distance to fill!!");
                                        SingleStrandsBrowser.this.sameDistance.setSelected(false);
                                    }
                                }
                                if (SingleStrandsBrowser.this.internalLoop.isSelected() && !SingleStrandsBrowser.this.selectedSingleStrand.isAtFivePrimeEnd() && !SingleStrandsBrowser.this.selectedSingleStrand.isAtThreePrimeEnd()) {
                                    _sd = mediator.get2DModel().getSecondaryStructure().getEnclosingStructuralDomain(mediator.get2DModel().getSecondaryStructure().getPairedResidueInSecondaryInteraction(new Residue(SingleStrandsBrowser.this.selectedSingleStrand.get5PrimeEnd() - 1, m)).getPreviousResidue());
                                    __sd = mediator.get2DModel().getSecondaryStructure().getEnclosingStructuralDomain(mediator.get2DModel().getSecondaryStructure().getPairedResidueInSecondaryInteraction(new Residue(SingleStrandsBrowser.this.selectedSingleStrand.get3PrimeEnd() + 1, m)).getNextResidue());
                                    if (SingleStrand.class.isInstance(_sd) && SingleStrand.class.isInstance(__sd) && _sd == __sd) {
                                        SingleStrandsBrowser.this.oppositeSingleStrand = (SingleStrand)_sd;
                                    }
                                }
                                SingleStrandsBrowser.this.hits = new ArrayList();
                                BufferedReader buff = new BufferedReader(new FileReader(new File(fileChooser.getSelectedFile(), "index")));
                                String line = null;
                                while ((line = buff.readLine()) != null) {
                                    String[] tokens = line.split("\\s");
                                    if (!((Integer.parseInt(tokens[5]) == 1 && SingleStrandsBrowser.this.selectedSingleStrand.isApicalLoop() || Integer.parseInt(tokens[5]) == 2 && SingleStrandsBrowser.this.selectedSingleStrand.isAtFivePrimeEnd() || Integer.parseInt(tokens[5]) == 3 && SingleStrandsBrowser.this.selectedSingleStrand.isAtThreePrimeEnd() || Integer.parseInt(tokens[5]) == 0 && !SingleStrandsBrowser.this.selectedSingleStrand.isApicalLoop() && !SingleStrandsBrowser.this.selectedSingleStrand.isAtFivePrimeEnd() && !SingleStrandsBrowser.this.selectedSingleStrand.isAtThreePrimeEnd()) && Integer.parseInt(tokens[0]) == SingleStrandsBrowser.this.selectedSingleStrand.getLength() && (!SingleStrandsBrowser.this.internalLoop.isSelected() || tokens.length == 11 && SingleStrandsBrowser.this.oppositeSingleStrand != null && SingleStrandsBrowser.this.oppositeSingleStrand.getLength() == Integer.parseInt(tokens[10])) && (!SingleStrandsBrowser.this.sameDistance.isSelected() || !(SingleStrandsBrowser.this.singleStrandDistance < Float.parseFloat(tokens[2]) - SingleStrandsBrowser.this.distanceThreshold) && !(SingleStrandsBrowser.this.singleStrandDistance > Float.parseFloat(tokens[2]) + SingleStrandsBrowser.this.distanceThreshold)))) continue;
                                    SingleStrandsBrowser.this.hits.add(tokens);
                                    SingleStrandsBrowser.this.model.addRow(new String[]{tokens[0], tokens[1], tokens[2], tokens[4], tokens[8]});
                                }
                                if (SingleStrandsBrowser.this.hits.isEmpty()) {
                                    JOptionPane.showMessageDialog(null, "No single-strands found with your criteria!!");
                                }
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Select a single-strand region in the 2D panel to use this option");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Select only a single-strand region in the 2D panel to use this option");
                }
            }
        });
        options.add(Box.createHorizontalStrut(10));
        options.add(this.search);
        this.create = new JButton("Create");
        this.create.setToolTipText("Create a local repository of single-strands from a set of PDB files");
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
                fileChooser.setFileSelectionMode(1);
                fileChooser.setAcceptAllFileFilterUsed(false);
                PDBFileIO pdbParser = new PDBFileIO(mediator.getAssemble().getWorkingSession());
                if (fileChooser.showOpenDialog(null) == 0) {
                    File fragmentsIndex;
                    File fragmentsDir = new File(fileChooser.getSelectedFile(), "single-strands");
                    if (!fragmentsDir.exists()) {
                        fragmentsDir.mkdir();
                    }
                    if (!(fragmentsIndex = new File(fragmentsDir, "index")).exists()) {
                        // empty if block
                    }
                    try {
                        fragmentsIndex.createNewFile();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    File[] pdbFiles = fileChooser.getSelectedFile().listFiles(new FileFilter(){

                        public boolean accept(File name) {
                            return name.getName().endsWith(".pdb");
                        }
                    });
                    if (pdbFiles.length != 0) {
                        SingleStrandsBrowser.this.create.setEnabled(false);
                        SingleStrandsBrowser.this.pdbFilesToAnnotate = pdbFiles.length;
                        SingleStrandsBrowser.this.pdbFilesAnnotated = 0;
                        for (int i = 0; i < pdbFiles.length; ++i) {
                            File f = pdbFiles[i];
                            if (!f.getName().endsWith(".pdb")) continue;
                            SingleStrandsBrowser.this.annotatePDB(pdbParser, fragmentsDir, fragmentsIndex, f);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "No PDB file found to extract the single-strands!!");
                    }
                }
            }
        });
        options.add(Box.createHorizontalStrut(10));
        options.add(this.create);
        this.add(options, "North");
        final JXTable table = new JXTable();
        table.setSelectionMode(0);
        table.setBackground(Color.WHITE);
        table.setSortable(false);
        table.setEditable(false);
        this.add(new JScrollPane((Component)table), "Center");
        this.model = new DefaultTableModel();
        this.model.addColumn("Length");
        this.model.addColumn("Resolution");
        this.model.addColumn("Distance");
        this.model.addColumn("PDB ID");
        this.model.addColumn("Sequence");
        table.setModel((TableModel)this.model);
        table.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SingleStrandsBrowser.this.popupMenu.removeAll();
                    if (SingleStrandsBrowser.this.selectedSingleStrand.isApicalLoop() || SingleStrandsBrowser.this.selectedSingleStrand.isAtThreePrimeEnd() || SingleStrandsBrowser.this.selectedSingleStrand.isAtFivePrimeEnd()) {
                        JMenuItem menuItem = new JMenuItem("Apply");
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                List<StructuralDomain2D> sds = mediator.getRna2DViewer().getSecondaryCanvas().getCurrentStructures();
                                if (sds.isEmpty() || sds.size() != 1 || !sds.get(0).getStructuralDomain().equals((Object)SingleStrandsBrowser.this.selectedSingleStrand)) {
                                    JOptionPane.showMessageDialog(null, "It seems that you have modified your selection in the 2D panel. Reselect it or do a new search!!");
                                    return;
                                }
                                PDBFileIO parser = new PDBFileIO(mediator.getAssemble().getWorkingSession());
                                try {
                                    parser.parseFile(new File(SingleStrandsBrowser.this.sstrandsLibraryDirectory, ((String[])SingleStrandsBrowser.this.hits.get(table.getSelectedRow()))[3]), mediator.getAssemble().getProgressMonitor());
                                    List residues = ((TertiaryStructure)parser.getTertiaryStructures().get(0)).getResidues3D();
                                    List<fr.unistra.ibmc.assemble.structures.Residue> assembleResidues = mediator.getGlobalSelection().getSelectedResidues();
                                    if (assembleResidues.size() != SingleStrandsBrowser.this.selectedSingleStrand.getLength()) {
                                        JOptionPane.showMessageDialog(null, "It seems that you have modified your selection in 3D scene. Reselect the residues and retry!!");
                                        return;
                                    }
                                    Collections.sort(assembleResidues, new Comparator<fr.unistra.ibmc.assemble.structures.Residue>(){

                                        @Override
                                        public int compare(fr.unistra.ibmc.assemble.structures.Residue o1, fr.unistra.ibmc.assemble.structures.Residue o2) {
                                            return o1.getNumber() - o2.getNumber();
                                        }
                                    });
                                    if (SingleStrandsBrowser.this.selectedSingleStrand.isApicalLoop()) {
                                        fr.unistra.ibmc.assemble.structures.Residue start = assembleResidues.get(0);
                                        fr.unistra.ibmc.assemble.structures.Residue end = assembleResidues.get(assembleResidues.size() - 1);
                                        fr.unistra.ibmc.assemble.structures.Residue previousAssembleResidue = mediator.getAssemble().getAssembleResidue(new Residue(start.getNumber() - 1, start.getChain().getMolecule()));
                                        fr.unistra.ibmc.assemble.structures.Residue nextAssembleResidue = mediator.getAssemble().getAssembleResidue(new Residue(end.getNumber() + 1, end.getChain().getMolecule()));
                                        if (previousAssembleResidue != null && nextAssembleResidue != null) {
                                            assembleResidues.add(0, previousAssembleResidue);
                                            assembleResidues.add(nextAssembleResidue);
                                            ModelingUtils.applyFold(assembleResidues, residues, previousAssembleResidue);
                                            mediator.getAssemble().synchronize();
                                            mediator.get3DModel().fireModelModified();
                                        } else {
                                            JOptionPane.showMessageDialog(null, "The residues of the secondary interaction closing the terminal-loop is missing in the 3D scene");
                                        }
                                    } else if (SingleStrandsBrowser.this.selectedSingleStrand.isAtFivePrimeEnd()) {
                                        fr.unistra.ibmc.assemble.structures.Residue end = assembleResidues.get(assembleResidues.size() - 1);
                                        Residue paradiseResidue = new Residue(end.getNumber() + 1, end.getChain().getMolecule());
                                        fr.unistra.ibmc.assemble.structures.Residue nextAssembleResidue = mediator.getAssemble().getAssembleResidue(paradiseResidue);
                                        if (nextAssembleResidue != null) {
                                            assembleResidues.add(nextAssembleResidue);
                                            ModelingUtils.applyFold(assembleResidues, residues, nextAssembleResidue);
                                            mediator.getAssemble().synchronize();
                                            mediator.get3DModel().fireModelModified();
                                        } else {
                                            JOptionPane.showMessageDialog(null, "The residue at the 3' end of the selected single-strand is missing in the 3D scene");
                                        }
                                    } else if (SingleStrandsBrowser.this.selectedSingleStrand.isAtThreePrimeEnd()) {
                                        fr.unistra.ibmc.assemble.structures.Residue start = assembleResidues.get(0);
                                        Residue paradiseResidue = new Residue(start.getNumber() - 1, start.getChain().getMolecule());
                                        fr.unistra.ibmc.assemble.structures.Residue previousAssembleResidue = mediator.getAssemble().getAssembleResidue(paradiseResidue);
                                        if (previousAssembleResidue != null) {
                                            assembleResidues.add(0, previousAssembleResidue);
                                            ModelingUtils.applyFold(assembleResidues, residues, previousAssembleResidue);
                                            mediator.getAssemble().synchronize();
                                            mediator.get3DModel().fireModelModified();
                                        } else {
                                            JOptionPane.showMessageDialog(null, "The residue at the 5' end of the selected single-strand is missing in the 3D scene");
                                        }
                                    }
                                }
                                catch (FileParsingException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        SingleStrandsBrowser.this.popupMenu.add(menuItem);
                    } else {
                        JMenuItem menuItem = new JMenuItem("Apply and move nothing at 3' end");
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                String[] tokens = (String[])SingleStrandsBrowser.this.hits.get(table.getSelectedRow());
                                SingleStrandsBrowser.this.applySingleStrandFold((StructuralDomain)SingleStrandsBrowser.this.selectedSingleStrand, tokens[3], (byte)-1);
                                if (tokens.length == 11 && SingleStrandsBrowser.this.internalLoop.isSelected()) {
                                    SingleStrandsBrowser.this.applySingleStrandFold((StructuralDomain)SingleStrandsBrowser.this.oppositeSingleStrand, tokens[9], (byte)-1);
                                }
                            }
                        });
                        SingleStrandsBrowser.this.popupMenu.add(menuItem);
                        menuItem = new JMenuItem("Apply and move the structural domain at 3' end");
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                String[] tokens = (String[])SingleStrandsBrowser.this.hits.get(table.getSelectedRow());
                                SingleStrandsBrowser.this.applySingleStrandFold((StructuralDomain)SingleStrandsBrowser.this.selectedSingleStrand, tokens[3], (byte)2);
                                if (tokens.length == 11 && SingleStrandsBrowser.this.internalLoop.isSelected()) {
                                    SingleStrandsBrowser.this.applySingleStrandFold((StructuralDomain)SingleStrandsBrowser.this.oppositeSingleStrand, tokens[9], (byte)-1);
                                }
                            }
                        });
                        SingleStrandsBrowser.this.popupMenu.add(menuItem);
                        menuItem = new JMenuItem("Apply and move the user-defined selection at 3' end");
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                String[] tokens = (String[])SingleStrandsBrowser.this.hits.get(table.getSelectedRow());
                                SingleStrandsBrowser.this.applySingleStrandFold((StructuralDomain)SingleStrandsBrowser.this.selectedSingleStrand, tokens[3], (byte)3);
                                if (tokens.length == 11 && SingleStrandsBrowser.this.internalLoop.isSelected()) {
                                    SingleStrandsBrowser.this.applySingleStrandFold((StructuralDomain)SingleStrandsBrowser.this.oppositeSingleStrand, tokens[9], (byte)-1);
                                }
                            }
                        });
                        SingleStrandsBrowser.this.popupMenu.add(menuItem);
                    }
                    SingleStrandsBrowser.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    SingleStrandsBrowser.this.popupMenu.doLayout();
                }
            }
        });
    }

    private void applySingleStrandFold(StructuralDomain singleStrandToFold, String singleStrandPdbFile, byte mode) {
        PDBFileIO parser = new PDBFileIO(this.mediator.getAssemble().getWorkingSession());
        try {
            parser.parseFile(new File(this.sstrandsLibraryDirectory, singleStrandPdbFile), this.mediator.getAssemble().getProgressMonitor());
            List residues = ((TertiaryStructure)parser.getTertiaryStructures().get(0)).getResidues3D();
            ArrayList<fr.unistra.ibmc.assemble.structures.Residue> assembleResidues = new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>();
            for (Residue r : singleStrandToFold.getResidues().getResidues()) {
                fr.unistra.ibmc.assemble.structures.Residue assembleResidue = this.mediator.getAssemble().getAssembleResidue(r);
                if (assembleResidue == null) continue;
                assembleResidues.add(assembleResidue);
            }
            Collections.sort(assembleResidues, new Comparator<fr.unistra.ibmc.assemble.structures.Residue>(){

                @Override
                public int compare(fr.unistra.ibmc.assemble.structures.Residue o1, fr.unistra.ibmc.assemble.structures.Residue o2) {
                    return o1.getNumber() - o2.getNumber();
                }
            });
            fr.unistra.ibmc.assemble.structures.Residue start = (fr.unistra.ibmc.assemble.structures.Residue)assembleResidues.get(0);
            fr.unistra.ibmc.assemble.structures.Residue end = (fr.unistra.ibmc.assemble.structures.Residue)assembleResidues.get(assembleResidues.size() - 1);
            Residue startParadiseResidue = new Residue(start.getNumber() - 1, start.getChain().getMolecule());
            Residue endParadiseResidue = new Residue(end.getNumber() + 1, end.getChain().getMolecule());
            fr.unistra.ibmc.assemble.structures.Residue previousAssembleResidue = this.mediator.getAssemble().getAssembleResidue(startParadiseResidue);
            fr.unistra.ibmc.assemble.structures.Residue nextAssembleResidue = this.mediator.getAssemble().getAssembleResidue(endParadiseResidue);
            if (mode == -1 && previousAssembleResidue != null) {
                assembleResidues.add(0, previousAssembleResidue);
                ModelingUtils.applyFold(assembleResidues, residues.subList(0, residues.size() - 1), previousAssembleResidue);
                this.mediator.get3DModel().fireModelModified();
            } else if (previousAssembleResidue != null && nextAssembleResidue != null) {
                assembleResidues.add(0, previousAssembleResidue);
                assembleResidues.add(nextAssembleResidue);
                float[] c1_1 = nextAssembleResidue.getAtom("C1'").getFloat();
                float[] c2_1 = nextAssembleResidue.getAtom("C2'").getFloat();
                float[] c3_1 = nextAssembleResidue.getAtom("C3'").getFloat();
                float[] c4_1 = nextAssembleResidue.getAtom("C4'").getFloat();
                ModelingUtils.applyFold(assembleResidues, residues, previousAssembleResidue);
                float[] c1_2 = nextAssembleResidue.getAtom("C1'").getFloat();
                float[] c2_2 = nextAssembleResidue.getAtom("C2'").getFloat();
                float[] c3_2 = nextAssembleResidue.getAtom("C3'").getFloat();
                float[] c4_2 = nextAssembleResidue.getAtom("C4'").getFloat();
                ArrayList<fr.unistra.ibmc.assemble.structures.Residue> residuesOn3PrimeEndToMove = new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>();
                switch (mode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        residuesOn3PrimeEndToMove.addAll(nextAssembleResidue.getChain().getResidues());
                        break;
                    }
                    case 2: {
                        StructuralDomain sd = this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((Residue)nextAssembleResidue.getResidue3D().getResidues().iterator().next());
                        for (Residue r : sd.getResidues().getResidues()) {
                            fr.unistra.ibmc.assemble.structures.Residue assembleResidue = this.mediator.getAssemble().getAssembleResidue(r);
                            if (assembleResidue == null) continue;
                            residuesOn3PrimeEndToMove.add(assembleResidue);
                        }
                        break;
                    }
                    case 3: {
                        ArrayList<UserSelection> selections = new ArrayList<UserSelection>();
                        for (UserSelection us : this.mediator.getUserSelections()) {
                            if (!us.getResidues().contains(nextAssembleResidue)) continue;
                            selections.add(us);
                        }
                        UserSelection selection = null;
                        if (selections.size() == 0) {
                            JOptionPane.showMessageDialog(null, "No User Selection containing the residue after the 5'-end of your single-strand");
                            return;
                        }
                        selection = selections.size() == 1 ? (UserSelection)selections.get(0) : (UserSelection)JOptionPane.showInputDialog(null, "Choose a User Selection", "Choose a User Selection", -1, null, selections.toArray(), selections.get(0));
                        if (selection == null) break;
                        residuesOn3PrimeEndToMove.addAll(selection.getResidues());
                    }
                }
                residuesOn3PrimeEndToMove.remove(nextAssembleResidue);
                if (!residuesOn3PrimeEndToMove.isEmpty()) {
                    ModelingUtils.transformResidues(ModelingUtils.getTransformationMatrix(new float[][]{c1_1, c2_1, c3_1, c4_1}, new float[][]{c1_2, c2_2, c3_2, c4_2}), residuesOn3PrimeEndToMove);
                }
                this.mediator.get3DModel().fireModelModified();
            } else if (mode == -1) {
                JOptionPane.showMessageDialog(null, "The residues at the 5' and 3' ends of the selected single-strand have to be present in the 3D scene.");
            } else {
                JOptionPane.showMessageDialog(null, "The residues at the 5' and 3' ends of the selected single-strand have to be present in the 3D scene.");
            }
        }
        catch (FileParsingException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private void clearHits() {
        int size = this.model.getRowCount();
        for (int i = 0; i < size; ++i) {
            this.model.removeRow(0);
        }
        this.hits.clear();
    }

    private void annotatePDB(PDBFileIO pdbParser, File fragmentsDir, File fragmentsIndex, File pdbFile) {
        try {
            pdbParser.parseFile(pdbFile, this.mediator.getAssemble().getProgressMonitor());
            this.mediator.getAssemble().getProgressMonitor().printMessage("Annotate " + pdbParser.getPdbID());
            this.mediator.getAssemble().getProgressMonitor().printMessage("X-RAY: " + pdbParser.isXrayStructure());
            this.mediator.getAssemble().getProgressMonitor().printMessage("Resolution: " + pdbParser.getResolution());
            GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("3D annotation"));
            ArrayList<Molecule> _molecules = new ArrayList<Molecule>();
            _molecules.addAll(pdbParser.getMolecules());
            for (Molecule m : _molecules) {
                m.removeAllSelectedFeatures();
                for (Residue3D r : ((TertiaryStructure)pdbParser.getTertiaryStructures().get(0)).getSubFeatures(Residue3D.class, m)) {
                    m.addSelectedFeature((ParadiseFeature)r);
                }
            }
            FragmentBehaviour answerBehaviour = new FragmentBehaviour(pdbParser.getResolution(), pdbParser.getPdbID(), fragmentsDir, fragmentsIndex, _molecules, new Parameters());
            ev.addParameter((Object)answerBehaviour);
            ((AssembleAgent)this.mediator.getAssemble().getAgent()).postGuiEvent(ev);
        }
        catch (Exception e) {
            e.getCause().printStackTrace();
            this.mediator.getAssemble().getProgressMonitor().printMessage("Problem with " + pdbParser.getPdbID() + ": " + e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FragmentBehaviour
    extends AnswerBehaviour {
        private File fragmentsIndex;
        private File fragmentsDir;
        private float resolution;
        private String pdbID;

        FragmentBehaviour(float resolution, String pdbID, File fragmentsDir, File fragmentsIndex, ArrayList<Molecule> selectedMolecules, Parameters selectedParameters) {
            super(selectedMolecules, selectedParameters);
            this.fragmentsIndex = fragmentsIndex;
            this.fragmentsDir = fragmentsDir;
            this.resolution = resolution;
            this.pdbID = pdbID;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void action() {
            ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
            if (message != null && message.getPerformative() == 11) {
                try {
                    this.monitor.printMessage("Got answer for " + this.pdbID);
                    if (this.fragmentsIndex.exists()) {
                        this.fragmentsIndex.createNewFile();
                    }
                    PrintWriter pw = new PrintWriter(this.fragmentsIndex);
                    SecondaryStructure remoteSecondaryStructure = (SecondaryStructure)((Molecule)((ArrayList)message.getContentObject()).get(0)).getSelectedFeatures(SecondaryStructure.class).get(0);
                    TertiaryStructure ts = (TertiaryStructure)((ParadiseFeature)((Molecule)this.selectedMolecules.get(0)).getSelectedFeatures().get(0)).getParentFeatures(TertiaryStructure.class).get(0);
                    SecondaryStructure copySecondaryStructure = remoteSecondaryStructure.getFactory().copySecondaryStructure((List)this.selectedMolecules, remoteSecondaryStructure, true);
                    for (SingleStrand s : copySecondaryStructure.getSingleStrands()) {
                        Residue pairedResidue;
                        Residue3D r;
                        int start = s.get5PrimeEnd();
                        int end = s.get3PrimeEnd();
                        Molecule m = (Molecule)s.getMolecules().iterator().next();
                        if (s.getLength() < 1) continue;
                        Residue3D.Atom atom1 = ts.getResidue3DAt(start, m).getAtom("O1P");
                        Residue3D.Atom atom2 = ts.getResidue3DAt(end, m).getAtom("O3'");
                        if (atom1 == null || !atom1.hasCoordinatesFilled() || atom2 == null || !atom2.hasCoordinatesFilled()) continue;
                        File pdbFile = new File(this.fragmentsDir, this.pdbID + "_" + m.getName() + "_" + start + ".pdb");
                        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
                        for (int i = start; i <= end; ++i) {
                            residues.add(ts.getResidue3DAt(i, m));
                        }
                        int sstrand_type = 0;
                        StructuralDomain oppositeSingleStrand = null;
                        StructuralDomain otherOppositeSingleStrand = null;
                        if (s.isApicalLoop()) {
                            sstrand_type = 1;
                            residues.add(0, ts.getResidue3DAt(start - 1, m));
                            residues.add(ts.getResidue3DAt(end + 1, m));
                        } else if (s.isAtFivePrimeEnd()) {
                            sstrand_type = 2;
                            r = ts.getResidue3DAt(end + 1, m);
                            residues.add(r);
                            pairedResidue = copySecondaryStructure.getPairedResidueInSecondaryInteraction((Residue)r.getResidues().iterator().next());
                        } else if (s.isAtThreePrimeEnd()) {
                            sstrand_type = 3;
                            r = ts.getResidue3DAt(start - 1, m);
                            pairedResidue = copySecondaryStructure.getPairedResidueInSecondaryInteraction((Residue)r.getResidues().iterator().next());
                            residues.add(0, r);
                        } else {
                            r = ts.getResidue3DAt(start - 1, m);
                            pairedResidue = copySecondaryStructure.getPairedResidueInSecondaryInteraction((Residue)r.getResidues().iterator().next());
                            if (pairedResidue.getPreviousResidue() != null) {
                                oppositeSingleStrand = copySecondaryStructure.getEnclosingStructuralDomain(pairedResidue.getPreviousResidue());
                            }
                            residues.add(0, r);
                            r = ts.getResidue3DAt(end + 1, m);
                            residues.add(r);
                            pairedResidue = copySecondaryStructure.getPairedResidueInSecondaryInteraction((Residue)r.getResidues().iterator().next());
                            if (pairedResidue.getNextResidue() != null) {
                                otherOppositeSingleStrand = copySecondaryStructure.getEnclosingStructuralDomain(pairedResidue.getNextResidue());
                            }
                        }
                        PDBFileIO.writePDBFile(residues, (boolean)false, (File)pdbFile);
                        if (oppositeSingleStrand != null && otherOppositeSingleStrand != null && oppositeSingleStrand == otherOppositeSingleStrand) {
                            pw.println(s.getLength() + "\t" + this.resolution + "\t" + String.format(Locale.US, "%.2f", Float.valueOf(TBMath.distance((float[])atom1.getCoordinates(), (float[])atom2.getCoordinates()))) + "\t" + pdbFile.getName() + "\t" + this.pdbID + "\t" + sstrand_type + "\t" + start + "-" + end + "\t" + m.getName() + "\t" + m.printSequence(new Location(start, end)) + "\t" + this.pdbID + "_" + m.getName() + "_" + oppositeSingleStrand.getFullLocation(m).getStart() + ".pdb\t" + oppositeSingleStrand.getLength());
                            continue;
                        }
                        pw.println(s.getLength() + "\t" + this.resolution + "\t" + String.format(Locale.US, "%.2f", Float.valueOf(TBMath.distance((float[])atom1.getCoordinates(), (float[])atom2.getCoordinates()))) + "\t" + pdbFile.getName() + "\t" + this.pdbID + "\t" + sstrand_type + "\t" + start + "-" + end + "\t" + m.getName() + "\t" + m.printSequence(new Location(start, end)));
                    }
                    pw.close();
                }
                catch (Exception e) {
                    this.monitor.printMessage("Problem with " + this.pdbID + ": " + e.getMessage());
                }
                this.monitor.stopAnimation();
                this.done = true;
                SingleStrandsBrowser.this.pdbFilesAnnotated++;
                if (SingleStrandsBrowser.this.pdbFilesToAnnotate != SingleStrandsBrowser.this.pdbFilesAnnotated) return;
                JOptionPane.showMessageDialog(null, "All fragments have been generated!!");
                SingleStrandsBrowser.this.create.setEnabled(true);
                return;
            }
            if (message != null && message.getPerformative() == 7) {
                this.monitor.printMessage(message.getContent());
                return;
            }
            if (message == null) return;
            if (message.getPerformative() != 6) return;
            try {
                this.monitor.printMessage("Problem with " + this.pdbID + ": " + ((Exception)message.getContentObject()).getMessage());
                if (!((Exception)message.getContentObject()).getMessage().startsWith("No base-pairs found")) {
                    // empty if block
                }
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            SingleStrandsBrowser.this.pdbFilesAnnotated++;
            if (SingleStrandsBrowser.this.pdbFilesToAnnotate != SingleStrandsBrowser.this.pdbFilesAnnotated) return;
            SingleStrandsBrowser.this.create.setEnabled(true);
        }
    }
}

