/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.labels;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.labels.AbstractLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceLabel
extends AbstractLabel {
    public Atom firstAtom = null;
    public Atom secondAtom = null;

    public DistanceLabel(Mediator mediator, Atom a, Atom b) {
        super(mediator);
        this.color = new OpenGLColor(Color.green);
        this.firstAtom = a;
        this.secondAtom = b;
        a.addAtomListener(this);
        b.addAtomListener(this);
        this.compute();
    }

    @Override
    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(Arrays.asList(this.firstAtom, this.secondAtom));
    }

    @Override
    void compute() {
        for (int i = 0; i < 3; ++i) {
            this.position[i] = (this.firstAtom.getFloat()[i] + this.secondAtom.getFloat()[i]) / 2.0f;
        }
        double tmp = TBMath.distance((float[])this.firstAtom.getFloat(), (float[])this.secondAtom.getFloat());
        this.value = "" + tmp;
        this.value = this.value.substring(0, this.value.lastIndexOf(".") + 4);
    }

    @Override
    public void draw(GL gl) {
        super.draw(gl);
        float min = 2.7f;
        float max = 3.1f;
        Color color = Color.WHITE;
        float[] p1 = this.firstAtom.getFloat();
        float[] p2 = this.secondAtom.getFloat();
        float[] m = TBMath.middle((float[])p1, (float[])p2);
        float d = TBMath.distance((float[])p1, (float[])m);
        float[] mm1 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p1), (float)(min / (2.0f * d)));
        float[] m1 = TBMath.sumVectors((float[])m, (float[])mm1);
        float[] mM1 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p1), (float)(max / (2.0f * d)));
        float[] M1 = TBMath.sumVectors((float[])m, (float[])mM1);
        float[] mm2 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p2), (float)(min / (2.0f * d)));
        float[] m2 = TBMath.sumVectors((float[])m, (float[])mm2);
        float[] mM2 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p2), (float)(max / (2.0f * d)));
        float[] M2 = TBMath.sumVectors((float[])m, (float[])mM2);
        OpenGLColor oglColor = new OpenGLColor(color);
        gl.glColor3fv(oglColor.getRGBOpenGl(), 0);
        gl.glLineWidth(0.5f);
        gl.glEnable(2852);
        gl.glLineStipple(1, (short)257);
        gl.glBegin(1);
        if (TBMath.distance((float[])p1, (float[])p2) < max) {
            gl.glVertex3fv(m1, 0);
            gl.glVertex3fv(m2, 0);
        } else {
            gl.glVertex3fv(p1, 0);
            gl.glVertex3fv(p2, 0);
        }
        gl.glEnd();
        gl.glDisable(2852);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glBegin(1);
        gl.glVertex3fv(m1, 0);
        gl.glVertex3fv(M1, 0);
        gl.glVertex3fv(m2, 0);
        gl.glVertex3fv(M2, 0);
        gl.glEnd();
    }
}

