/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.rendering;

import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColorException;
import java.awt.Color;

public class OpenGLColor {
    private int r = 0;
    private int g = 0;
    private int b = 0;
    private static int next = -1;

    public OpenGLColor(int r, int g, int b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public OpenGLColor(float r, float g, float b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public OpenGLColor(Color c) {
        this.setRGB(c);
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public float[] getRGBOpenGl() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public int[] getRGB() {
        return new int[]{this.r, this.g, this.b};
    }

    public void setRGB(int r, int g, int b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public void setRGB(float r, float g, float b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public void setRGB(float[] f) {
        this.setR(f[0]);
        this.setG(f[1]);
        this.setB(f[2]);
    }

    public void setR(int i) {
        try {
            if (i < 0 || i > 255) {
                throw new OpenGLColorException("Paramater : " + i + " not between boundaries [0:255]");
            }
            this.r = i;
        }
        catch (OpenGLColorException e) {
            e.printStackTrace();
        }
    }

    public void setG(int i) {
        try {
            if (i < 0 || i > 255) {
                throw new OpenGLColorException("Paramater : " + i + " not between boundaries [0:255]");
            }
            this.g = i;
        }
        catch (OpenGLColorException e) {
            e.printStackTrace();
        }
    }

    public void setB(int i) {
        try {
            if (i < 0 || i > 255) {
                throw new OpenGLColorException("Paramater : " + i + " not between boundaries [0:255]");
            }
            this.b = i;
        }
        catch (OpenGLColorException e) {
            e.printStackTrace();
        }
    }

    public void setR(float f) {
        try {
            if (f < 0.0f || f > 1.0f) {
                throw new OpenGLColorException("Paramater : " + f + " not between boundaries [0.0:1.0]");
            }
            this.r = (int)(f * 255.0f);
        }
        catch (OpenGLColorException e) {
            e.printStackTrace();
        }
    }

    public void setG(float f) {
        try {
            if (f < 0.0f || f > 1.0f) {
                throw new OpenGLColorException("Paramater : " + f + " not between boundaries [0.0:1.0]");
            }
            this.g = (int)(f * 255.0f);
        }
        catch (OpenGLColorException e) {
            e.printStackTrace();
        }
    }

    public void setB(float f) {
        try {
            if (f < 0.0f || f > 1.0f) {
                throw new OpenGLColorException("Paramater : " + f + " not between boundaries [0.0:1.0]");
            }
            this.b = (int)(f * 255.0f);
        }
        catch (OpenGLColorException e) {
            e.printStackTrace();
        }
    }

    public void setRGB(Color c) {
        this.r = c.getRed();
        this.g = c.getGreen();
        this.b = c.getBlue();
    }

    public Color getAWTColor() {
        return new Color(this.r, this.g, this.b);
    }

    public static OpenGLColor getRandomColor() {
        return new OpenGLColor((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public static OpenGLColor getNextColor() {
        return OpenGLColor.nextColor(++next);
    }

    public static OpenGLColor nextColor(int n) {
        switch (n %= 7) {
            case 0: {
                return new OpenGLColor(0.0f, 0.0f, 1.0f);
            }
            case 1: {
                return new OpenGLColor(1.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new OpenGLColor(0.0f, 1.0f, 0.0f);
            }
            case 3: {
                return new OpenGLColor(1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return new OpenGLColor(0.0f, 1.0f, 1.0f);
            }
            case 5: {
                return new OpenGLColor(1.0f, 1.0f, 0.0f);
            }
        }
        return new OpenGLColor(1.0f, 1.0f, 1.0f);
    }
}

