/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.rendering;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.GLUT;
import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.event.AtomListener;
import fr.unistra.ibmc.assemble.gui.event.DisplayParametersEvent;
import fr.unistra.ibmc.assemble.gui.event.DisplayParametersListener;
import fr.unistra.ibmc.assemble.gui.event.ModelListener;
import fr.unistra.ibmc.assemble.gui.event.RenderingListener;
import fr.unistra.ibmc.assemble.gui.labels.AtomLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Printing;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class Renderer
extends GLCanvas
implements GLEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ModelListener,
RenderingListener,
DisplayParametersListener {
    private transient Vector<DisplayParametersListener> parameterListeners;
    private boolean setGeneralPivot;
    private boolean setSelectionPivot;
    public static GLUT glut = new GLUT();
    public int DOT_ATOM_SIZE = 2;
    public int LINE_LINK_WIDTH = 2;
    public int LINE_BACKBONE_WIDTH = 2;
    public int BALL_COMPLEXITY = 32;
    public int CYLINDER_COMPLEXITY = 8;
    public float LINK_RADIUS = 0.2f;
    public float BALL_RADIUS = 0.2f;
    public float PAIR_RADIUS = 0.2f;
    public float BB_RADIUS = 0.5f;
    public int NURBS_U_COMPLEXITY = 4;
    public int NURBS_V_COMPLEXITY = 2;
    public static final int SELECT_PAIR_RESIDUE1 = 8;
    public static final int SELECT_PAIR_RESIDUE2 = 9;
    public static final int SELECT_RESIDUE_BACKBONE = 30;
    public static final int SELECT_RESIDUE_FIRST = 31;
    public static final int SELECT_RESIDUE_LAST = 32;
    public static final int SELECT_REMOVE_LINK_1 = 33;
    public static final int SELECT_REMOVE_LINK_2 = 34;
    public static final int SELECT_ADD_LINK_1 = 35;
    public static final int SELECT_ADD_LINK_2 = 36;
    public static final int SELECT_DELETE_MOLECULE = 47;
    public static final int SELECT_SUPERIMPOSE_ATOM_1 = 48;
    public static final int SELECT_SUPERIMPOSE_ATOM_2 = 49;
    public static final int SELECT_SOURCE_ATOM_1 = 50;
    public static final int SELECT_DEST_ATOM_1 = 51;
    public static final int SELECT_SOURCE_ATOM_2 = 52;
    public static final int SELECT_DEST_ATOM_2 = 53;
    public static final int SELECT_SOURCE_ATOM_3 = 54;
    public static final int SELECT_DEST_ATOM_3 = 55;
    public static final int SELECT_SOURCE_ATOM_4 = 56;
    public static final int SELECT_DEST_ATOM_4 = 57;
    float old_fps;
    private int scene;
    private int sphere;
    private int selSphere;
    private int selCube;
    private int ribbon;
    private int cylinder;
    public static int font = 7;
    public static int font2 = 5;
    private GL gl;
    private boolean reCompute = true;
    private float movePas = 0.1f;
    private float rotatePas = 1.0f;
    private GLU glu = new GLU();
    public int height;
    public int width;
    public int x;
    public int y;
    private float[] lightPosition = new float[]{0.0f, 0.0f, -1.0f, 1.0f};
    private float lightAmbient = 0.2f;
    private float lightSpecular = 0.8f;
    private float lightDiffuse = 0.5f;
    private float specularReflection = 0.35f;
    private int materialShininess = 80;
    public int selectBufferSize = 128;
    private boolean drawSelection = true;
    private OpenGLColor background = new OpenGLColor(Color.BLACK);
    public float[] AXIS_X = new float[]{1.0f, 0.0f, 0.0f};
    public float[] AXIS_Y = new float[]{0.0f, 1.0f, 0.0f};
    public float[] AXIS_Z = new float[]{0.0f, 0.0f, 1.0f};
    private int stereoMode;
    private int colorationStyle = 2;
    private int mouseSensitivity = 5;
    private boolean mapMotion = false;
    public boolean doRZ = false;
    public boolean doRXY = false;
    public boolean doRXYZ = false;
    public float angleR = 0.0f;
    public float xR = 0.0f;
    public float yR = 0.0f;
    public float zR = 0.0f;
    public float taille = 5.0f;
    public int near = 100;
    public int far = 1500;
    public float stereoAngle = 6.0f;
    public float stereoDistance = 0.0f;
    private Pivot generalPivot;
    private Pivot selectionPivot;
    private fr.unistra.ibmc.assemble.structures.Residue residueContainingSelectionPivot;
    public float[] trans = new float[]{0.0f, 0.0f, -500.0f};
    public float[] cum = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float deltax = 0.0f;
    public float deltay = 0.0f;
    public int xpos = 0;
    public int ypos = 0;
    static float sizeGL = 50.0f;
    public final float DST_MIN = -300.0f;
    public final float DST_MAX = 300.0f;
    public final float DEPTH_MIN = 0.1f;
    public final float DEPTH_MAX = 800.0f;
    public final float TAILLE_MIN = 0.01f;
    public final float TAILLE_MAX = 100.0f;
    public final float TRANS_MIN = -300.0f;
    public final float TRANS_MAX = 300.0f;
    private int rotationStep = 5;
    private float motionStep = 1.0f;
    private boolean fog = false;
    private int nbNurbs = 0;
    private int renderMode = 7168;
    public GLAutoDrawable drawable;
    int lastPosX = 0;
    private int xpressed = 0;
    private int ypressed = 0;
    private boolean mustLight = false;
    private boolean torsion = false;
    private DihedralAngle dihedralAngle = null;
    public int[] textures = new int[1];
    private Mediator mediator;
    private boolean isShiftDown;
    private Frame f;
    private ClickOperation clickOperation;
    public float StereoEyeSep = 4.0f;
    public float StereoAperture = 45.0f;
    public float StereoFocal = 100.0f;
    public float StereoNear = 10.0f;
    public float StereoFar = 2000.0f;

    public Renderer(GLCapabilities caps, Mediator mediator) {
        super(caps, null, null, null);
        this.generalPivot = new Pivot(new OpenGLColor(Color.WHITE).getRGBOpenGl());
        this.selectionPivot = new Pivot(new OpenGLColor(Color.GREEN).getRGBOpenGl());
        this.mediator = mediator;
        this.clickOperation = new ClickOperation();
        this.addGLEventListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addDisplayParametersListener(this);
    }

    public void reinit() {
        this.movePas = 0.1f;
        this.rotatePas = 1.0f;
        this.lightAmbient = 0.2f;
        this.lightSpecular = 0.8f;
        this.lightDiffuse = 0.5f;
        this.specularReflection = 0.35f;
        this.materialShininess = 80;
        this.selectBufferSize = 128;
        this.background = new OpenGLColor(Color.BLACK);
        this.colorationStyle = 2;
        this.mouseSensitivity = 5;
        this.mapMotion = false;
        this.doRZ = false;
        this.doRXY = false;
        this.doRXYZ = false;
        this.angleR = 0.0f;
        this.xR = 0.0f;
        this.yR = 0.0f;
        this.zR = 0.0f;
        this.near = 100;
        this.far = 1500;
        this.trans = new float[]{0.0f, 0.0f, -500.0f};
        this.cum = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        this.deltax = 0.0f;
        this.deltay = 0.0f;
        this.xpos = 0;
        this.ypos = 0;
        this.renderMode = 7168;
        this.lastPosX = 0;
        this.xpressed = 0;
        this.ypressed = 0;
        this.mustLight = false;
        this.torsion = false;
        this.dihedralAngle = null;
        this.textures = new int[1];
        this.gl.glCallList(this.scene);
        this.gl.glFlush();
        this.gl.glCallList(this.ribbon);
        this.gl.glFlush();
        this.gl.glCallList(this.cylinder);
        this.gl.glFlush();
        this.gl.glCallList(this.sphere);
        this.gl.glFlush();
        this.gl.glCallList(this.selCube);
        this.gl.glFlush();
        this.gl.glCallList(this.selSphere);
        this.gl.glFlush();
        float[] bg = this.background.getRGBOpenGl();
        this.gl.glClearColor(bg[0], bg[1], bg[2], 1.0f);
        this.gl.glClear(16640);
        this.gl.glFlush();
        this.reinitPivots();
        this.reComputeNeeded();
    }

    public void init(GLAutoDrawable drawable) {
        this.setStereoMode(0);
        this.drawable = drawable;
        this.gl = drawable.getGL();
        this.gl.glEnable(2929);
        this.gl.glEnable(2884);
        if (this.gl.glIsEnabled(2896)) {
            this.gl.glDisable(2896);
        }
        this.gl.glEnable(16384);
        this.gl.glEnable(2977);
        this.gl.glEnable(2903);
        this.setLight();
        this.scene = this.gl.glGenLists(1);
        this.sphere = this.gl.glGenLists(1);
        this.selSphere = this.gl.glGenLists(1);
        this.selCube = this.gl.glGenLists(1);
        this.ribbon = this.gl.glGenLists(1);
        this.cylinder = this.gl.glGenLists(1);
        this.setBALL_COMPLEXITY(24);
        this.setCYLINDER_COMPLEXITY(24);
        this.gl.glNewList(this.sphere, 4864);
        this.drawKynesSphere(this.BALL_COMPLEXITY, this.BALL_COMPLEXITY / 2);
        this.gl.glEndList();
        this.gl.glNewList(this.selSphere, 4864);
        this.gl.glLineWidth(0.25f);
        this.drawKynesSphere(8, 6);
        this.gl.glEndList();
        this.gl.glNewList(this.cylinder, 4864);
        this.drawFilledCylinder(1, this.CYLINDER_COMPLEXITY);
        this.gl.glEndList();
        this.gl.glNewList(this.selCube, 4864);
        this.gl.glLineWidth(0.25f);
        this.drawCubeMesh(0.1f);
        this.gl.glEndList();
    }

    public void setSelectMode(int mode) {
        this.clickOperation.setSelectMode(mode);
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        this.width = (int)d.getWidth();
        this.height = (int)d.getHeight();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void resetCum() {
        this.cum = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public boolean getDrawSelection() {
        return this.drawSelection;
    }

    public void setDrawSelection(boolean b) {
        this.drawSelection = b;
        this.reComputeNeeded();
    }

    public void display(GLAutoDrawable drawable) {
        try {
            if (this.mediator.get3DModel() == null) {
                this.gl.glCallList(this.scene);
                float[] bg = this.background.getRGBOpenGl();
                this.gl.glClearColor(bg[0], bg[1], bg[2], 1.0f);
                this.gl.glClear(16640);
                this.gl.glFlush();
            } else {
                switch (this.renderMode) {
                    case 7168: {
                        if (this.isMustLight()) {
                            this.setLight();
                        }
                        this.gl.glMatrixMode(5888);
                        this.setSceneRotation();
                        float[] bg = this.background.getRGBOpenGl();
                        this.gl.glClearColor(bg[0], bg[1], bg[2], 1.0f);
                        this.gl.glClear(16640);
                        this.applyFog();
                        this.displayEye(3);
                        if (this.stereoMode != 0) {
                            this.displayEye(4);
                        }
                        this.gl.glFlush();
                        break;
                    }
                    case 7170: {
                        this.picking();
                    }
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        Thread.yield();
    }

    public boolean isFogActivated() {
        return this.fog;
    }

    public void setFog(boolean f) {
        this.fog = f;
    }

    public boolean isFog() {
        return this.fog;
    }

    void setSceneRotation() {
        if (this.doRZ) {
            this.applyRotation(3, -this.deltax * (float)this.mouseSensitivity / 10.0f);
            this.doRZ = false;
        }
        if (this.doRXY) {
            this.applyRotation(1, this.deltay * (float)this.mouseSensitivity / 10.0f);
            this.applyRotation(2, this.deltax * (float)this.mouseSensitivity / 10.0f);
            this.doRXY = false;
        }
        if (this.doRXYZ) {
            this.applyRotation(this.angleR, this.xR, this.yR, this.zR);
            this.doRXYZ = false;
        }
    }

    void displayEye(int st) {
        this.setViewport(st);
        this.gl.glPushMatrix();
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        switch (this.stereoMode) {
            case 0: {
                this.setProjectionMono();
                break;
            }
            case 1: {
                this.setProjectionSplit(1 - 2 * st);
                break;
            }
            case 2: {
                this.setProjectionOverlap(1 - 2 * st);
            }
        }
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glTranslatef(this.trans[0], this.trans[1], this.trans[2]);
        if (st == 4) {
            this.gl.glRotatef(this.stereoAngle, 0.0f, 1.0f, 0.0f);
        }
        this.gl.glMultMatrixf(this.cum, 0);
        this.generalPivot.translateBack(this.gl);
        this.gl.glCullFace(1029);
        if (this.reCompute && this.mediator.get3DModel() != null) {
            this.reCompute = false;
            this.gl.glNewList(this.scene, 4864);
            this.mediator.get3DModel().draw(this.gl);
            if (this.drawSelection) {
                this.mediator.getGlobalSelection().draw(this.gl);
            }
            this.gl.glEndList();
        }
        this.generalPivot.draw(this.gl);
        this.selectionPivot.draw(this.gl);
        this.gl.glCallList(this.scene);
        if (this.mediator.getDensityMap() != null) {
            this.mediator.getDensityMap().draw(this.gl);
        }
        this.gl.glPopMatrix();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        Dimension d = this.f.getComponent(0).getSize();
        this.x = x;
        this.y = y;
        this.width = d.width;
        this.height = d.height;
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void applyTranslation(int axis, float delta) {
        switch (axis) {
            case 4: {
                this.trans[0] = this.trans[0] + delta;
                break;
            }
            case 5: {
                this.trans[1] = this.trans[1] + delta;
                break;
            }
            case 6: {
                this.trans[2] = this.trans[2] + delta;
            }
        }
    }

    public float[] getTranslation() {
        return this.trans;
    }

    public void setTranslation(float[] t) {
        System.arraycopy(t, 0, this.trans, 0, 3);
    }

    public void applyRotation(int axis, float preDelta) {
        float delta = preDelta * (float)this.mouseSensitivity / 10.0f;
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        switch (axis) {
            case 1: {
                this.gl.glRotatef(delta, 1.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                this.gl.glRotatef(delta, 0.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                this.gl.glRotatef(delta, 0.0f, 0.0f, 1.0f);
            }
        }
        this.gl.glMultMatrixf(this.cum, 0);
        this.gl.glGetFloatv(2982, this.cum, 0);
        this.AXIS_X = TBMath.normalized((float[])new float[]{this.cum[0], this.cum[4], this.cum[8]});
        this.AXIS_Y = TBMath.normalized((float[])new float[]{this.cum[1], this.cum[5], this.cum[9]});
        this.AXIS_Z = TBMath.normalized((float[])new float[]{this.cum[2], this.cum[6], this.cum[10]});
        this.gl.glPopMatrix();
    }

    public void applyRotation(float preDelta, float x, float y, float z) {
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glRotatef(preDelta, x, y, z);
        this.gl.glMultMatrixf(this.cum, 0);
        this.gl.glGetFloatv(2982, this.cum, 0);
        this.AXIS_X = TBMath.normalized((float[])new float[]{this.cum[0], this.cum[4], this.cum[8]});
        this.AXIS_Y = TBMath.normalized((float[])new float[]{this.cum[1], this.cum[5], this.cum[9]});
        this.AXIS_Z = TBMath.normalized((float[])new float[]{this.cum[2], this.cum[6], this.cum[10]});
        this.gl.glPopMatrix();
    }

    public void changeNearPlane(float value) {
        this.near = (int)((float)this.near + value);
    }

    public void changeFarPlane(float value) {
        this.far = (int)((float)this.far + value);
    }

    public void changeSlab(float value) {
        this.near = (int)((float)this.near + value);
        this.far = (int)((float)this.far - value);
    }

    public int getNear() {
        return this.near;
    }

    public int getFar() {
        return this.far;
    }

    void setLight() {
        this.gl.glLightfv(16384, 4608, new float[]{this.lightAmbient, this.lightAmbient, this.lightAmbient}, 0);
        this.gl.glLightfv(16384, 4610, new float[]{this.lightSpecular, this.lightSpecular, this.lightSpecular}, 0);
        this.gl.glLightfv(16384, 4609, new float[]{this.lightDiffuse, this.lightDiffuse, this.lightDiffuse}, 0);
        this.gl.glLightfv(16384, 4611, this.lightPosition, 0);
        this.gl.glMaterialfv(1028, 4610, new float[]{this.specularReflection, this.specularReflection, this.specularReflection, 1.0f}, 0);
        this.gl.glMateriali(1028, 5633, this.materialShininess);
        this.mustLight = false;
    }

    public void applyFog() {
        if (this.fog) {
            this.gl.glDepthFunc(513);
            this.gl.glFogi(2917, 9729);
            this.gl.glFogf(2915, this.generalPivot.coord[2] - 100.0f);
            this.gl.glFogf(2916, this.generalPivot.coord[2] + 100.0f);
            this.gl.glFogfv(2918, this.background.getRGBOpenGl(), 0);
            if (!this.gl.glIsEnabled(2912)) {
                this.gl.glEnable(2912);
            }
        } else if (this.gl.glIsEnabled(2912)) {
            this.gl.glDisable(2912);
        }
    }

    public void picking() {
        IntBuffer selectBuffer = BufferUtil.newIntBuffer((int)this.selectBufferSize);
        int[] viewport = new int[4];
        this.gl.glSelectBuffer(this.selectBufferSize, selectBuffer);
        this.gl.glRenderMode(7170);
        if (this.mediator.get3DModel() != null) {
            int st = 3;
            int x = this.xpos;
            int y = this.height - this.ypos;
            if ((this.stereoMode == 1 || this.stereoMode == 2) && x > this.width / 2) {
                st = 4;
            }
            this.setViewport(st);
            this.gl.glGetIntegerv(2978, viewport, 0);
            this.gl.glPushMatrix();
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.glu.gluPickMatrix((double)x, (double)y, (double)(4 + this.mediator.getRenderer().getDOT_ATOM_SIZE()), (double)(4 + this.mediator.getRenderer().getDOT_ATOM_SIZE()), viewport, 0);
            switch (this.stereoMode) {
                case 0: {
                    this.setProjectionMono();
                    break;
                }
                case 1: {
                    this.setProjectionSplit(1 - 2 * st);
                    break;
                }
                case 2: {
                    this.setProjectionOverlap(1 - 2 * st);
                }
            }
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            this.gl.glTranslatef(this.trans[0], this.trans[1], this.trans[2]);
            if (st == 4) {
                this.gl.glRotatef(this.stereoAngle, 0.0f, 1.0f, 0.0f);
            }
            this.gl.glMultMatrixf(this.cum, 0);
            this.generalPivot.translateBack(this.gl);
            this.gl.glInitNames();
            this.gl.glPushName(0);
            this.mediator.get3DModel().drawSelectScene(this.gl);
            this.gl.glPopMatrix();
            this.gl.glFlush();
        }
        int hits = this.gl.glRenderMode(7168);
        this.clickOperation.selectAtom(hits, selectBuffer, this.isShiftDown);
        this.renderMode = 7168;
    }

    public void setProjectionMono() {
        float dY = sizeGL / this.taille;
        float dX = sizeGL / this.taille * (float)this.width / (float)this.height;
        this.gl.glOrtho((double)(-dX), (double)dX, (double)(-dY), (double)dY, (double)this.near, (double)this.far);
    }

    public void setProjectionSplit(int st) {
        float dY = sizeGL / this.taille;
        float dX = dY * (float)this.width / (float)this.height * 0.5f;
        this.gl.glOrtho((double)(-dX + (float)st * this.stereoDistance), (double)(dX + (float)st * this.stereoDistance), (double)(-dY), (double)dY, (double)this.near, (double)this.far);
    }

    public void setProjectionOverlap(int st) {
        float dY = sizeGL / this.taille;
        float dX = dY * (float)this.width / (float)this.height;
        this.gl.glOrtho((double)(-dX + (float)st * this.stereoDistance), (double)(dX + (float)st * this.stereoDistance), (double)(-dY), (double)dY, (double)this.near, (double)this.far);
    }

    public void setViewport(int st) {
        block0 : switch (this.stereoMode) {
            case 0: 
            case 2: {
                this.gl.glViewport(0, 0, this.width, this.height);
                this.gl.glScissor(0, 0, this.width, this.height);
                break;
            }
            case 1: {
                switch (st) {
                    case 3: {
                        this.gl.glViewport(0, 0, this.width / 2, this.height);
                        this.gl.glScissor(0, 0, this.width / 2, this.height);
                        break block0;
                    }
                    case 4: {
                        this.gl.glViewport(this.width / 2, 0, this.width / 2, this.height);
                        this.gl.glScissor(this.width / 2, 0, this.width / 2, this.height);
                    }
                }
            }
        }
    }

    public void changeStereoDistance(float value) {
        this.stereoDistance += value;
        if (this.stereoDistance > 300.0f) {
            this.stereoDistance = 300.0f;
        }
        if (this.stereoDistance < -300.0f) {
            this.stereoDistance = -300.0f;
        }
    }

    public void changeStereoAngle(float value) {
        this.stereoAngle += value;
    }

    public void changeZoom(float value) {
        this.taille = (float)((double)this.taille * Math.pow(10.0, value / 100.0f));
        if (this.taille < 0.01f) {
            this.taille = 0.01f;
        }
        if (this.taille > 100.0f) {
            this.taille = 100.0f;
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
        this.isShiftDown = e.isShiftDown();
        if (e.getX() == this.xpressed && e.getY() == this.ypressed) {
            if ((e.getModifiers() & 0x10) != 0) {
                this.renderMode = 7170;
            }
            if ((e.getModifiers() & 4) != 0) {
                if (Assemble.KEY_FOR_SHORTCUTS == 0 ? e.isAltDown() : e.isControlDown()) {
                    this.setSelectionPivot = true;
                } else {
                    this.setGeneralPivot = true;
                }
                this.renderMode = 7170;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.xpos = e.getX();
        this.ypos = e.getY();
        this.xpressed = e.getX();
        this.ypressed = e.getY();
        this.lastPosX = e.getX();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.requestFocus();
        this.deltax = e.getX() - this.xpos;
        this.deltay = e.getY() - this.ypos;
        this.xpos = e.getX();
        this.ypos = e.getY();
        int mouseMotion = -1;
        int m = e.getModifiers();
        int ex = e.getModifiersEx();
        if ((m & 0x10) != 0 && (ex & (Assemble.KEY_FOR_SHORTCUTS == 0 ? 512 : 128)) != 0) {
            mouseMotion = 2;
        } else if ((m & 0x10) != 0) {
            mouseMotion = 6;
        } else if ((m & 4) != 0 && (ex & (Assemble.KEY_FOR_SHORTCUTS == 0 ? 512 : 128)) != 0) {
            mouseMotion = 3;
        } else if ((m & 4) != 0 && (ex & 0x40) != 0) {
            mouseMotion = 5;
        } else if ((m & 4) != 0) {
            mouseMotion = 7;
        } else if ((m & 8) != 0) {
            mouseMotion = 8;
        }
        switch (mouseMotion) {
            case 6: {
                if ((float)this.ypos > 0.15f * (float)this.height) {
                    this.doRXY = true;
                    break;
                }
                this.doRZ = true;
                break;
            }
            case 7: {
                this.applyTranslation(4, this.deltax * (float)this.mouseSensitivity / 100.0f);
                this.applyTranslation(5, -(this.deltay * (float)this.mouseSensitivity) / 100.0f);
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.changeStereoAngle(this.deltax / 5.0f);
                break;
            }
            case 5: {
                this.changeStereoDistance(this.deltax / 5.0f);
                break;
            }
            case 9: {
                this.changeNearPlane(this.deltay);
                break;
            }
            case 10: {
                this.changeFarPlane(this.deltay);
                break;
            }
            case 2: {
                if ((float)this.ypos > 0.15f * (float)this.height) {
                    this.mediator.getGlobalSelection().rotate(TBMath.normalized((float[])new float[]{-this.cum[0], -this.cum[4], -this.cum[8]}), this.rotatePas * this.deltay);
                    this.mediator.getGlobalSelection().rotate(TBMath.normalized((float[])new float[]{-this.cum[1], -this.cum[5], -this.cum[9]}), this.rotatePas * this.deltax);
                } else {
                    this.mediator.getGlobalSelection().rotate(TBMath.normalized((float[])new float[]{this.cum[2], this.cum[6], this.cum[10]}), this.rotatePas * this.deltax);
                }
                this.mediator.get3DModel().fireModelModified();
                break;
            }
            case 3: {
                float[] translation = new float[]{this.movePas * (this.deltax * this.cum[0] - this.deltay * this.cum[1]), this.movePas * (this.deltax * this.cum[4] - this.deltay * this.cum[5]), this.movePas * (this.deltax * this.cum[8] - this.deltay * this.cum[9])};
                this.mediator.getGlobalSelection().translate(translation);
                this.mediator.get3DModel().fireModelModified();
                break;
            }
            case 4: {
                this.mediator.getGlobalSelection().translate(new float[]{this.movePas * (this.deltay * this.cum[2]), this.movePas * (this.deltay * this.cum[6]), this.movePas * (this.deltay * this.cum[10])});
                this.mediator.get3DModel().fireModelModified();
                break;
            }
            case 12: {
                if ((float)this.ypos > 0.15f * (float)this.height) {
                    this.mediator.rotateMap(TBMath.normalized((float[])new float[]{-this.cum[0], -this.cum[4], -this.cum[8]}), this.rotatePas * this.deltay);
                    this.mediator.rotateMap(TBMath.normalized((float[])new float[]{-this.cum[1], -this.cum[5], -this.cum[9]}), this.rotatePas * this.deltax);
                    break;
                }
                this.mediator.rotateMap(TBMath.normalized((float[])new float[]{this.cum[2], this.cum[6], this.cum[10]}), this.rotatePas * this.deltax);
                break;
            }
            case 13: {
                this.mediator.translateMap(new float[]{this.movePas * (this.deltax * this.cum[0] - this.deltay * this.cum[1]), this.movePas * (this.deltax * this.cum[4] - this.deltay * this.cum[5]), this.movePas * (this.deltax * this.cum[8] - this.deltay * this.cum[9])});
                break;
            }
            case 14: {
                this.mediator.translateMap(new float[]{this.movePas * (this.deltay * this.cum[2]), this.movePas * (this.deltay * this.cum[6]), this.movePas * (this.deltay * this.cum[10])});
                break;
            }
        }
        this.lastPosX = e.getX();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int rotation = this.lastPosX - e.getX();
        this.lastPosX = e.getX();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.changeZoom(e.getWheelRotation());
    }

    public void setGeneralPivot(Atom atom) {
        this.generalPivot.setPivot(atom);
        this.recenter();
        this.reComputeNeeded();
    }

    public void setGeneralPivot(float[] f) {
        if (f != null) {
            this.generalPivot.setPivot(f);
            this.recenter();
            this.reComputeNeeded();
        }
    }

    public void setSelectionPivot(float[] f) {
        this.selectionPivot.setPivot(f);
        this.reComputeNeeded();
    }

    public fr.unistra.ibmc.assemble.structures.Residue getResidueContainingSelectionPivot() {
        return this.residueContainingSelectionPivot;
    }

    public void setResidueContainingSelectionPivot(fr.unistra.ibmc.assemble.structures.Residue residueContainingSelectionPivot) {
        this.residueContainingSelectionPivot = residueContainingSelectionPivot;
    }

    public void reinitPivots() {
        int p = 0;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (this.mediator.get3DModel() != null) {
            for (Chain c : this.mediator.get3DModel().getChains()) {
                for (int j = 0; j < c.getLength(); ++j) {
                    fr.unistra.ibmc.assemble.structures.Residue r = c.getResidue(j);
                    for (Atom atom : r.getAtoms()) {
                        ++p;
                        float[] f = atom.getFloat();
                        x += f[0];
                        y += f[1];
                        z += f[2];
                    }
                }
            }
        }
        if (p != 0) {
            x /= (float)p;
            y /= (float)p;
            z /= (float)p;
        }
        this.setGeneralPivot(new float[]{x, y, z});
        this.setSelectionPivot(new float[]{x, y, z});
    }

    public void renderingModified() {
        this.reComputeNeeded();
    }

    public void reComputeNeeded() {
        this.reCompute = true;
    }

    public void setStereoMode(int st) {
        this.stereoMode = st;
    }

    public void parametersModified(DisplayParametersEvent e) {
        this.reComputeNeeded();
    }

    public void setCumMatrix(float[] f) {
        System.arraycopy(f, 0, this.cum, 0, 16);
    }

    public int getStereoMode() {
        return this.stereoMode;
    }

    public float[] getCumMatrix() {
        return this.cum;
    }

    public OpenGLColor getBackgroundColor() {
        return this.background;
    }

    public void setBackgroundColor(OpenGLColor bgcolor) {
        this.background.setRGB(bgcolor.getRGBOpenGl());
    }

    public int getColorationStyle() {
        return this.colorationStyle;
    }

    public void setColorationStyle(int colorationStyle) {
        this.colorationStyle = colorationStyle;
    }

    public void setLightAmbient(float v) {
        this.lightAmbient = v;
        this.setMustLight();
    }

    public void setLightSpecular(float v) {
        this.lightSpecular = v;
        this.setMustLight();
    }

    public void setLightDiffuse(float v) {
        this.lightDiffuse = v;
        this.setMustLight();
    }

    public void setSpecularReflection(float v) {
        this.specularReflection = v;
        this.setMustLight();
    }

    public float getSpecularReflection() {
        return this.specularReflection;
    }

    public float getLightAmbient() {
        return this.lightAmbient;
    }

    public float getLightSpecular() {
        return this.lightSpecular;
    }

    public float getLightDiffuse() {
        return this.lightDiffuse;
    }

    public void setMaterialShininess(int value) {
        this.materialShininess = value;
        this.setMustLight();
    }

    public int getMaterialShininess() {
        return this.materialShininess;
    }

    public boolean isMustLight() {
        return this.mustLight;
    }

    public void setMustLight() {
        this.mustLight = true;
    }

    public void beginNurbs() {
        ++this.nbNurbs;
    }

    public void endNurbs() {
        --this.nbNurbs;
    }

    public boolean isComputing() {
        return this.nbNurbs != 0;
    }

    public int getMouseSensitivity() {
        return this.mouseSensitivity;
    }

    public void setMouseSensitivity(int v) {
        this.mouseSensitivity = v;
    }

    public float[] getGeneralPivot() {
        return this.generalPivot.coord;
    }

    public float[] getSelectionPivot() {
        return this.selectionPivot.coord;
    }

    public void recenter() {
        this.trans[0] = 0.0f;
        this.trans[1] = 1.0f;
    }

    public void modelModified() {
        this.reComputeNeeded();
    }

    public void modelRejected() {
        this.reComputeNeeded();
    }

    public void setJFrame(Frame f) {
        this.f = f;
    }

    public Frame getFrame() {
        return this.f;
    }

    private void alterLists() {
        this.gl.glNewList(this.sphere, 4864);
        this.drawKynesSphere(this.BALL_COMPLEXITY, this.BALL_COMPLEXITY / 2);
        this.gl.glEndList();
        this.gl.glNewList(this.selSphere, 4864);
        this.gl.glLineWidth(0.25f);
        this.drawKynesSphere(8, 6);
        this.gl.glEndList();
        this.gl.glNewList(this.cylinder, 4864);
        this.drawFilledCylinder(1, this.CYLINDER_COMPLEXITY);
        this.gl.glEndList();
        this.gl.glNewList(this.selCube, 4864);
        this.gl.glLineWidth(0.25f);
        this.drawCubeMesh(0.1f);
        this.gl.glEndList();
    }

    private void drawFilledCylinder(int stacks, int slices) {
        float nsign = 1.0f;
        float da = (float)Math.PI * 2 / (float)slices;
        float dr = 0.0f;
        float dz = 1 / stacks;
        float nz = 0.0f;
        float z = 0.0f;
        float r = 1.0f;
        for (int j = 0; j < stacks; ++j) {
            this.gl.glBegin(8);
            for (int i = 0; i <= slices; ++i) {
                float y;
                float x;
                if (i == slices) {
                    x = (float)Math.sin(0.0);
                    y = (float)Math.cos(0.0);
                } else {
                    x = (float)Math.sin((float)i * da);
                    y = (float)Math.cos((float)i * da);
                }
                this.gl.glNormal3f(x * nsign, y * nsign, nz * nsign);
                this.gl.glVertex3f(x * r, y * r, z);
                this.gl.glNormal3f(x * nsign, y * nsign, nz * nsign);
                this.gl.glVertex3f(x * (r + dr), y * (r + dr), z + dz);
            }
            this.gl.glEnd();
            r += dr;
            z += dz;
        }
    }

    private void drawCubeMesh(float s) {
        float x = s / 2.0f;
        this.gl.glBegin(2);
        this.gl.glNormal3fv(new float[]{0.0f, 0.0f, -1.0f}, 0);
        this.gl.glVertex3f(-x, -x, -x);
        this.gl.glVertex3f(-x, x, -x);
        this.gl.glVertex3f(-x, x, x);
        this.gl.glVertex3f(-x, -x, x);
        this.gl.glNormal3fv(new float[]{0.0f, 0.0f, 1.0f}, 0);
        this.gl.glVertex3f(x, -x, x);
        this.gl.glVertex3f(x, x, x);
        this.gl.glVertex3f(x, x, -x);
        this.gl.glVertex3f(x, -x, -x);
        this.gl.glNormal3fv(new float[]{0.0f, -1.0f, 0.0f}, 0);
        this.gl.glVertex3f(-x, -x, -x);
        this.gl.glVertex3f(-x, -x, x);
        this.gl.glVertex3f(x, -x, x);
        this.gl.glVertex3f(x, -x, -x);
        this.gl.glNormal3fv(new float[]{0.0f, 1.0f, 0.0f}, 0);
        this.gl.glVertex3f(x, x, -x);
        this.gl.glVertex3f(x, x, x);
        this.gl.glVertex3f(-x, x, x);
        this.gl.glVertex3f(-x, x, -x);
        this.gl.glNormal3fv(new float[]{0.0f, 0.0f, -1.0f}, 0);
        this.gl.glVertex3f(-x, -x, -x);
        this.gl.glVertex3f(x, -x, -x);
        this.gl.glVertex3f(x, x, -x);
        this.gl.glVertex3f(-x, x, -x);
        this.gl.glNormal3fv(new float[]{0.0f, 0.0f, 1.0f}, 0);
        this.gl.glVertex3f(-x, x, x);
        this.gl.glVertex3f(x, x, x);
        this.gl.glVertex3f(x, -x, x);
        this.gl.glVertex3f(-x, -x, x);
        this.gl.glEnd();
    }

    public void drawCylinder(float[] a, float[] b, float radius) {
        float[] ba = TBMath.vector((float[])b, (float[])a);
        float[] normal = TBMath.crossProduct((float[])new float[]{0.0f, 0.0f, -1.0f}, (float[])ba);
        this.gl.glPushMatrix();
        this.gl.glTranslatef(a[0], a[1], a[2]);
        this.gl.glRotatef(TBMath.angle((float[])new float[]{0.0f, 0.0f, -1.0f}, (float[])ba) * (float)TBMath.RadianToDegree, normal[0], normal[1], normal[2]);
        this.gl.glScalef(radius, radius, TBMath.norm((float[])ba));
        this.gl.glCallList(this.cylinder);
        this.gl.glPopMatrix();
    }

    public void displaySphere(GL gl, float vdw, float[] a) {
        gl.glPushMatrix();
        gl.glTranslatef(a[0], a[1], a[2]);
        gl.glScalef(vdw, vdw, vdw);
        gl.glCallList(this.sphere);
        gl.glPopMatrix();
    }

    private void spriteSphere() {
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(0.0f, 0.0f);
        this.gl.glVertex3f(-0.5f, -0.5f, 0.0f);
        this.gl.glTexCoord2f(1.0f, 0.0f);
        this.gl.glVertex3f(0.5f, -0.5f, 0.0f);
        this.gl.glTexCoord2f(1.0f, 1.0f);
        this.gl.glVertex3f(0.5f, 0.5f, 0.0f);
        this.gl.glTexCoord2f(0.0f, 1.0f);
        this.gl.glVertex3f(-0.5f, 0.5f, 0.0f);
        this.gl.glEnd();
    }

    private void drawKynesSphere(int slice, int stack) {
        float sb;
        float sa;
        float cb;
        float ca;
        float b;
        float a;
        int i;
        this.gl.glBegin(6);
        this.gl.glNormal3f(0.0f, -1.0f, 0.0f);
        this.gl.glVertex3f(0.0f, -1.0f, 0.0f);
        for (i = 0; i <= slice; ++i) {
            a = (float)Math.PI * 2 * (float)i / (float)slice;
            b = (float)Math.PI / (float)stack;
            ca = (float)Math.cos(a);
            cb = (float)Math.cos(b);
            sa = (float)Math.sin(a);
            sb = (float)Math.sin(b);
            this.gl.glNormal3f(sb * ca, -cb, sb * sa);
            this.gl.glVertex3f(sb * ca, -cb, sb * sa);
        }
        this.gl.glEnd();
        this.gl.glBegin(6);
        this.gl.glNormal3f(0.0f, 1.0f, 0.0f);
        this.gl.glVertex3f(0.0f, 1.0f, 0.0f);
        for (i = slice; i >= 0; --i) {
            a = (float)Math.PI * 2 * (float)i / (float)slice;
            b = (float)Math.PI / (float)stack;
            ca = (float)Math.cos(a);
            cb = (float)Math.cos(b);
            sa = (float)Math.sin(a);
            sb = (float)Math.sin(b);
            this.gl.glNormal3f(sb * ca, cb, sb * sa);
            this.gl.glVertex3f(sb * ca, cb, sb * sa);
        }
        this.gl.glEnd();
        for (i = 1; i < stack - 1; ++i) {
            this.gl.glBegin(8);
            for (int j = 0; j <= slice; ++j) {
                for (j = 0; j <= slice; ++j) {
                    a = (float)Math.PI * 2 * (float)j / (float)slice;
                    b = (float)Math.PI * (float)i / (float)stack;
                    float c = b + (float)Math.PI / (float)stack;
                    float ca2 = (float)Math.cos(a);
                    float cb2 = (float)Math.cos(b);
                    float sa2 = (float)Math.sin(a);
                    float sb2 = (float)Math.sin(b);
                    float cc = (float)Math.cos(c);
                    float sc = (float)Math.sin(c);
                    this.gl.glNormal3f(sc * ca2, cc, sc * sa2);
                    this.gl.glVertex3f(sc * ca2, cc, sc * sa2);
                    this.gl.glNormal3f(sb2 * ca2, cb2, sb2 * sa2);
                    this.gl.glVertex3f(sb2 * ca2, cb2, sb2 * sa2);
                }
            }
            this.gl.glEnd();
        }
    }

    public void drawKynesSphereMesh(int slice, int stack) {
        float sb;
        float sa;
        float cb;
        float ca;
        float b;
        float a;
        int i;
        this.gl.glBegin(1);
        for (i = 0; i <= slice; ++i) {
            a = (float)Math.PI * 2 * (float)i / (float)slice;
            b = (float)Math.PI / (float)stack;
            ca = (float)Math.cos(a);
            cb = (float)Math.cos(b);
            sa = (float)Math.sin(a);
            sb = (float)Math.sin(b);
            this.gl.glNormal3f(0.0f, -1.0f, 0.0f);
            this.gl.glVertex3f(0.0f, -1.0f, 0.0f);
            this.gl.glNormal3f(sb * ca, -cb, sb * sa);
            this.gl.glVertex3f(sb * ca, -cb, sb * sa);
        }
        for (i = slice; i >= 0; --i) {
            a = (float)Math.PI * 2 * (float)i / (float)slice;
            b = (float)Math.PI / (float)stack;
            ca = (float)Math.cos(a);
            cb = (float)Math.cos(b);
            sa = (float)Math.sin(a);
            sb = (float)Math.sin(b);
            this.gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this.gl.glVertex3f(0.0f, 1.0f, 0.0f);
            this.gl.glNormal3f(sb * ca, cb, sb * sa);
            this.gl.glVertex3f(sb * ca, cb, sb * sa);
        }
        for (i = 1; i < stack - 1; ++i) {
            for (int j = 0; j <= slice; ++j) {
                for (j = 0; j <= slice; ++j) {
                    a = (float)Math.PI * 2 * (float)j / (float)slice;
                    b = (float)Math.PI * (float)i / (float)stack;
                    float c = b + (float)Math.PI / (float)stack;
                    float d = (float)Math.PI * 2 * (float)(j + 1) / (float)slice;
                    float ca2 = (float)Math.cos(a);
                    float cb2 = (float)Math.cos(b);
                    float sa2 = (float)Math.sin(a);
                    float sb2 = (float)Math.sin(b);
                    float cc = (float)Math.cos(c);
                    float sc = (float)Math.sin(c);
                    float cd = (float)Math.cos(d);
                    float sd = (float)Math.sin(d);
                    this.gl.glNormal3f(sc * ca2, cc, sc * sa2);
                    this.gl.glVertex3f(sc * ca2, cc, sc * sa2);
                    this.gl.glNormal3f(sb2 * ca2, cb2, sb2 * sa2);
                    this.gl.glVertex3f(sb2 * ca2, cb2, sb2 * sa2);
                    this.gl.glNormal3f(sb2 * ca2, cb2, sb2 * sa2);
                    this.gl.glVertex3f(sb2 * ca2, cb2, sb2 * sa2);
                    this.gl.glNormal3f(sb2 * cd, cb2, sb2 * sd);
                    this.gl.glVertex3f(sb2 * cd, cb2, sb2 * sd);
                    if (i != stack - 2) continue;
                    this.gl.glNormal3f(sc * ca2, cc, sc * sa2);
                    this.gl.glVertex3f(sc * ca2, cc, sc * sa2);
                    this.gl.glNormal3f(sc * cd, cc, sc * sd);
                    this.gl.glVertex3f(sc * cd, cc, sc * sd);
                }
            }
        }
        this.gl.glEnd();
    }

    public void drawSelectionSphere(GL gl, float[] a, float[] c, float size) {
        gl.glColor4f(0.0f, 1.0f, 0.0f, 0.45f);
        gl.glPushMatrix();
        gl.glTranslatef(a[0], a[1], a[2]);
        gl.glScalef(size, size, size);
        gl.glCallList(this.selSphere);
        float r = 1.0f / size;
        gl.glScalef(r, r, r);
        gl.glPopMatrix();
    }

    public void drawSelectionCube(GL gl, float[] a, float[] c) {
        gl.glColor4f(c[0], c[1], c[2], 0.55f);
        gl.glPushMatrix();
        gl.glTranslatef(a[0], a[1], a[2]);
        gl.glCallList(this.selCube);
        gl.glPopMatrix();
    }

    public void drawVector(GL gl, float[] pt, float[] v) {
        gl.glPushMatrix();
        gl.glTranslatef(pt[0], pt[1], pt[2]);
        gl.glBegin(1);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3fv(v, 0);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawRibbon(GL gl, float[] a, float[] b, float[] o) {
        float norm = TBMath.norm((float[])TBMath.vector((float[])a, (float[])b));
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glPushMatrix();
        float[] f = TBMath.normalized((float[])TBMath.vector((float[])b, (float[])a));
        float[] up = TBMath.normalized((float[])TBMath.vector((float[])a, (float[])o));
        float[] s = TBMath.crossProduct((float[])f, (float[])up);
        float[] u = TBMath.crossProduct((float[])s, (float[])f);
        float[] m = new float[]{s[0], s[1], s[2], 0.0f, u[0], u[1], u[2], 0.0f, -f[0], -f[1], -f[2], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        gl.glTranslatef(a[0], a[1], a[2]);
        gl.glMultMatrixf(m, 0);
        gl.glScalef(1.0f, 1.0f, norm);
        gl.glCallList(this.ribbon);
        gl.glPopMatrix();
    }

    public int getDOT_ATOM_SIZE() {
        return this.DOT_ATOM_SIZE;
    }

    public void setDOT_ATOM_SIZE(int DOT_ATOM_SIZE) {
        this.mediator.getRenderer().DOT_ATOM_SIZE = DOT_ATOM_SIZE;
        this.fireDisplayParametersModified();
    }

    public int getLINE_LINK_WIDTH() {
        return this.LINE_LINK_WIDTH;
    }

    public void setLINE_LINK_WIDTH(int LINE_LINK_WIDTH) {
        this.mediator.getRenderer().LINE_LINK_WIDTH = LINE_LINK_WIDTH;
        this.fireDisplayParametersModified();
    }

    public int getLINE_BACKBONE_WIDTH() {
        return this.LINE_BACKBONE_WIDTH;
    }

    public void setLINE_BACKBONE_WIDTH(int LINE_BACKBONE_WIDTH) {
        this.mediator.getRenderer().LINE_BACKBONE_WIDTH = LINE_BACKBONE_WIDTH;
        this.fireDisplayParametersModified();
    }

    public int getBALL_COMPLEXITY() {
        return this.BALL_COMPLEXITY;
    }

    public void setBALL_COMPLEXITY(int BALL_COMPLEXITY) {
        this.mediator.getRenderer().BALL_COMPLEXITY = BALL_COMPLEXITY;
        this.fireDisplayParametersModified();
    }

    public int getCYLINDER_COMPLEXITY() {
        return this.CYLINDER_COMPLEXITY;
    }

    public void setCYLINDER_COMPLEXITY(int CYLINDER_COMPLEXITY) {
        this.CYLINDER_COMPLEXITY = CYLINDER_COMPLEXITY;
        this.fireDisplayParametersModified();
    }

    public float getLINK_RADIUS() {
        return this.LINK_RADIUS;
    }

    public void setLINK_RADIUS(float LINK_RADIUS) {
        this.LINK_RADIUS = LINK_RADIUS;
        this.fireDisplayParametersModified();
    }

    public float getPAIR_RADIUS() {
        return this.PAIR_RADIUS;
    }

    public void setPAIR_RADIUS(float PAIR_RADIUS) {
        this.PAIR_RADIUS = PAIR_RADIUS;
        this.fireDisplayParametersModified();
    }

    public float getBB_RADIUS() {
        return this.BB_RADIUS;
    }

    public void setBB_RADIUS(float BB_RADIUS) {
        this.BB_RADIUS = BB_RADIUS;
        this.fireDisplayParametersModified();
    }

    public float getBALL_RADIUS() {
        return this.BALL_RADIUS;
    }

    public void setBALL_RADIUS(float BALL_RADIUS) {
        this.BALL_RADIUS = BALL_RADIUS;
        this.fireDisplayParametersModified();
    }

    public int getNURBS_U_COMPLEXITY() {
        return this.NURBS_U_COMPLEXITY;
    }

    public void setNURBS_U_COMPLEXITY(int NURBS_U_COMPLEXITY) {
        this.NURBS_U_COMPLEXITY = NURBS_U_COMPLEXITY;
        this.fireDisplayParametersModified();
    }

    public int getNURBS_V_COMPLEXITY() {
        return this.NURBS_V_COMPLEXITY;
    }

    public void setNURBS_V_COMPLEXITY(int NURBS_V_COMPLEXITY) {
        this.NURBS_V_COMPLEXITY = NURBS_V_COMPLEXITY;
        this.fireDisplayParametersModified();
    }

    public synchronized void addDisplayParametersListener(DisplayParametersListener l) {
        if (this.parameterListeners == null) {
            this.parameterListeners = new Vector();
        }
        this.parameterListeners.addElement(l);
    }

    public synchronized void removeDisplayParametersListener(RenderingListener l) {
        if (this.parameterListeners == null) {
            this.parameterListeners = new Vector();
        }
        this.parameterListeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDisplayParametersModified() {
        if (this.parameterListeners != null && !this.parameterListeners.isEmpty()) {
            Vector targets;
            DisplayParametersEvent event = new DisplayParametersEvent(this.getClass());
            Class<?> clazz = this.mediator.getRenderer().getClass();
            synchronized (clazz) {
                targets = (Vector)this.parameterListeners.clone();
            }
            for (DisplayParametersListener l : targets) {
                l.parametersModified(event);
            }
        }
    }

    private class ClickOperation {
        private Chain firstChain = null;
        private fr.unistra.ibmc.assemble.structures.Residue firstResidue = null;
        private Atom firstAtom = null;
        private Atom secondAtom = null;
        private Atom thirdAtom = null;
        private Atom[] superImpose = new Atom[7];
        public final String[] message = new String[]{"Click on the atom to select", "Click on the residue to select", "Click on the chain to select", "Click on the molecule to select", "Recentering the scene", "Click on the first chain", "Click on the second chain", "Click on the residue that will begin a new chain", "Click on the first residue to pair", "Click on the second residue to pair", "Click on the first atom (distance)", "Click on the second atom (distance)", "Click on the first atom (dihedralAngle)", "Click on the second atom (dihedralAngle)", "Click on the third atom (dihedralAngle)", "Click on the first atom (dihedre)", "Click on the second atom (dihedre)", "Click on the third atom (dihedre)", "Click on the fourth atom (dihedre)", "Click on the atom to delete", "Click on the residue to delete", "Click on the chain to delete", "Choose selection mode", "Click on a residue to twist it", "Select Atom who's label are to be removed", "Click on the first chain to pair", "Click on the second chain to pair", "Click on the atom to label", "Click on a chain you want to add in the group", "Click on the group you want to select", "Click on the new backbone atom of a residue", "Click on the new first atom of a residue", "Click on the new last atom of a residue", "Click on the first atom of the link to remove", "Click on the second atom of the link to remove", "Click on the first atom of the link to add", "Click on the second atom of the link to add", "Click on the first chain of Nucleic Acid you want to bind", "Click on the second chain of Nucleic Acid you want to bind", "Click on the first chain of Nucleic Acid you want to bind", "Click on the second chain of Nucleic Acid you want to bind", "Click on the chain you want to apply the motif on", "Click on the chain you want to save", "Click on the Building Block you want to move", "Click on the Building Block you want to move", "Click on the Chain", "Click on the Chain", "Click on the Molecule to Delete", "Click on the source Atom", "Click on the destination Atom", "Select the source atom #1", "Select the destination atom #1", "Select the source atom #2", "Select the destination atom #2", "Select the source atom #3", "Select the destination atom #3", "Select the source atom #4", "Select the destination atom #4", "Select the chain to fold in A-Form"};
        private int selectMode = 1;

        private ClickOperation() {
        }

        public void setSelectMode(int m) {
            this.selectMode = m;
        }

        public void selectAtom(int hits, IntBuffer buf, boolean isShiftDown) {
            if (hits == -1) {
                Printing.warning((String)"You can't select more than 128objects simultaneously, please rotate/translate/zoom so that you have less object under your cursor");
            } else if (hits > 0) {
                int[] object = null;
                int index = 0;
                for (int i = 0; i < hits; ++i) {
                    int stack = buf.get(index++);
                    ++index;
                    ++index;
                    object = new int[stack];
                    for (int j = 0; j < stack; ++j) {
                        object[j] = buf.get(index++);
                    }
                    Atom a = Renderer.this.mediator.get3DModel().getAtomByID(object[0]);
                    if (a == null || !a.getResidue().isDisplayed()) continue;
                    this.selectAtom(a, isShiftDown);
                    break;
                }
            }
        }

        public void selectAtom(Atom picked, boolean isShiftDown) {
            if (picked != null && picked.isDisplayed() && picked.getResidue().isDisplayed()) {
                if (Renderer.this.setGeneralPivot) {
                    Renderer.this.setGeneralPivot(picked);
                    Renderer.this.setGeneralPivot = false;
                    Renderer.this.mediator.get3DModel().fireRenderingModified();
                } else if (Renderer.this.setSelectionPivot) {
                    Renderer.this.setSelectionPivot(picked.getFloat());
                    Renderer.this.setResidueContainingSelectionPivot(picked.getResidue());
                    Renderer.this.setSelectionPivot = false;
                    Renderer.this.mediator.get3DModel().fireRenderingModified();
                } else {
                    if (!isShiftDown) {
                        Renderer.this.mediator.getGlobalSelection().clear();
                    }
                    switch (this.selectMode) {
                        case 0: {
                            Renderer.this.mediator.getGlobalSelection().add(picked);
                            Renderer.this.mediator.fireAtomsSelected(Renderer.this.mediator.getGlobalSelection(), new ArrayList<Atom>(Arrays.asList(picked)), isShiftDown);
                            Renderer.this.mediator.getGlobalSelection().fireRenderingModified();
                            break;
                        }
                        case 1: {
                            Renderer.this.mediator.getGlobalSelection().add(picked.getResidue());
                            Renderer.this.mediator.fireResiduesSelected(Renderer.this.mediator.getGlobalSelection(), new ArrayList<Residue>(Arrays.asList((Residue)picked.getResidue().getResidue3D().getResidues().iterator().next())), isShiftDown);
                            Renderer.this.mediator.getGlobalSelection().fireRenderingModified();
                            break;
                        }
                        case 2: {
                            Renderer.this.mediator.getGlobalSelection().add(picked.getResidue().getChain());
                            ArrayList<Residue> residues = new ArrayList<Residue>();
                            for (fr.unistra.ibmc.assemble.structures.Residue _r : picked.getResidue().getChain().getResidues()) {
                                residues.add((Residue)_r.getResidue3D().getResidues().iterator().next());
                            }
                            Renderer.this.mediator.fireResiduesSelected(Renderer.this.mediator.getGlobalSelection(), residues, isShiftDown);
                            Renderer.this.mediator.getGlobalSelection().fireRenderingModified();
                            break;
                        }
                        case 4: {
                            HashSet<Chain> chains = new HashSet<Chain>();
                            StructuralDomain sd = Renderer.this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((Residue)picked.getResidue().getResidue3D().getResidues().iterator().next());
                            List<Atom> atoms = Renderer.this.mediator.getAssemble().getAtomsForStructuralDomain(sd);
                            for (Atom a : atoms) {
                                chains.add(a.getResidue().getChain());
                            }
                            for (Chain c : chains) {
                                Renderer.this.mediator.getGlobalSelection().add(c);
                            }
                            Renderer.this.mediator.fireStructuralDomainSelected(Renderer.this.mediator.getGlobalSelection(), sd, isShiftDown);
                            Renderer.this.mediator.getGlobalSelection().fireRenderingModified();
                            break;
                        }
                        case 8: {
                            this.firstResidue = picked.getResidue();
                            this.setSelectMode(9);
                            break;
                        }
                        case 9: {
                            fr.unistra.ibmc.assemble.structures.Residue second = picked.getResidue();
                            if (this.firstResidue == null || second == null) break;
                            break;
                        }
                        case 30: {
                            picked.getResidue().backBone = picked;
                            break;
                        }
                        case 31: {
                            picked.getResidue().begining = picked;
                            break;
                        }
                        case 32: {
                            picked.getResidue().ending = picked;
                            break;
                        }
                        case 33: {
                            this.firstAtom = picked;
                            this.setSelectMode(34);
                            break;
                        }
                        case 34: {
                            this.firstAtom.getResidue().removeLink(this.firstAtom, picked);
                            Renderer.this.mediator.get3DModel().fireModelModified();
                            break;
                        }
                        case 35: {
                            this.firstAtom = picked;
                            this.setSelectMode(36);
                            break;
                        }
                        case 36: {
                            this.firstAtom.getResidue().links.add(Link.createLink(Renderer.this.mediator, this.firstAtom, picked));
                            Renderer.this.mediator.get3DModel().fireModelModified();
                            break;
                        }
                        case 48: {
                            this.firstAtom = picked;
                            this.setSelectMode(49);
                            Renderer.this.mediator.get3DModel().fireModelModified();
                            break;
                        }
                        case 49: {
                            Renderer.this.mediator.getGlobalSelection().translate(TBMath.vector((float[])this.firstAtom.getFloat(), (float[])picked.getFloat()));
                            Renderer.this.mediator.getRenderer().setGeneralPivot(this.firstAtom);
                            Renderer.this.mediator.get3DModel().fireModelModified();
                            break;
                        }
                        case 50: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[0] = picked;
                            this.setSelectMode(51);
                            break;
                        }
                        case 51: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[1] = picked;
                            this.setSelectMode(52);
                            break;
                        }
                        case 52: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[2] = picked;
                            this.setSelectMode(53);
                            break;
                        }
                        case 53: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[3] = picked;
                            this.setSelectMode(54);
                            break;
                        }
                        case 54: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[4] = picked;
                            this.setSelectMode(55);
                            break;
                        }
                        case 55: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[5] = picked;
                            this.setSelectMode(56);
                            break;
                        }
                        case 56: {
                            new AtomLabel(Renderer.this.mediator, picked);
                            this.superImpose[6] = picked;
                            this.setSelectMode(57);
                            break;
                        }
                        case 57: {
                            Renderer.this.mediator.getGlobalSelection().transform(TBMath.getTransformationMatrix((float[])this.superImpose[0].getFloat(), (float[])this.superImpose[1].getFloat(), (float[])this.superImpose[2].getFloat(), (float[])this.superImpose[3].getFloat(), (float[])this.superImpose[4].getFloat(), (float[])this.superImpose[5].getFloat(), (float[])this.superImpose[6].getFloat(), (float[])picked.getFloat()));
                            Renderer.this.mediator.get3DModel().fireModelModified();
                        }
                    }
                }
            }
        }
    }

    private static class Pivot
    implements AtomListener {
        private Atom atom;
        private float[] coord = new float[]{0.0f, 0.0f, 0.0f};
        private float[] center = new float[]{0.0f, 0.0f, 0.0f};
        private float[] color;

        private Pivot(float[] color) {
            this.color = color;
        }

        private void setPivot(Atom atom) {
            if (this.atom != null) {
                this.atom.removeAtomListener(this);
            }
            this.atom = atom;
            this.atom.addAtomListener(this);
            this.coord = atom.getFloat();
            this.center = atom.getFloat();
        }

        private void removePivot(Atom atom) {
            if (this.atom == atom) {
                this.setPivot(atom.getFloat());
            }
        }

        private void setPivot(float[] f) {
            if (this.atom != null) {
                this.atom.removeAtomListener(this);
            }
            this.atom = null;
            this.coord = f;
            this.center = f;
        }

        public void translateBack(GL gl) {
            gl.glTranslatef(-this.center[0], -this.center[1], -this.center[2]);
        }

        public void translate(GL gl) {
            gl.glTranslatef(this.center[0], this.center[1], this.center[2]);
        }

        public void translate(float[] step) {
            this.coord[0] = this.coord[0] + step[0];
            this.coord[1] = this.coord[1] + step[1];
            this.coord[2] = this.coord[2] + step[2];
        }

        public void draw(GL gl) {
            gl.glLineWidth(1.0f);
            gl.glColor3f(this.color[0], this.color[1], this.color[2]);
            gl.glBegin(1);
            gl.glVertex3f(this.coord[0] - 0.5f, this.coord[1], this.coord[2]);
            gl.glVertex3f(this.coord[0] + 0.5f, this.coord[1], this.coord[2]);
            gl.glVertex3f(this.coord[0], this.coord[1] - 0.5f, this.coord[2]);
            gl.glVertex3f(this.coord[0], this.coord[1] + 0.5f, this.coord[2]);
            gl.glVertex3f(this.coord[0], this.coord[1], this.coord[2] - 0.5f);
            gl.glVertex3f(this.coord[0], this.coord[1], this.coord[2] + 0.5f);
            gl.glEnd();
        }

        public void atomMoved() {
            this.coord = this.atom.getFloat();
        }
    }
}

