/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.maps;

import java.util.HashMap;

public class ContourLevel {
    private int[] levels;
    private float min = Float.MAX_VALUE;
    private float max = -this.min;
    private int size;

    public ContourLevel(int size) {
        this.size = size;
        this.levels = new int[size];
    }

    public void add(float v) {
        if (v > this.max || v < this.min) {
            this.changeMinMax(v);
        }
        this.addValue(v, 1);
    }

    private void addValue(float v, int times) {
        int col = this.size / 2;
        if (this.min != this.max) {
            col = (int)((float)this.size * (v - this.min) / (this.max - this.min));
            if (col > this.size - 1) {
                col = this.size - 1;
            }
            if (col < 0) {
                col = 0;
            }
        }
        int n = col;
        this.levels[n] = this.levels[n] + times;
    }

    public void changeMinMax(float v) {
        HashMap<Float, Integer> map = new HashMap<Float, Integer>();
        float oldC = (this.max - this.min) / (float)this.size;
        float oldMin = this.min;
        for (int i = 0; i < this.levels.length; ++i) {
            float val = oldMin + ((float)i + 0.5f) * oldC;
            if (this.levels[i] <= 0) continue;
            map.put(Float.valueOf(val), this.levels[i]);
            this.levels[i] = 0;
        }
        if (this.max < v) {
            this.max = v;
        }
        if (this.min > v) {
            this.min = v;
        }
        for (Float val : map.keySet()) {
            this.addValue(val.floatValue(), (Integer)map.get(val));
        }
    }

    public int[] rawLevels() {
        return this.levels;
    }

    public float[] logLevels() {
        float[] ret = new float[this.size];
        int maxVal = 0;
        for (int level : this.levels) {
            if (level <= maxVal) continue;
            maxVal = level;
        }
        double log = Math.log(maxVal);
        for (int i = 0; i < this.size; ++i) {
            ret[i] = (float)(Math.log(this.levels[i]) / log);
        }
        return ret;
    }

    public int getSize() {
        return this.size;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }
}

