/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.maps;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.maps.Cell;
import fr.unistra.ibmc.assemble.maps.ContourLevel;
import fr.unistra.ibmc.assemble.maps.Cube;
import fr.unistra.ibmc.assemble.maps.Map;
import fr.unistra.ibmc.assemble.maps.Tables;
import fr.unistra.ibmc.assemble.maps.Triangle;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;

public class EDMap
implements Map {
    private static int ID_NUM = 100;
    private long lastPolygonisation = 0L;
    Mediator mediator;
    private float[] translation = new float[]{0.0f, 0.0f, 0.0f};
    private float[] rotation = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private boolean relativeToPivotDrawing;
    private final int LIST_DENSITY_ALPHA;
    private final int LIST_DENSITY_MESH;
    private final int LIST_DENSITY_DOT;
    private float alpha = 1.0f;
    private OpenGLColor color = new OpenGLColor(Color.RED);
    private int renderingMode = 2;
    private ContourLevel contourLevel;
    Crystal crystal;
    int cellSize = 25;
    String filename;
    int nX;
    int nY;
    int nZ;
    int sX;
    int sY;
    int sZ;
    int mX;
    int mY;
    int mZ;
    float oX = 0.0f;
    float oY = 0.0f;
    float oZ = 0.0f;
    Cell[][][] cells;
    float[] cellA;
    float[] cellB;
    float[][][] densities;
    List<String> labels = new ArrayList<String>();
    private float isolevel;
    private int granularity;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int radius = 50;
    private boolean mustCompute = false;
    private boolean isValid = false;

    public EDMap(Mediator mediator) {
        this.LIST_DENSITY_ALPHA = ID_NUM++;
        this.LIST_DENSITY_MESH = ID_NUM++;
        this.LIST_DENSITY_DOT = ID_NUM++;
        this.mediator = mediator;
        this.contourLevel = new ContourLevel(128);
        this.granularity = 1;
    }

    public float[] getCenter() {
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        int triangleNb = 0;
        Cell[][][] arr$ = this.cells;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Cell[][] cell2;
            Cell[][] arr$2 = cell2 = arr$[i$];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Cell[] cell1;
                for (Cell cell : cell1 = arr$2[i$2]) {
                    for (Triangle t : cell.getTriangles()) {
                        ++triangleNb;
                        float[] triangleCenter = t.getCenter();
                        for (int i = 0; i < 3; ++i) {
                            int n = i;
                            center[n] = center[n] + triangleCenter[i];
                        }
                    }
                }
            }
        }
        if (triangleNb != 0) {
            for (int i = 0; i < 3; ++i) {
                center[i] = center[i] / (float)triangleNb;
            }
            return center;
        }
        return null;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public String getName() {
        return new File(this.filename).getName();
    }

    public ContourLevel getContourLevel() {
        return this.contourLevel;
    }

    public void setLastPolygonisation(long time) {
        this.lastPolygonisation = time;
    }

    public boolean checkTime(long time) {
        return time == this.lastPolygonisation;
    }

    public float[][][] getDensities() {
        return this.densities;
    }

    public void isRelativeToPivotDrawing(boolean b) {
        this.relativeToPivotDrawing = b;
    }

    public void setMustCompute(boolean mustCompute) {
        this.mustCompute = mustCompute;
    }

    public int getDivX() {
        return this.nX;
    }

    public int getDivY() {
        return this.nY;
    }

    public int getDivZ() {
        return this.nZ;
    }

    public int getDimX() {
        return this.mX;
    }

    public int getDimY() {
        return this.mY;
    }

    public int getDimZ() {
        return this.mZ;
    }

    public int getMinX() {
        return this.sX;
    }

    public int getMinY() {
        return this.sY;
    }

    public int getMinZ() {
        return this.sZ;
    }

    public int getMaxX() {
        return this.sX + this.mX - 1;
    }

    public int getMaxY() {
        return this.sY + this.mY - 1;
    }

    public int getMaxZ() {
        return this.sZ + this.mZ - 1;
    }

    public int getSpread() {
        return Math.min(Math.min(this.densities.length, this.densities[0].length), this.densities[0][0].length);
    }

    public int getRadius() {
        return this.radius;
    }

    public float getIsolevel() {
        return this.isolevel;
    }

    public void setIsolevel(float isolevel) {
        this.isolevel = isolevel;
        this.mustCompute = true;
    }

    public static int readInt(DataInputStream in) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] b = new byte[4];
        in.read(b, 0, 4);
        bb.put(b[3]);
        bb.put(b[2]);
        bb.put(b[1]);
        bb.put(b[0]);
        return bb.getInt(0);
    }

    public static float readDensity(int mode, DataInputStream in) throws IOException {
        switch (mode) {
            case 0: {
                return in.readByte();
            }
            case 1: {
                ByteBuffer bb = ByteBuffer.allocate(2);
                byte[] b = new byte[2];
                in.read(b, 0, 2);
                bb.put(b[1]);
                bb.put(b[0]);
                return bb.getShort(0);
            }
        }
        ByteBuffer bb2 = ByteBuffer.allocate(4);
        byte[] b2 = new byte[4];
        in.read(b2, 0, 4);
        bb2.put(b2[3]);
        bb2.put(b2[2]);
        bb2.put(b2[1]);
        bb2.put(b2[0]);
        return bb2.getFloat(0);
    }

    public static short readShort(DataInputStream in) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(2);
        byte[] b = new byte[2];
        in.read(b, 0, 2);
        bb.put(b[1]);
        bb.put(b[0]);
        return bb.getShort(0);
    }

    public static float readFloat(DataInputStream in) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] b = new byte[4];
        in.read(b, 0, 4);
        bb.put(b[3]);
        bb.put(b[2]);
        bb.put(b[1]);
        bb.put(b[0]);
        return bb.getFloat(0);
    }

    public static char readChar(DataInputStream in) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] b = new byte[4];
        in.read(b, 0, 4);
        bb.put(b[3]);
        bb.put(b[2]);
        bb.put(b[1]);
        bb.put(b[0]);
        return bb.getChar(0);
    }

    public static char readShortChar(DataInputStream in) throws IOException {
        byte b = in.readByte();
        if (b == 0) {
            return ' ';
        }
        return ("" + (char)b).charAt(0);
    }

    public static String readString(DataInputStream in, int length) throws IOException {
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = EDMap.readShortChar(in);
        }
        return new String(c);
    }

    public void parseXPLORMap(String filename) throws IOException, ParsingException {
        this.filename = filename;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        int nbl = 0;
        String p = in.readLine();
        ++nbl;
        if (p != null) {
            in.readLine();
            ++nbl;
            while (p.contains("!NTITLE") || p.contains("REMARKS") || p.trim().equals("")) {
                System.out.println(p);
                this.labels.add(p);
                p = in.readLine();
                ++nbl;
            }
        }
        if (p == null) {
            throw new ParsingException("Could not find the dimension of your map (make sure that you map is in ascii format and respects the supported standard)");
        }
        try {
            this.nX = this.readInt(p, 8, 0);
            this.sX = this.readInt(p, 8, 1);
            int maxX = this.readInt(p, 8, 2);
            this.nY = this.readInt(p, 8, 3);
            this.sY = this.readInt(p, 8, 4);
            int maxY = this.readInt(p, 8, 5);
            this.nZ = this.readInt(p, 8, 6);
            this.sZ = this.readInt(p, 8, 7);
            int maxZ = this.readInt(p, 8, 8);
            this.mX = maxX - this.sX + 1;
            this.mY = maxY - this.sY + 1;
            this.mZ = maxZ - this.sZ + 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ParsingException("Unable to read the dimension of the map from the line :  (make sure that you map is in ascii format and respects the supported standard)" + p);
        }
        if (this.mX == 0 || this.mY == 0 || this.mZ == 0) {
            throw new ParsingException("At least one of your dimension is null");
        }
        p = in.readLine();
        ++nbl;
        try {
            this.cellA = new float[]{this.readFloat(p, 12, 0), this.readFloat(p, 12, 1), this.readFloat(p, 12, 2)};
            this.cellB = new float[]{this.readFloat(p, 12, 3), this.readFloat(p, 12, 4), this.readFloat(p, 12, 5)};
        }
        catch (Exception ex) {
            throw new ParsingException("Unable to read the axes length/angle from the line : (#" + nbl + ")" + p + " (make sure that you map is in ascii format and respects the supported standard)");
        }
        p = in.readLine();
        ++nbl;
        if (!p.substring(0, 3).equals("ZYX")) {
            throw new ParsingException("Missing ZYX line after the length/angle (make sure that you map is in ascii format and respects the supported standard)");
        }
        this.densities = new float[this.mX][this.mY][this.mZ];
        for (int c = 0; c < this.mZ; ++c) {
            p = in.readLine();
            ++nbl;
            int nl = 0;
            for (int b = 0; b < this.mY; ++b) {
                for (int a = 0; a < this.mX; ++a) {
                    float dens;
                    if (nl % 6 == 0) {
                        p = in.readLine();
                        ++nbl;
                        if (p == null) {
                            throw new ParsingException("Not enough lines in your file  (make sure that you map is in ascii format and respects the supported standard)");
                        }
                    }
                    try {
                        dens = this.readFloat(p, 12, nl % 6);
                        ++nl;
                    }
                    catch (Exception ex) {
                        throw new ParsingException("Could not read the density (" + c + "," + b + "," + a + ") from the line (#" + nbl + ")\": " + p + " (make sure that you map is in ascii format and respects the supported standard)");
                    }
                    this.densities[a][b][c] = dens;
                    this.contourLevel.add(dens);
                }
            }
        }
        in.close();
        this.minX = this.sX;
        this.minY = this.sY;
        this.minZ = this.sZ;
        this.maxX = this.sX + this.mX - 1;
        this.maxY = this.sY + this.mY - 1;
        this.maxZ = this.sZ + this.mZ - 1;
        this.setCrystal();
        this.setCell();
        this.isValid = true;
    }

    public void parseMRCMap(String filename) throws IOException, ParsingException {
        int i;
        this.filename = filename;
        DataInputStream in = new DataInputStream(new FileInputStream(filename));
        this.nX = EDMap.readInt(in);
        this.nY = EDMap.readInt(in);
        this.nZ = EDMap.readInt(in);
        int mode = EDMap.readInt(in);
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new ParsingException("Mode is " + mode + " and should be 0 (byte), 1 (short int) or 2 (float)");
        }
        this.sX = EDMap.readInt(in);
        this.sY = EDMap.readInt(in);
        this.sZ = EDMap.readInt(in);
        this.mX = EDMap.readInt(in);
        this.mY = EDMap.readInt(in);
        this.mZ = EDMap.readInt(in);
        this.cellA = new float[]{EDMap.readFloat(in), EDMap.readFloat(in), EDMap.readFloat(in)};
        this.cellB = new float[]{EDMap.readFloat(in), EDMap.readFloat(in), EDMap.readFloat(in)};
        int mapc = EDMap.readInt(in);
        int mapr = EDMap.readInt(in);
        int maps = EDMap.readInt(in);
        float dMin = EDMap.readFloat(in);
        float dMax = EDMap.readFloat(in);
        float dMean = EDMap.readFloat(in);
        short ispg = EDMap.readShort(in);
        short nsymbt = EDMap.readShort(in);
        int next = EDMap.readInt(in);
        short creatID = EDMap.readShort(in);
        for (int i2 = 0; i2 < 30; ++i2) {
            in.readByte();
        }
        short nInt = EDMap.readShort(in);
        short nReal = EDMap.readShort(in);
        for (int i3 = 0; i3 < 28; ++i3) {
            in.readByte();
        }
        short idType = EDMap.readShort(in);
        short lens = EDMap.readShort(in);
        short nd1 = EDMap.readShort(in);
        short nd2 = EDMap.readShort(in);
        short vd1 = EDMap.readShort(in);
        short vd2 = EDMap.readShort(in);
        float[] tilt = new float[6];
        for (int i4 = 0; i4 < 6; ++i4) {
            tilt[i4] = EDMap.readFloat(in);
        }
        this.oX = EDMap.readFloat(in);
        this.oY = EDMap.readFloat(in);
        this.oZ = EDMap.readFloat(in);
        String map = EDMap.readString(in, 4);
        String machst = EDMap.readString(in, 4);
        float rms = EDMap.readFloat(in);
        int nlabl = EDMap.readInt(in);
        for (i = 0; i < 10; ++i) {
            String label = EDMap.readString(in, 80);
            this.labels.add(label);
        }
        for (i = 0; i < next; ++i) {
            in.readByte();
        }
        this.densities = new float[this.mX][this.mY][this.mZ];
        for (int z = 0; z < this.densities[0][0].length; ++z) {
            for (int y = 0; y < this.densities[0].length; ++y) {
                for (int x = 0; x < this.densities.length; ++x) {
                    float dens = EDMap.readDensity(mode, in);
                    this.contourLevel.add(dens);
                    this.densities[x][y][z] = dens;
                }
            }
        }
        in.close();
        this.minX = this.sX;
        this.minY = this.sY;
        this.minZ = this.sZ;
        this.maxX = this.sX + this.mX - 1;
        this.maxY = this.sY + this.mY - 1;
        this.maxZ = this.sZ + this.mZ - 1;
        this.setCrystal();
        this.setCell();
        this.isValid = true;
    }

    public void setCell() {
        int i;
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> ys = new ArrayList<Integer>();
        ArrayList<Integer> zs = new ArrayList<Integer>();
        int cellSize = 25;
        for (i = 0; i < this.mX - 1; i += cellSize) {
            xs.add(i);
        }
        xs.add(this.mX - 1);
        for (i = 0; i < this.mY - 1; i += cellSize) {
            ys.add(i);
        }
        ys.add(this.mY - 1);
        for (i = 0; i < this.mZ - 1; i += cellSize) {
            zs.add(i);
        }
        zs.add(this.mZ - 1);
        this.cells = new Cell[xs.size() - 1][ys.size() - 1][zs.size() - 1];
        for (i = 0; i < xs.size() - 1; ++i) {
            for (int j = 0; j < ys.size() - 1; ++j) {
                for (int k = 0; k < zs.size() - 1; ++k) {
                    this.cells[i][j][k] = new Cell(this.getCoordinates((Integer)xs.get(i), (Integer)ys.get(j), (Integer)zs.get(k)), this.getCoordinates((Integer)xs.get(i), (Integer)ys.get(j), (Integer)zs.get(k + 1)), this.getCoordinates((Integer)xs.get(i), (Integer)ys.get(j + 1), (Integer)zs.get(k)), this.getCoordinates((Integer)xs.get(i), (Integer)ys.get(j + 1), (Integer)zs.get(k + 1)), this.getCoordinates((Integer)xs.get(i + 1), (Integer)ys.get(j), (Integer)zs.get(k)), this.getCoordinates((Integer)xs.get(i + 1), (Integer)ys.get(j), (Integer)zs.get(k + 1)), this.getCoordinates((Integer)xs.get(i + 1), (Integer)ys.get(j + 1), (Integer)zs.get(k)), this.getCoordinates((Integer)xs.get(i + 1), (Integer)ys.get(j + 1), (Integer)zs.get(k + 1)));
                }
            }
        }
    }

    public void setCrystal() {
        this.crystal = new Crystal(this.cellA, this.cellB);
        this.crystal.update();
    }

    private float[] getCoordinates(int a, int b, int c) {
        float[] v = new float[]{(float)(a + this.sX) / (float)this.nX, (float)(b + this.sY) / (float)this.nY, (float)(c + this.sZ) / (float)this.nZ};
        return new float[]{this.crystal.fracToReal[0] * v[0] + this.crystal.fracToReal[1] * v[1] + this.crystal.fracToReal[2] * v[2] + this.oX, this.crystal.fracToReal[3] * v[0] + this.crystal.fracToReal[4] * v[1] + this.crystal.fracToReal[5] * v[2] + this.oY, this.crystal.fracToReal[6] * v[0] + this.crystal.fracToReal[7] * v[1] + this.crystal.fracToReal[8] * v[2] + this.oZ};
    }

    public int readInt(String s, int div, int n) throws Exception {
        return Integer.parseInt(s.substring(div * n, div * (n + 1)).trim());
    }

    public float readFloat(String s, int div, int n) throws Exception {
        return Float.parseFloat(s.substring(div * n, div * (n + 1)).trim());
    }

    private Cube getCube(int x, int y, int z, int step) {
        return new Cube(this.getCoordinates(x, y, z), this.densities[x][y][z], this.getCoordinates(x + step, y, z), this.densities[x + step][y][z], this.getCoordinates(x + step, y, z + step), this.densities[x + step][y][z + step], this.getCoordinates(x, y, z + step), this.densities[x][y][z + step], this.getCoordinates(x, y + step, z), this.densities[x][y + step][z], this.getCoordinates(x + step, y + step, z), this.densities[x + step][y + step][z], this.getCoordinates(x + step, y + step, z + step), this.densities[x + step][y + step][z + step], this.getCoordinates(x, y + step, z + step), this.densities[x][y + step][z + step]);
    }

    public void polygonise(long time) {
        int xMin = this.minX - this.sX;
        int xMax = this.maxX - this.sX;
        int yMin = this.minY - this.sY;
        int yMax = this.maxY - this.sY;
        int zMin = this.minZ - this.sZ;
        int zMax = this.maxZ - this.sZ;
        Cell[][][] arr$ = this.cells;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Cell[][] cell2;
            Cell[][] arr$2 = cell2 = arr$[i$];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Cell[] cell1;
                for (Cell cell : cell1 = arr$2[i$2]) {
                    cell.emptyTriangles();
                }
            }
        }
        if (this.relativeToPivotDrawing) {
            float[] pivot = this.mediator.getRenderer().getGeneralPivot();
            for (int x = xMin; x <= xMax - this.granularity; x += this.granularity) {
                float[] ob;
                float[] oa;
                if (!this.checkTime(time)) {
                    return;
                }
                float[] o = this.getCoordinates(x, 0, 0);
                if (!TBMath.planeIntersectsSphere((float[])o, (float[])(oa = this.getCoordinates(x, yMax - 2 - this.granularity, 0)), (float[])(ob = this.getCoordinates(x, 0, zMax - 2 - this.granularity)), (float[])pivot, (float)this.radius)) continue;
                for (int y = yMin; y <= yMax - this.granularity; y += this.granularity) {
                    float[] ysmax;
                    float[] ysmin = this.getCoordinates(x, y, 0);
                    if (!TBMath.lineIntersectsSphere((float[])ysmin, (float[])(ysmax = this.getCoordinates(x, y, zMax - 2 - this.granularity)), (float[])pivot, (float)this.radius)) continue;
                    for (int z = zMin; z <= zMax - this.granularity; z += this.granularity) {
                        if (!(TBMath.distance((float[])this.getCoordinates(x, y, z), (float[])pivot) <= (float)this.radius)) continue;
                        this.polygonise(this.getCube(x, y, z, this.granularity), this.cells[x / this.cellSize][y / this.cellSize][z / this.cellSize]);
                    }
                }
            }
        } else {
            for (int x = xMin; x <= xMax - this.granularity; x += this.granularity) {
                if (!this.checkTime(time)) {
                    return;
                }
                for (int y = yMin; y <= yMax - this.granularity; y += this.granularity) {
                    for (int z = zMin; z <= zMax - this.granularity; z += this.granularity) {
                        this.polygonise(this.getCube(x, y, z, this.granularity), this.cells[x / this.cellSize][y / this.cellSize][z / this.cellSize]);
                    }
                }
            }
        }
    }

    private int polygonise(Cube grid, Cell cell) {
        int nbTriangle = 0;
        float[][] vertlist = new float[12][3];
        int cubeindex = 0;
        if (grid.d[0] < this.isolevel) {
            cubeindex |= 1;
        }
        if (grid.d[1] < this.isolevel) {
            cubeindex |= 2;
        }
        if (grid.d[2] < this.isolevel) {
            cubeindex |= 4;
        }
        if (grid.d[3] < this.isolevel) {
            cubeindex |= 8;
        }
        if (grid.d[4] < this.isolevel) {
            cubeindex |= 0x10;
        }
        if (grid.d[5] < this.isolevel) {
            cubeindex |= 0x20;
        }
        if (grid.d[6] < this.isolevel) {
            cubeindex |= 0x40;
        }
        if (grid.d[7] < this.isolevel) {
            cubeindex |= 0x80;
        }
        if (Tables.edgeTable[cubeindex] == 0) {
            return 0;
        }
        if ((Tables.edgeTable[cubeindex] & 1) != 0) {
            vertlist[0] = this.vertexInterpolation(this.isolevel, grid.c[0], grid.d[0], grid.c[1], grid.d[1]);
        }
        if ((Tables.edgeTable[cubeindex] & 2) != 0) {
            vertlist[1] = this.vertexInterpolation(this.isolevel, grid.c[1], grid.d[1], grid.c[2], grid.d[2]);
        }
        if ((Tables.edgeTable[cubeindex] & 4) != 0) {
            vertlist[2] = this.vertexInterpolation(this.isolevel, grid.c[2], grid.d[2], grid.c[3], grid.d[3]);
        }
        if ((Tables.edgeTable[cubeindex] & 8) != 0) {
            vertlist[3] = this.vertexInterpolation(this.isolevel, grid.c[3], grid.d[3], grid.c[0], grid.d[0]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x10) != 0) {
            vertlist[4] = this.vertexInterpolation(this.isolevel, grid.c[4], grid.d[4], grid.c[5], grid.d[5]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x20) != 0) {
            vertlist[5] = this.vertexInterpolation(this.isolevel, grid.c[5], grid.d[5], grid.c[6], grid.d[6]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x40) != 0) {
            vertlist[6] = this.vertexInterpolation(this.isolevel, grid.c[6], grid.d[6], grid.c[7], grid.d[7]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x80) != 0) {
            vertlist[7] = this.vertexInterpolation(this.isolevel, grid.c[7], grid.d[7], grid.c[4], grid.d[4]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x100) != 0) {
            vertlist[8] = this.vertexInterpolation(this.isolevel, grid.c[0], grid.d[0], grid.c[4], grid.d[4]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x200) != 0) {
            vertlist[9] = this.vertexInterpolation(this.isolevel, grid.c[1], grid.d[1], grid.c[5], grid.d[5]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x400) != 0) {
            vertlist[10] = this.vertexInterpolation(this.isolevel, grid.c[2], grid.d[2], grid.c[6], grid.d[6]);
        }
        if ((Tables.edgeTable[cubeindex] & 0x800) != 0) {
            vertlist[11] = this.vertexInterpolation(this.isolevel, grid.c[3], grid.d[3], grid.c[7], grid.d[7]);
        }
        int i = 0;
        while (Tables.triTable[cubeindex][i] != -1) {
            Triangle tri = new Triangle(vertlist[Tables.triTable[cubeindex][i]], vertlist[Tables.triTable[cubeindex][i + 1]], vertlist[Tables.triTable[cubeindex][i + 2]]);
            cell.addTriangle(tri);
            ++nbTriangle;
            i += 3;
        }
        return nbTriangle;
    }

    float[] vertexInterpolation(float isolevel, float[] c1, float d1, float[] c2, float d2) {
        float[] p = new float[3];
        if ((double)Math.abs(isolevel - d1) < 1.0E-5) {
            return c1;
        }
        if ((double)Math.abs(isolevel - d2) < 1.0E-5) {
            return c2;
        }
        if ((double)Math.abs(d1 - d2) < 1.0E-5) {
            return c1;
        }
        float mu = (isolevel - d1) / (d2 - d1);
        p[0] = c1[0] + mu * (c2[0] - c1[0]);
        p[1] = c1[1] + mu * (c2[1] - c1[1]);
        p[2] = c1[2] + mu * (c2[2] - c1[2]);
        return p;
    }

    private float sqrt1f(float f) {
        if (f > 0.0f) {
            return (float)Math.sqrt(f);
        }
        return 0.0f;
    }

    public void setMode(int mode) {
        this.renderingMode = mode;
    }

    public boolean isRelativeToPivotDrawing() {
        return this.relativeToPivotDrawing;
    }

    public void draw(GL gl) {
        gl.glPushMatrix();
        gl.glTranslatef(this.translation[0], this.translation[1], this.translation[2]);
        gl.glMultMatrixf(this.rotation, 0);
        if (this.mustCompute) {
            if (this.cells != null) {
                Cell[] cell1;
                int i$;
                int len$;
                Cell[][] arr$;
                Cell[][] cell2;
                int i$2;
                gl.glNewList(this.LIST_DENSITY_ALPHA, 4864);
                gl.glBegin(4);
                Cell[][][] arr$2 = this.cells;
                int len$2 = arr$2.length;
                for (i$2 = 0; i$2 < len$2; ++i$2) {
                    arr$ = cell2 = arr$2[i$2];
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        for (Cell cell : cell1 = arr$[i$]) {
                            for (Triangle t : cell.getTriangles()) {
                                t.drawFaceVertices(gl);
                            }
                        }
                    }
                }
                gl.glEnd();
                gl.glEndList();
                gl.glNewList(this.LIST_DENSITY_MESH, 4864);
                gl.glLineWidth(0.1f);
                arr$2 = this.cells;
                len$2 = arr$2.length;
                for (i$2 = 0; i$2 < len$2; ++i$2) {
                    arr$ = cell2 = arr$2[i$2];
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        for (Cell cell : cell1 = arr$[i$]) {
                            for (Triangle t : cell.getTriangles()) {
                                gl.glBegin(2);
                                t.drawFaceVertices(gl);
                                gl.glEnd();
                            }
                        }
                    }
                }
                gl.glEndList();
                gl.glNewList(this.LIST_DENSITY_DOT, 4864);
                gl.glBegin(0);
                int xMin = this.minX - this.sX;
                int xMax = this.maxX - this.sX;
                int yMin = this.minY - this.sY;
                int yMax = this.maxY - this.sY;
                int zMin = this.minZ - this.sZ;
                int zMax = this.maxZ - this.sZ;
                if (this.relativeToPivotDrawing) {
                    float[] pivot = this.mediator.getRenderer().getGeneralPivot();
                    for (int x = xMin; x <= xMax - this.granularity; x += this.granularity) {
                        for (int y = yMin; y <= yMax - this.granularity; y += this.granularity) {
                            float[] ysmax;
                            float[] ysmin = this.getCoordinates(x, y, 0);
                            if (!TBMath.lineIntersectsSphere((float[])ysmin, (float[])(ysmax = this.getCoordinates(x, y, zMax - 2 - this.granularity)), (float[])pivot, (float)this.radius)) continue;
                            for (int z = zMin; z <= zMax - this.granularity; z += this.granularity) {
                                if (!(TBMath.distance((float[])this.mediator.getRenderer().getGeneralPivot(), (float[])this.getCoordinates(x, y, z)) < (float)this.radius) || !(this.densities[x][y][z] > this.isolevel)) continue;
                                gl.glColor3fv(this.getColor(this.densities[x][y][z]), 0);
                                gl.glVertex3fv(this.getCoordinates(x, y, z), 0);
                            }
                        }
                    }
                } else {
                    for (int x = xMin; x <= xMax - this.granularity; x += this.granularity) {
                        for (int y = yMin; y <= yMax - this.granularity; y += this.granularity) {
                            for (int z = zMin; z <= zMax - this.granularity; z += this.granularity) {
                                if (!(this.densities[x][y][z] > this.isolevel)) continue;
                                gl.glColor3fv(this.getColor(this.densities[x][y][z]), 0);
                                gl.glVertex3fv(this.getCoordinates(x, y, z), 0);
                            }
                        }
                    }
                }
                gl.glEnd();
                gl.glEndList();
            }
            this.mustCompute = false;
        }
        try {
            switch (this.renderingMode) {
                case 1: {
                    float[] color = this.color.getRGBOpenGl();
                    gl.glColor4f(color[0], color[1], color[2], this.alpha);
                    gl.glDisable(2884);
                    gl.glDepthMask(false);
                    gl.glBlendFunc(770, 772);
                    gl.glEnable(3042);
                    gl.glEnable(2896);
                    gl.glCallList(this.LIST_DENSITY_ALPHA);
                    gl.glDisable(2896);
                    gl.glDisable(3042);
                    gl.glDepthMask(true);
                    gl.glEnable(2884);
                    break;
                }
                case 2: {
                    gl.glColor4f(this.color.getRGBOpenGl()[0], this.color.getRGBOpenGl()[1], this.color.getRGBOpenGl()[2], this.alpha);
                    gl.glBlendFunc(770, 772);
                    gl.glEnable(3042);
                    gl.glEnable(2896);
                    gl.glCallList(this.LIST_DENSITY_MESH);
                    gl.glDisable(2896);
                    gl.glDisable(3042);
                    break;
                }
                case 4: {
                    gl.glCallList(this.LIST_DENSITY_DOT);
                }
            }
        }
        catch (NullPointerException npe) {
            System.err.println("Could not display the map " + this.getName() + " there was probably an error when reading the file");
        }
        gl.glPopMatrix();
    }

    private float[] getColor(float d) {
        float f = (d - this.isolevel) / (this.contourLevel.getMax() - this.isolevel);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if ((double)f < 0.125) {
            float v;
            g = v = f * 8.0f;
            b = 1.0f - g;
        } else if ((double)f < 0.25) {
            float v = (f - 0.125f) * 8.0f;
            g = 1.0f;
            r = v;
        } else {
            float v = (f - 0.25f) * 4.0f;
            r = 1.0f;
            g = 1.0f - v;
        }
        return new float[]{r, g, b};
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setColor(OpenGLColor color) {
        this.color = color;
    }

    public void setRelativeToPivotDrawing(boolean relativeToPivotDrawing) {
        this.relativeToPivotDrawing = relativeToPivotDrawing;
    }

    public OpenGLColor getColor() {
        return this.color;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void rotate(float[] axis, float pre) {
        float x = axis[0];
        float y = axis[1];
        float z = axis[2];
        float angle = (float)(TBMath.DegreeToRadian * (double)pre * (double)this.mediator.getRenderer().getMouseSensitivity() / 10.0);
        float c = 1.0f - (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float[] rot = new float[]{1.0f + c * (x * x - 1.0f), -z * s + c * x * y, y * s + c * x * z, 0.0f, z * s + c * x * y, 1.0f + c * (y * y - 1.0f), -x * s + c * y * z, 0.0f, -y * s + c * x * z, x * s + c * y * z, 1.0f + c * (z * z - 1.0f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        this.rotation = TBMath.multMatrices44((float[])this.rotation, (float[])rot);
    }

    public void translate(float[] v) {
        this.translation = TBMath.sumVectors((float[])this.translation, (float[])v);
    }

    public float[] getTranslation() {
        return this.translation;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public void setTranslation(float[] t) {
        this.translation = t;
    }

    public void setRotation(float[] r) {
        this.rotation = r;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public void setMaxZ(int maxZ) {
        this.maxZ = maxZ;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public void setMinZ(int minZ) {
        this.minZ = minZ;
    }

    private class Crystal {
        float[] dim;
        float[] angle;
        float[] realToFrac;
        float[] fracToReal;
        float unitCellVolume;
        float[] norm;
        float[] recipDim;

        public Crystal(float[] cellA, float[] cellB) {
            this.dim = cellA;
            this.angle = cellB;
            this.realToFrac = new float[9];
            this.fracToReal = new float[9];
            this.norm = new float[3];
            this.recipDim = new float[3];
        }

        public void init() {
            int a;
            for (a = 0; a < 9; ++a) {
                this.realToFrac[a] = 0.0f;
                this.fracToReal[a] = 0.0f;
            }
            for (a = 0; a < 3; ++a) {
                this.angle[a] = 90.0f;
                this.dim[a] = 1.0f;
                this.realToFrac[a + a * 3] = 1.0f;
                this.fracToReal[a + a * 3] = 1.0f;
            }
            this.unitCellVolume = 1.0f;
        }

        public void update() {
            int i;
            float[] cabg = new float[3];
            float[] sabg = new float[3];
            float[] cabgs = new float[3];
            if (this.angle[0] == 0.0f && this.angle[1] == 0.0f && this.angle[2] == 0.0f || this.dim[0] == 0.0f && this.dim[1] == 0.0f && this.dim[2] == 0.0f) {
                this.init();
                return;
            }
            for (i = 0; i < 9; ++i) {
                this.realToFrac[i] = 0.0f;
                this.fracToReal[i] = 0.0f;
            }
            for (i = 0; i < 3; ++i) {
                cabg[i] = (float)Math.cos((double)this.angle[i] * Math.PI / 180.0);
                sabg[i] = (float)Math.sin((double)this.angle[i] * Math.PI / 180.0);
            }
            cabgs[0] = (cabg[1] * cabg[2] - cabg[0]) / (sabg[1] * sabg[2]);
            cabgs[1] = (cabg[2] * cabg[0] - cabg[1]) / (sabg[2] * sabg[0]);
            cabgs[2] = (cabg[0] * cabg[1] - cabg[2]) / (sabg[0] * sabg[1]);
            this.unitCellVolume = this.dim[0] * this.dim[1] * this.dim[2] * EDMap.this.sqrt1f(1.0f + 2.0f * cabg[0] * cabg[1] * cabg[2] - (cabg[0] * cabg[0] + cabg[1] * cabg[1] + cabg[2] * cabg[2]));
            this.recipDim[0] = this.dim[1] * this.dim[2] * sabg[0] / this.unitCellVolume;
            this.recipDim[1] = this.dim[0] * this.dim[2] * sabg[1] / this.unitCellVolume;
            this.recipDim[2] = this.dim[0] * this.dim[1] * sabg[2] / this.unitCellVolume;
            float sabgs1 = EDMap.this.sqrt1f(1.0f - cabgs[0] * cabgs[0]);
            this.realToFrac[0] = 1.0f / this.dim[0];
            this.realToFrac[1] = -cabg[2] / (sabg[2] * this.dim[0]);
            this.realToFrac[2] = -(cabg[2] * sabg[1] * cabgs[0] + cabg[1] * sabg[2]) / (sabg[1] * sabgs1 * sabg[2] * this.dim[0]);
            this.realToFrac[4] = 1.0f / (sabg[2] * this.dim[1]);
            this.realToFrac[5] = cabgs[0] / (sabgs1 * sabg[2] * this.dim[1]);
            this.realToFrac[8] = 1.0f / (sabg[1] * sabgs1 * this.dim[2]);
            this.fracToReal[0] = this.dim[0];
            this.fracToReal[1] = cabg[2] * this.dim[1];
            this.fracToReal[2] = cabg[1] * this.dim[2];
            this.fracToReal[4] = sabg[2] * this.dim[1];
            this.fracToReal[5] = -sabg[1] * cabgs[0] * this.dim[2];
            this.fracToReal[8] = sabg[1] * sabgs1 * this.dim[2];
            this.norm[0] = EDMap.this.sqrt1f(this.realToFrac[0] * this.realToFrac[0] + this.realToFrac[1] * this.realToFrac[1] + this.realToFrac[2] * this.realToFrac[2]);
            this.norm[1] = EDMap.this.sqrt1f(this.realToFrac[3] * this.realToFrac[3] + this.realToFrac[4] * this.realToFrac[4] + this.realToFrac[5] * this.realToFrac[5]);
            this.norm[2] = EDMap.this.sqrt1f(this.realToFrac[6] * this.realToFrac[6] + this.realToFrac[7] * this.realToFrac[7] + this.realToFrac[8] * this.realToFrac[8]);
        }
    }
}

