/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.Symbol;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.utils.DrawingUtils;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

class Circle
extends Symbol {
    private static int steps = 30;
    private Point2D firstPoint;
    private Point2D centerPoint;

    Circle(Point2D firstPoint, Point2D centerPoint, char orientation, GraphicContext gc) {
        super(orientation, gc);
        this.firstPoint = firstPoint;
        this.centerPoint = centerPoint;
        this.shape = new GeneralPath();
        DoubleArray points = new DoubleArray(1);
        for (int i = 1; i <= steps; ++i) {
            Point2D point = DrawingUtils.getRotatedPoint(this.firstPoint, Math.PI * 2 / (double)steps * (double)i, this.centerPoint);
            points.add(point.getX());
            points.add(point.getY());
        }
        double[] coordinates = points.getArray();
        ((GeneralPath)this.shape).moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        for (int i = 0; i < coordinates.length; i += 2) {
            ((GeneralPath)this.shape).lineTo((float)coordinates[i], (float)coordinates[i + 1]);
        }
        ((GeneralPath)this.shape).closePath();
    }

    public String toSVG() {
        StringBuffer svg = new StringBuffer();
        svg.append("<circle " + super.getSVGStyle(this.getSVGColor()) + " cx=\"" + (this.centerPoint.getX() - this.gc.getViewX()) / this.gc.getFinalZoomLevel() + "\" cy=\"" + (this.centerPoint.getY() - this.gc.getViewY()) / this.gc.getFinalZoomLevel() + "\" r=\"" + DrawingUtils.getDistance(this.centerPoint, this.firstPoint) / this.gc.getFinalZoomLevel() + "\"/>\n");
        return svg.toString();
    }

    public String toString() {
        return "Circle";
    }

    private static class DoubleArray {
        private int position;
        private double[] array;

        private DoubleArray(int size) {
            this.array = new double[size];
        }

        private void add(double value) {
            if (this.position >= this.array.length) {
                double[] tmp = new double[this.array.length + (this.position + 1 - this.array.length)];
                System.arraycopy(this.array, 0, tmp, 0, this.array.length);
                this.array = tmp;
            }
            this.array[this.position++] = value;
        }

        private int length() {
            return this.array.length;
        }

        private double[] getArray() {
            return this.array;
        }
    }
}

