/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Line;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Symbol;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.utils.DrawingUtils;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Interaction2D
extends Rna2DElement {
    Point2D[] op = null;
    Point2D[] real_op = new Point2D[2];
    SymbolsArray defaultSymbol;
    SymbolsArray realSymbol;
    boolean drawRealSymbol = true;
    boolean updated;
    public static final Color DEFAULT_TERTIARY_INTERACTION_COLOR = Color.MAGENTA;
    public static final Color DEFAULT_SECONDARY_INTERACTION_COLOR = Helix2D.DEFAULT_COLOR;
    protected Residue residue1;
    protected Residue residue2;

    Interaction2D(Residues2DRepository repository, Residue residue1, Residue residue2, Mediator mediator, GraphicContext gc) {
        super(repository, mediator, gc);
        this.residue1 = residue1;
        this.residue2 = residue2;
        this.defaultSymbol = new SymbolsArray();
        this.realSymbol = new SymbolsArray();
        this.color = Color.GRAY;
        this.updated = true;
    }

    public void drawRealSymbol(boolean drawRealSymbol) {
        this.drawRealSymbol = true;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void isUpdated(boolean updated) {
        this.updated = updated;
    }

    @Override
    public boolean isInsideDrawingArea() {
        return this.getResidue().isInsideDrawingArea() || this.getPartnerResidue().isInsideDrawingArea();
    }

    public boolean isStrictlyInsideDrawingArea() {
        return this.getResidue().isStrictlyInsideDrawingArea() && this.getPartnerResidue().isStrictlyInsideDrawingArea();
    }

    @Override
    public void draw(Graphics2D g2) {
        if (!(!this.gc.isDrawOnlySelectedMotif() || this.isSelected() && this.isStrictlyInsideDrawingArea())) {
            return;
        }
        if (this.isDisplayed() && this.isInsideDrawingArea()) {
            if (this.updated) {
                this.setOutsidePoints();
                this.updated = false;
            }
            if (this.real_op != null) {
                this.op = new Point2D[2];
                this.op[0] = new Point2D.Double(this.real_op[0].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[0].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
                this.op[1] = new Point2D.Double(this.real_op[1].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[1].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
            } else {
                this.op = null;
            }
            if (this.isSelected() && !this.gc.isDrawOnlySelectedMotif()) {
                g2.setColor(Color.red);
            } else if (this.isDisplayed()) {
                g2.setColor(this.color);
            } else {
                g2.setColor(Color.GRAY);
            }
            SymbolsArray.Iterator sc = null;
            if (this.drawRealSymbol() && this.getRealSymbol() != null) {
                this.setRealSymbol();
                sc = this.getRealSymbol().iterator();
                while (sc.hasNext()) {
                    sc.next().draw(g2);
                }
            } else if (!this.drawRealSymbol() && this.getDefaultSymbol() != null) {
                this.setDefaultSymbol();
                sc = this.getDefaultSymbol().iterator();
                while (sc.hasNext()) {
                    sc.next().draw(g2);
                }
            }
            if (this.real_op != null && this.isSelected() && this.gc.isDrawOnlySelectedMotif()) {
                this.gc.addToSelectionArea(this.getArea().getBounds2D());
                this.gc.addInteractionFromMotif(this);
            }
        }
    }

    public boolean drawRealSymbol() {
        return this.drawRealSymbol;
    }

    protected SymbolsArray getDefaultSymbol() {
        return this.defaultSymbol;
    }

    protected SymbolsArray getRealSymbol() {
        return this.realSymbol;
    }

    @Override
    public Area getArea() {
        if (this.updated) {
            this.setOutsidePoints();
        }
        if (this.real_op != null) {
            this.op = new Point2D[2];
            this.op[0] = new Point2D.Double(this.real_op[0].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[0].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
            this.op[1] = new Point2D.Double(this.real_op[1].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[1].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
        }
        GeneralPath shape = new GeneralPath();
        if (this.op != null) {
            Point2D[] startPoints = DrawingUtils.getPerpendicular(this.op[0], this.getResidue().getCurrentCoordinates(), this.getPartnerResidue().getCurrentCoordinates(), this.gc.getCurrentSymbolSize() / 6.0);
            Point2D[] endPoints = DrawingUtils.getPerpendicular(this.op[1], this.getResidue().getCurrentCoordinates(), this.getPartnerResidue().getCurrentCoordinates(), this.gc.getCurrentSymbolSize() / 6.0);
            shape.moveTo((float)startPoints[0].getX(), (float)startPoints[0].getY());
            shape.lineTo((float)endPoints[0].getX(), (float)endPoints[0].getY());
            shape.lineTo((float)endPoints[1].getX(), (float)endPoints[1].getY());
            shape.lineTo((float)startPoints[1].getX(), (float)startPoints[1].getY());
            shape.lineTo((float)startPoints[0].getX(), (float)startPoints[0].getY());
            shape.closePath();
            return new Area(shape);
        }
        shape.moveTo((float)this.getResidue().getCurrentCenterX(), (float)(this.getResidue().getCurrentCenterY() - this.gc.getCurrentHeight() / 2.0));
        shape.lineTo((float)this.getResidue().getCurrentCenterX(), (float)(this.getResidue().getCurrentCenterY() + this.gc.getCurrentHeight() / 2.0));
        shape.lineTo((float)this.getPartnerResidue().getCurrentCenterX(), (float)(this.getPartnerResidue().getCurrentCenterY() + this.gc.getCurrentHeight() / 2.0));
        shape.lineTo((float)this.getPartnerResidue().getCurrentCenterX(), (float)(this.getPartnerResidue().getCurrentCenterY() - this.gc.getCurrentHeight() / 2.0));
        shape.lineTo((float)this.getResidue().getCurrentCenterX(), (float)(this.getResidue().getCurrentCenterY() - this.gc.getCurrentHeight() / 2.0));
        shape.closePath();
        return new Area(shape);
    }

    public Residue2D getResidue() {
        return this.repository.getResidue(this.residue1);
    }

    public Residue2D getPartnerResidue() {
        return this.repository.getResidue(this.residue2);
    }

    protected void setOutsidePoints() {
        Residue2D residue = this.repository.getResidue(this.residue1);
        Residue2D partnerResidue = this.repository.getResidue(this.residue2);
        if (residue.isDisplayed() && partnerResidue.isDisplayed()) {
            double dist = DrawingUtils.getDistance(residue.getRealX(), residue.getRealY(), partnerResidue.getRealX(), partnerResidue.getRealY());
            this.real_op = dist >= this.gc.getRealHalf() * 2.0 ? DrawingUtils.fit(residue.getRealCenterX(), residue.getRealCenterY(), partnerResidue.getRealCenterX(), partnerResidue.getRealCenterY(), this.gc.getRealHalf()) : null;
        } else if (!residue.isDisplayed() && partnerResidue.isDisplayed()) {
            this.real_op = DrawingUtils.fit(residue.getRealCenterX(), residue.getRealCenterY(), partnerResidue.getRealCenterX(), partnerResidue.getRealCenterY(), this.gc.getRealHalf());
            this.real_op[0] = residue.getRealCenter();
        } else if (!partnerResidue.isDisplayed() && residue.isDisplayed()) {
            this.real_op = DrawingUtils.fit(residue.getRealCenterX(), residue.getRealCenterY(), partnerResidue.getRealCenterX(), partnerResidue.getRealCenterY(), this.gc.getRealHalf());
            this.real_op[1] = partnerResidue.getRealCenter();
        } else {
            this.real_op = new Point2D[2];
            this.real_op[0] = residue.getRealCenter();
            this.real_op[1] = partnerResidue.getRealCenter();
        }
    }

    protected void setDefaultSymbol() {
        this.defaultSymbol.clear();
        if (this.op != null) {
            this.defaultSymbol.addSymbol(new Line(this.op[0], this.op[1], this.gc));
        }
    }

    protected abstract void setRealSymbol();

    protected abstract void setRealSymbol(Point2D var1, Point2D var2, double var3);

    @Override
    public String toSVG() {
        this.setOutsidePoints();
        if (this.real_op != null) {
            this.op = new Point2D[2];
            this.op[0] = new Point2D.Double(this.real_op[0].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[0].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
            this.op[1] = new Point2D.Double(this.real_op[1].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[1].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
        } else {
            this.op = null;
        }
        if (this.drawRealSymbol) {
            this.setRealSymbol();
            return this.toSVGReal();
        }
        this.setDefaultSymbol();
        return this.toSVGDefault();
    }

    protected String toSVGDefault() {
        StringBuffer svg = new StringBuffer();
        SymbolsArray.Iterator sc = this.defaultSymbol.iterator();
        while (sc.hasNext()) {
            svg.append(sc.next().toSVG());
        }
        return svg.toString();
    }

    protected String toSVGReal() {
        StringBuffer svg = new StringBuffer();
        SymbolsArray.Iterator sc = this.realSymbol.iterator();
        while (sc.hasNext()) {
            svg.append(sc.next().toSVG());
        }
        return svg.toString();
    }

    @Override
    public boolean contains(double x, double y) {
        Area area = this.getArea();
        if (area == null) {
            return false;
        }
        return area.contains(x, y);
    }

    @Override
    public List<Residue2D> getResidues() {
        ArrayList<Residue2D> residues = new ArrayList<Residue2D>();
        residues.add(this.repository.getResidue(this.residue1));
        residues.add(this.repository.getResidue(this.residue2));
        return residues;
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Interaction2D inter = (Interaction2D)obj;
        return this.residue1.equals((Object)inter.residue1) && this.residue2.equals((Object)inter.residue2) || this.residue1.equals((Object)inter.residue2) && this.residue2.equals((Object)inter.residue1);
    }

    class SymbolsArray {
        List symbols = new ArrayList();

        SymbolsArray() {
        }

        Iterator iterator() {
            return new Iterator();
        }

        void addSymbol(Symbol symbol) {
            this.symbols.add(symbol);
        }

        void clear() {
            this.symbols.clear();
        }

        int size() {
            return this.symbols.size();
        }

        class Iterator {
            java.util.Iterator it;

            Iterator() {
                this.it = SymbolsArray.this.symbols.iterator();
            }

            boolean hasNext() {
                return this.it.hasNext();
            }

            Symbol next() {
                return (Symbol)this.it.next();
            }
        }
    }
}

