/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Sequence2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.util.HashMap;
import java.util.Map;

public class Residues2DRepository {
    private Map<ParadiseID, Sequence2D> paradiseID2Sequence;
    protected Mediator mediator;
    protected GraphicContext gc;

    Residues2DRepository(SecondaryStructureDisplay display, Mediator mediator, GraphicContext gc) {
        this.mediator = mediator;
        this.gc = gc;
        this.paradiseID2Sequence = new HashMap<ParadiseID, Sequence2D>();
        for (fr.unistra.ibmc.paradise.core.features.Residue2D r : display.getResidues2D()) {
            this.addResidue2D(r);
        }
    }

    public void addResidue2D(fr.unistra.ibmc.paradise.core.features.Residue2D r) {
        Residue _r = (Residue)r.getResidues().iterator().next();
        Sequence2D seq = this.paradiseID2Sequence.get(_r.getMoleculeId());
        if (seq == null) {
            seq = new Sequence2D(_r.getMolecule().getLength());
            this.paradiseID2Sequence.put(_r.getMoleculeId(), seq);
        }
        seq.addResidue2D(r, this, this.mediator, this.gc);
    }

    public Residue2D getResidue(ParadiseID moleculeId, int absolutePosition) {
        Residue2D b = null;
        Sequence2D seq = this.paradiseID2Sequence.get(moleculeId);
        if (seq != null) {
            b = seq.getResidue(absolutePosition);
        }
        return b;
    }

    public Residue2D getResidue(Residue residue) {
        if (residue == null) {
            return null;
        }
        Residue2D b = null;
        Sequence2D seq = this.paradiseID2Sequence.get(residue.getMoleculeId());
        if (seq != null) {
            b = seq.getResidue(residue.getAbsolutePosition());
        }
        return b;
    }

    Residue2D[] getResidues(Residue[] residues) {
        Residue2D[] _residues = new Residue2D[residues.length];
        for (int i = 0; i < residues.length; ++i) {
            _residues[i] = this.getResidue(residues[i]);
        }
        return _residues;
    }
}

