/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.graphics;

import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.ssviewer.utils.DrawingUtils;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicContext {
    static final byte BASECOLOR = 0;
    static final byte STRUCTURECOLOR = 1;
    static final byte SEQUENCECOLOR = 2;
    static final byte INTERACTIONCOLOR = 3;
    private byte colorMode = 1;
    private Font f;
    double viewX;
    double viewY;
    double finalZoomLevel = 1.0;
    private static List<String> families2show;
    private boolean showFamily;
    private boolean displayFiveToThreeOrientation = true;
    private boolean displayLabels = true;
    private static boolean displayTertiaryInteractions;
    private Point2D gravityPoint;
    private Rectangle drawingArea;
    private double width;
    private double height;
    private double half = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
    private double symbolsize = 4.0 * this.width - 2.0 * this.half;
    private SecondaryCanvas canvas;
    private boolean drawOnlySelectedMotif;
    private List<Residue2D> selectedResiduesFromMotif;
    private List<Interaction2D> selectedInteractionsFromMotif;
    private Rectangle2D motifArea;

    GraphicContext(SecondaryCanvas canvas) {
        this(6.0, 9.0, canvas);
    }

    GraphicContext(double width, double height, SecondaryCanvas canvas) {
        this.width = width;
        this.height = height;
        this.half = Math.sqrt(width * width + height * height) / 2.0;
        this.symbolsize = 4.0 * width - 2.0 * this.half;
        this.canvas = canvas;
        this.selectedResiduesFromMotif = new ArrayList<Residue2D>();
        this.selectedInteractionsFromMotif = new ArrayList<Interaction2D>();
    }

    public void initialize() {
        for (Helix2D h2D : this.canvas.getModel2D().getHelices()) {
            this.intializeHelixCurrentContext(h2D);
        }
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isDrawOnlySelectedMotif() {
        return this.drawOnlySelectedMotif;
    }

    public void setDrawOnlySelectedMotif(boolean drawOnlySelectedMotif) {
        if (drawOnlySelectedMotif) {
            this.motifArea = null;
            this.selectedInteractionsFromMotif.clear();
            this.selectedResiduesFromMotif.clear();
        }
        this.drawOnlySelectedMotif = drawOnlySelectedMotif;
    }

    public Rectangle2D getMotifArea() {
        return this.motifArea;
    }

    public void addToSelectionArea(Rectangle2D area) {
        this.motifArea = this.motifArea == null ? area : this.motifArea.createUnion(area);
    }

    public void addInteractionFromMotif(Interaction2D interaction) {
        this.selectedInteractionsFromMotif.add(interaction);
    }

    public void addResidueFromMotif(Residue2D residue) {
        this.selectedResiduesFromMotif.add(residue);
    }

    public List<Residue2D> getSelectedResiduesFromMotif() {
        return new ArrayList<Residue2D>(this.selectedResiduesFromMotif);
    }

    public List<Interaction2D> getSelectedInteractionsFromMotif() {
        return new ArrayList<Interaction2D>(this.selectedInteractionsFromMotif);
    }

    public void intializeHelixCurrentContext(Helix2D h2D) {
        Residue2D[] _5PrimEnds = h2D.get5PrimeEnds();
        Residue2D _5PrimeEnd1 = _5PrimEnds[0];
        Residue2D _5PrimeEnd2 = _5PrimEnds[1];
        double length = DrawingUtils.getDistance(_5PrimeEnd1.getRealCoordinates(), h2D.get3PrimeEnd(_5PrimeEnd1).getRealCoordinates());
        Point2D[] _5 = DrawingUtils.fit(_5PrimeEnd1.getRealCoordinates(), h2D.get3PrimeEnd(_5PrimeEnd1).getRealCoordinates(), (length - this.height * (double)(h2D.getLength() - 1)) / 2.0);
        Point2D[] _3 = DrawingUtils.fit(_5PrimeEnd2.getRealCoordinates(), h2D.get3PrimeEnd(_5PrimeEnd2).getRealCoordinates(), (length - this.height * (double)(h2D.getLength() - 1)) / 2.0);
        h2D.setEnds(_5PrimeEnd1, _5[0], h2D.get3PrimeEnd(_5PrimeEnd1), _5[1], _5PrimeEnd2, _3[0], h2D.get3PrimeEnd(_5PrimeEnd2), _3[1]);
        double _width = DrawingUtils.getDistance(_5PrimeEnd1.getRealCoordinates(), h2D.getPairedResidue(_5PrimeEnd1).getRealCoordinates());
        _5 = DrawingUtils.fit(_5PrimeEnd1.getRealCoordinates(), h2D.getPairedResidue(_5PrimeEnd1).getRealCoordinates(), (_width - this.width * 4.0) / 2.0);
        _3 = DrawingUtils.fit(_5PrimeEnd2.getRealCoordinates(), h2D.getPairedResidue(_5PrimeEnd2).getRealCoordinates(), (_width - this.width * 4.0) / 2.0);
        h2D.setEnds(_5PrimeEnd1, _5[0], h2D.getPairedResidue(_5PrimeEnd1), _5[1], _5PrimeEnd2, _3[0], h2D.getPairedResidue(_5PrimeEnd2), _3[1]);
    }

    void moveView(double transX, double transY) {
        this.viewX += transX;
        this.viewY += transY;
    }

    void zoomParameters(double zoomFactor) {
        this.finalZoomLevel *= zoomFactor;
    }

    public double getCurrentWidth() {
        return this.width * this.finalZoomLevel;
    }

    public double getRealWidth() {
        return this.width;
    }

    public double getCurrentHeight() {
        return this.height * this.finalZoomLevel;
    }

    public double getRealHeight() {
        return this.height;
    }

    public double getCurrentSymbolSize() {
        return this.symbolsize * this.finalZoomLevel;
    }

    public double getRealSymbolSize() {
        return this.symbolsize;
    }

    public double getCurrentHalf() {
        return this.half * this.finalZoomLevel;
    }

    public double getRealHalf() {
        return this.half;
    }

    public Font getFont() {
        return new Font("Helvetica", 0, (int)this.getCurrentHeight());
    }

    public double getViewX() {
        return this.viewX;
    }

    public double getViewY() {
        return this.viewY;
    }

    Point2D getGravityPoint() {
        return this.gravityPoint;
    }

    public double getFinalZoomLevel() {
        return this.finalZoomLevel;
    }

    public static boolean containFamily(String family) {
        for (String f : families2show) {
            if (!f.equals(family)) continue;
            return true;
        }
        return false;
    }

    public static void addFamily(String family) {
        if (GraphicContext.containFamily(family)) {
            families2show.remove(family);
        } else {
            families2show.add(family);
        }
    }

    public void increaseFontSize() {
        this.width *= 1.5;
        this.height *= 1.5;
        this.half = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
        this.symbolsize = 4.0 * this.width - 2.0 * this.half;
        for (Helix2D h2D : this.canvas.getModel2D().getHelices()) {
            this.intializeHelixCurrentContext(h2D);
        }
    }

    public void decreaseFontSize() {
        this.width /= 1.5;
        this.height /= 1.5;
        this.half = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
        this.symbolsize = 4.0 * this.width - 2.0 * this.half;
        for (Helix2D h2D : this.canvas.getModel2D().getHelices()) {
            this.intializeHelixCurrentContext(h2D);
        }
    }

    void setFiveToThreeOrientationDisplay(boolean display) {
        this.displayFiveToThreeOrientation = display;
    }

    public boolean isFiveToThreeOrientationDisplayed() {
        return this.displayFiveToThreeOrientation;
    }

    boolean isShowFamily() {
        return this.showFamily;
    }

    void setShowFamily(boolean showFamily) {
        this.showFamily = showFamily;
    }

    void setGravityPoint(Point2D gravityPoint) {
        this.gravityPoint = gravityPoint;
    }

    void translateGravityPoint(double transX, double transY) {
        if (this.gravityPoint != null) {
            this.gravityPoint.setLocation(this.gravityPoint.getX() + transX, this.gravityPoint.getY() + transY);
        }
    }

    void zoomGravityPoint(double zoomLevel) {
        if (this.gravityPoint != null) {
            this.gravityPoint.setLocation(this.gravityPoint.getX() * zoomLevel, this.gravityPoint.getY() * zoomLevel);
        }
    }

    void setColorMode(byte colorMode) {
        this.colorMode = colorMode;
    }

    void setDrawingArea(Rectangle drawingArea) {
        this.drawingArea = drawingArea;
    }

    public Rectangle getDrawingArea() {
        return this.drawingArea;
    }

    public boolean isLabelsDisplayed() {
        return this.displayLabels;
    }

    public void setDisplayLabels(boolean displayLabels) {
        this.displayLabels = displayLabels;
    }

    public boolean isTertiaryInteractionsDisplayed() {
        return displayTertiaryInteractions;
    }

    public static void setDisplayTertiaryInteractions(boolean displayTertiaryInteractions) {
        GraphicContext.displayTertiaryInteractions = displayTertiaryInteractions;
    }

    static {
        displayTertiaryInteractions = true;
        families2show = new ArrayList<String>();
        families2show.add("CWW");
        families2show.add("TWW");
        families2show.add("CHH");
        families2show.add("THH");
        families2show.add("CSS");
        families2show.add("TSS");
        families2show.add("CHW");
        families2show.add("CWH");
        families2show.add("THW");
        families2show.add("TWH");
        families2show.add("CHS");
        families2show.add("CSH");
        families2show.add("THS");
        families2show.add("TSH");
        families2show.add("CSW");
        families2show.add("CWS");
        families2show.add("TSW");
        families2show.add("TWS");
        families2show.add("SingleHBond");
    }
}

