/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.graphics;

import fr.unistra.ibmc.assemble.AssembleAgent;
import fr.unistra.ibmc.assemble.behaviours.HelixReorganizationRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.SecondaryStructureDrawingRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.SingleResidues3DPredictionRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.StructuralDomains3DPredictionRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.gui.event.SelectionTransmitter;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Model2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.Application;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rna2DViewer
extends JPanel
implements SelectionListener,
SelectionTransmitter {
    private fr.unistra.ibmc.assemble.Mediator assembleMediator;
    private Mediator rna2DViewerMediator;
    private SecondaryCanvas secondaryCanvas;
    private Rna2DViewerToolBar toolbar;
    private ParadiseWorkingSession workingSession;
    private JButton selectResidues;
    private JButton selectAtoms;
    private JButton selectInteractions;
    private JButton selectChains;
    private JButton selectStructuralDomains;
    private JButton clearSelection;
    private JButton lastSelectionButtonClicked;

    public Rna2DViewer(ParadiseWorkingSession workingSession, fr.unistra.ibmc.assemble.Mediator assembleMediator) {
        this.assembleMediator = assembleMediator;
        this.assembleMediator.setRna2DViewer(this);
        this.rna2DViewerMediator = new Mediator(this);
        this.setLayout(new BorderLayout());
        this.secondaryCanvas = new SecondaryCanvas(workingSession, this.rna2DViewerMediator);
        this.add((Component)this.secondaryCanvas, "Center");
        this.toolbar = new Rna2DViewerToolBar();
        this.workingSession = workingSession;
    }

    public void clearSelection() {
        this.clearSelection.doClick();
    }

    public void selectAtoms() {
        this.selectAtoms.doClick();
    }

    public void selectResidues() {
        this.selectResidues.doClick();
    }

    public void selectInteractions() {
        this.selectInteractions.doClick();
    }

    public void selectChains() {
        this.selectChains.doClick();
    }

    public void selectStructuralDomains() {
        this.selectStructuralDomains.doClick();
    }

    @Override
    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.secondaryCanvas.addKeyListener(l);
    }

    public void reorganizeHelices() {
        this.toolbar.reorganizeHelices.doClick();
    }

    public void generate3D() {
        this.toolbar.generate3DButton.doClick();
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        for (Residue r : residues) {
            Residue2D _r = this.secondaryCanvas.seekResidue2D(r);
            if (_r == null) continue;
            this.secondaryCanvas.addShiftCurrentResidue(_r);
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        Rna2DElement element = this.secondaryCanvas.seekRna2DNode((ParadiseFeature)structuralDomain);
        this.secondaryCanvas.addShiftCurrentStructure((StructuralDomain2D)element);
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        for (Atom a : atoms) {
            this.secondaryCanvas.addShiftCurrentResidue(this.secondaryCanvas.seekResidue2D((Residue)a.getResidue().getResidue3D().getResidues().iterator().next()));
        }
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        if (!isShiftDown) {
            this.secondaryCanvas.clearAllSelections();
        }
        Rna2DElement element = this.secondaryCanvas.seekRna2DNode((ParadiseFeature)interaction);
        this.secondaryCanvas.addShiftCurrentInteraction((Interaction2D)element);
    }

    public ParadiseWorkingSession getWorkingSession() {
        return this.workingSession;
    }

    public Rna2DViewerToolBar getToolbar() {
        return this.toolbar;
    }

    public Mediator getRna2DViewerMediator() {
        return this.rna2DViewerMediator;
    }

    public fr.unistra.ibmc.assemble.Mediator getAssembleMediator() {
        return this.assembleMediator;
    }

    public MainParadiseFeature getCurrentFeature() {
        if (this.rna2DViewerMediator == null || this.rna2DViewerMediator.getSecondaryCanvas() == null || this.rna2DViewerMediator.getSecondaryCanvas().getModel2D() == null) {
            return null;
        }
        return this.rna2DViewerMediator.getSecondaryCanvas().getModel2D().getSecondaryStructure();
    }

    public void loadRNASecondaryStructure(SecondaryStructure ss) {
        SecondaryStructureDisplay display = ss.getSecondaryStructureDisplay();
        if (display == null) {
            GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("2D drawing"));
            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
            for (Molecule m : ss.getMolecules()) {
                if (!RNA.class.isInstance(m)) continue;
                m.removeAllSelectedFeatures();
                molecules.add(m);
                m.addSelectedFeature((ParadiseFeature)ss);
            }
            ev.addParameter((Object)new SecondaryStructureDrawingRequestAnswerBehaviour(molecules, new Parameters()));
            ((AbstractParadiseToolAgent)this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
        } else {
            if (this.rna2DViewerMediator.getModel2D() == null) {
                this.rna2DViewerMediator.setModel2D(ss, display);
            } else {
                this.rna2DViewerMediator.getModel2D().getSecondaryStructure().getFactory().extendSecondaryStructure(ss, this.rna2DViewerMediator.getModel2D().getSecondaryStructure());
                this.rna2DViewerMediator.setModel2D(this.rna2DViewerMediator.getModel2D().getSecondaryStructure(), this.rna2DViewerMediator.getModel2D().getSecondaryStructure().getSecondaryStructureDisplay());
            }
            this.assembleMediator.getSecondaryStructureNavigator().reconstructTree();
        }
    }

    public SecondaryCanvas getSecondaryCanvas() {
        return this.secondaryCanvas;
    }

    public void colorSelectedResiduesAsDefault() {
        for (Residue2D residue : this.secondaryCanvas.getCurrentResidues()) {
            if (Helix.class.isInstance(residue.getStructuralDomain().getStructuralDomain())) {
                residue.setColor(Color.BLUE);
                continue;
            }
            residue.setColor(Color.BLACK);
        }
        this.secondaryCanvas.repaint();
    }

    public void colorSelectedResidues(Color color) {
        for (Residue2D r : this.secondaryCanvas.getCurrentResidues()) {
            r.setColor(color);
        }
        this.secondaryCanvas.repaint();
    }

    private class InteractionSelector
    extends JDialog {
        private JButton ok = new JButton("Ok");
        private JButton cancel = new JButton("Cancel");
        private JRadioButton w1 = new JRadioButton("Watson Crick");
        private JRadioButton h1 = new JRadioButton("Hoogsteen");
        private JRadioButton s1 = new JRadioButton("Sugar Edge");
        private JRadioButton w2 = new JRadioButton("Watson Crick");
        private JRadioButton h2 = new JRadioButton("Hoogsteen");
        private JRadioButton s2 = new JRadioButton("Sugar Edge");
        private JRadioButton cis = new JRadioButton("Cis");
        private JRadioButton trans = new JRadioButton("Trans");
        private JRadioButton r1;
        private JRadioButton r2;
        private Residue2D residue1;
        private Residue2D residue2;
        private Molecule m1;
        private Molecule m2;
        private int pos1;
        private int pos2;
        private boolean generateTertiaryInteraction;

        private InteractionSelector(Residue2D residue1, Residue2D residue2) {
            this.residue1 = residue1;
            this.residue2 = residue2;
            this.pos1 = residue1.getAbsolutePosition();
            this.pos2 = residue2.getAbsolutePosition();
            this.m1 = (Molecule)residue1.getResidue2DFeature().getMolecules().iterator().next();
            this.m2 = (Molecule)residue2.getResidue2DFeature().getMolecules().iterator().next();
            this.r1 = new JRadioButton(this.m1.getResidueAt(this.pos1) + " " + this.pos1 + " (" + this.m1.getName() + ")");
            this.r2 = new JRadioButton(this.m2.getResidueAt(this.pos2) + " " + this.pos2 + " (" + this.m2.getName() + ")");
            ButtonGroup be1 = new ButtonGroup();
            ButtonGroup be2 = new ButtonGroup();
            ButtonGroup bo = new ButtonGroup();
            ButtonGroup br = new ButtonGroup();
            be1.add(this.w1);
            be1.add(this.h1);
            be1.add(this.s1);
            be2.add(this.w2);
            be2.add(this.h2);
            be2.add(this.s2);
            bo.add(this.cis);
            bo.add(this.trans);
            br.add(this.r1);
            br.add(this.r2);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
            JPanel ed1 = new JPanel();
            ed1.setLayout(new BoxLayout(ed1, 2));
            JPanel ed2 = new JPanel();
            ed2.setLayout(new BoxLayout(ed2, 2));
            JPanel or = new JPanel();
            or.setLayout(new BoxLayout(or, 2));
            JPanel re = new JPanel();
            re.setLayout(new BoxLayout(re, 2));
            JPanel but = new JPanel();
            but.setLayout(new BoxLayout(but, 2));
            ed1.add(new JLabel("Edge for " + this.m1.getResidueAt(this.pos1) + " " + this.pos1));
            ed1.add(this.w1);
            ed1.add(this.h1);
            ed1.add(this.s1);
            ed2.add(new JLabel("Edge for " + this.m2.getResidueAt(this.pos2) + " " + this.pos2));
            ed2.add(this.w2);
            ed2.add(this.h2);
            ed2.add(this.s2);
            or.add(new JLabel("Orientation of the Interaction"));
            or.add(this.cis);
            or.add(this.trans);
            re.add(new JLabel("Dominant Residue (if applicable)"));
            re.add(this.r1);
            re.add(this.r2);
            but.add(this.ok);
            but.add(this.cancel);
            this.setTitle("Describe the Interaction");
            this.getContentPane().add(ed1);
            this.getContentPane().add(ed2);
            this.getContentPane().add(or);
            this.getContentPane().add(re);
            this.getContentPane().add(but);
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InteractionSelector.this.dispose();
                }
            });
            this.pack();
            this.setResizable(false);
            GeneralUtils.centerOnScreen((Window)this);
            this.setVisible(true);
        }

        public InteractionSelector(final BaseBaseInteraction2D interaction) {
            this(interaction.getResidue(), interaction.getPartnerResidue());
            switch (interaction.getBaseBaseInteractionFeature().getOrientation()) {
                case 'C': {
                    this.cis.setSelected(true);
                    break;
                }
                case 'T': {
                    this.trans.setSelected(true);
                }
            }
            switch (interaction.getBaseBaseInteractionFeature().getEdge1()) {
                case 'W': {
                    this.w1.setSelected(true);
                    break;
                }
                case 'H': {
                    this.h1.setSelected(true);
                    break;
                }
                case 'S': {
                    this.s1.setSelected(true);
                }
            }
            switch (interaction.getBaseBaseInteractionFeature().getEdge2()) {
                case 'W': {
                    this.w2.setSelected(true);
                    break;
                }
                case 'H': {
                    this.h2.setSelected(true);
                    break;
                }
                case 'S': {
                    this.s2.setSelected(true);
                }
            }
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    char edge1 = 'W';
                    char edge2 = 'W';
                    char orientation = 'C';
                    int dominant = 1;
                    if (InteractionSelector.this.h1.isSelected()) {
                        edge1 = 'H';
                    }
                    if (InteractionSelector.this.s1.isSelected()) {
                        edge1 = 'S';
                    }
                    if (InteractionSelector.this.h2.isSelected()) {
                        edge2 = 'H';
                    }
                    if (InteractionSelector.this.s2.isSelected()) {
                        edge2 = 'S';
                    }
                    if (InteractionSelector.this.trans.isSelected()) {
                        orientation = 'T';
                    }
                    if (InteractionSelector.this.r2.isSelected()) {
                        dominant = 2;
                    }
                    try {
                        Rna2DViewer.this.rna2DViewerMediator.getModel2D().modifyInteractionType(interaction, InteractionSelector.this.residue1, edge1, InteractionSelector.this.residue2, edge2, orientation, dominant);
                    }
                    catch (BiologicalSymbolException ex) {
                        JOptionPane.showMessageDialog(Rna2DViewer.this.assembleMediator.getAssemble().getFrame(), ex.getMessage());
                        return;
                    }
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    InteractionSelector.this.dispose();
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                }
            });
        }

        public InteractionSelector(final Residue2D residue1, final Residue2D residue2, boolean generateTertiaryInteraction) {
            this(residue1, residue2);
            this.w1.setSelected(true);
            this.w2.setSelected(true);
            this.cis.setSelected(true);
            this.r1.setSelected(true);
            this.generateTertiaryInteraction = generateTertiaryInteraction;
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == InteractionSelector.this.ok) {
                        char edge1 = 'W';
                        char edge2 = 'W';
                        char orientation = 'C';
                        int dominant = 1;
                        if (InteractionSelector.this.h1.isSelected()) {
                            edge1 = 'H';
                        }
                        if (InteractionSelector.this.s1.isSelected()) {
                            edge1 = 'S';
                        }
                        if (InteractionSelector.this.h2.isSelected()) {
                            edge2 = 'H';
                        }
                        if (InteractionSelector.this.s2.isSelected()) {
                            edge2 = 'S';
                        }
                        if (InteractionSelector.this.trans.isSelected()) {
                            orientation = 'T';
                        }
                        if (InteractionSelector.this.r2.isSelected()) {
                            dominant = 2;
                        }
                        try {
                            Rna2DViewer.this.rna2DViewerMediator.getModel2D().createTertiaryInteraction(residue1, edge1, residue2, edge2, orientation, dominant);
                        }
                        catch (BiologicalSymbolException ex) {
                            JOptionPane.showMessageDialog(Rna2DViewer.this.assembleMediator.getAssemble().getFrame(), ex.getMessage());
                            return;
                        }
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                        InteractionSelector.this.dispose();
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                    }
                }
            });
        }
    }

    private class Generate3DButton
    extends JButton
    implements MouseListener {
        private Generate3DButton() {
            super(new ImageIcon(RessourcesUtils.getImage("22/generate3D.png")));
            this.setBackground(Color.white);
            this.setBorderPainted(false);
            this.addMouseListener(this);
            this.setToolTipText("Generate 3D from 2D");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.rna2DViewerMediator.getModel2D() != null) {
                        HashSet<Molecule> molecules;
                        GuiEvent ev;
                        if (Rna2DViewer.this.assembleMediator.get3DModel() != null) {
                            for (Residue2D r : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                                if (Rna2DViewer.this.assembleMediator.getAssemble().getAssembleResidue((Residue)r.getResidue2DFeature().getResidues().iterator().next()) == null) continue;
                                JOptionPane.showMessageDialog(null, "One or several residues are already present in the 3D Model.\nDelete them in the 3D Model before to retry");
                                return;
                            }
                        }
                        if (Rna2DViewer.this.rna2DViewerMediator.getSelectMode() == 4) {
                            if (Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures().isEmpty()) {
                                JOptionPane.showMessageDialog(null, "Select at least one Structural Domain to use this option");
                                return;
                            }
                            ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("3D prediction"));
                            molecules = new HashSet<Molecule>();
                            for (Molecule m : Rna2DViewer.this.getSecondaryCanvas().getModel2D().getSecondaryStructure().getMolecules()) {
                                m.removeAllSelectedFeatures();
                            }
                            ArrayList<Interaction2D> interactions2D = new ArrayList<Interaction2D>(Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions());
                            for (StructuralDomain2D sd : Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures()) {
                                if (Helix2D.class.isInstance(sd)) {
                                    interactions2D.removeAll(((Helix2D)sd).getSecondaryInteractions());
                                }
                                Collection _molecules = sd.getStructuralDomain().getMolecules();
                                molecules.addAll(_molecules);
                                Molecule m = (Molecule)_molecules.iterator().next();
                                m.addSelectedFeature((ParadiseFeature)sd.getStructuralDomain());
                            }
                            ev.addParameter((Object)new StructuralDomains3DPredictionRequestAnswerBehaviour(new ArrayList<Molecule>(molecules), new Parameters()));
                            Rna2DViewer.this.assembleMediator.stopAnimator();
                            ((AssembleAgent)Rna2DViewer.this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
                        } else if (Rna2DViewer.this.rna2DViewerMediator.getSelectMode() == 1) {
                            if (Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues().isEmpty()) {
                                JOptionPane.showMessageDialog(null, "Select at least one one Residue to use this option");
                                return;
                            }
                            ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("3D prediction"));
                            molecules = new HashSet();
                            for (Molecule m : Rna2DViewer.this.getSecondaryCanvas().getModel2D().getSecondaryStructure().getMolecules()) {
                                m.removeAllSelectedFeatures();
                                molecules.add(m);
                            }
                            Parameters parameters = new Parameters();
                            for (Residue2D r : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                                Parameter p = new Parameter("residue");
                                p.setResidue((Residue)r.getResidue2DFeature().getResidues().iterator().next());
                                parameters.addParameter(p);
                            }
                            ev.addParameter((Object)new SingleResidues3DPredictionRequestAnswerBehaviour(new ArrayList<Molecule>(molecules), parameters));
                            Rna2DViewer.this.assembleMediator.stopAnimator();
                            ((AssembleAgent)Rna2DViewer.this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
                        }
                    }
                }
            });
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBackground(Color.lightGray);
            this.setBorderPainted(true);
        }

        public void mouseExited(MouseEvent e) {
            this.setBackground(Color.white);
            this.setBorderPainted(false);
        }
    }

    private class Rna2DViewerToolBar
    extends JToolBar {
        private ActionButton addHelix;
        private ActionButton removeHelix;
        private ActionButton addTertiaryInteraction;
        private ActionButton removeTertiaryInteraction;
        private ActionButton modifyInteractionType;
        private ActionButton reorganizeHelices;
        private ActionButton[] actions = new ActionButton[15];
        private Generate3DButton generate3DButton;

        private Rna2DViewerToolBar() {
            this.setFloatable(false);
            this.setBackground(Color.white);
            int height = new ImageIcon(RessourcesUtils.getImage("flip.png")).getIconHeight();
            this.actions[0] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("flip.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().flipSelection();
                }
            });
            this.actions[0].setToolTipText("Flip selection");
            this.actions[1] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("lock.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.actions[1].setToolTipText("Lock interaction display");
            this.actions[2] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("unlock.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.actions[2].setToolTipText("Unlock interaction display");
            this.actions[3] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("show-symbol.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Iterator<Interaction2D> ic = Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().iterator();
                    while (ic.hasNext()) {
                        ic.next().drawRealSymbol(true);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[3].setToolTipText("Display LW symbol");
            this.actions[4] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("hide-symbol.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Iterator<Interaction2D> ic = Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().iterator();
                    while (ic.hasNext()) {
                        ic.next().drawRealSymbol(false);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[4].setToolTipText("Hide LW symbol");
            this.actions[5] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("center-view.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().centerViewOnModel();
                }
            });
            this.actions[5].setToolTipText("Center view on 2D structure");
            this.actions[8] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("plus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().increaseFontSize();
                }
            });
            this.actions[8].setToolTipText("Increase font");
            this.actions[9] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("minus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.getSecondaryCanvas().decreaseFontSize();
                }
            });
            this.actions[9].setToolTipText("Decrease font");
            this.actions[12] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("ellipse.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<StructuralDomain2D> strs = Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures();
                    StructuralDomain2D str2 = null;
                    for (StructuralDomain2D str2 : strs) {
                        if (!(str2 instanceof Sstrand2D)) continue;
                        ((Sstrand2D)str2).isAutomaticCoordinates(true);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[12].setToolTipText("Single-strand automatic drawing mode");
            this.actions[13] = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("polygon.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<StructuralDomain2D> strs = Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures();
                    StructuralDomain2D str2 = null;
                    for (StructuralDomain2D str2 : strs) {
                        if (!(str2 instanceof Sstrand2D)) continue;
                        ((Sstrand2D)str2).isAutomaticCoordinates(false);
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            });
            this.actions[13].setToolTipText("Single-strand user-defined drawing mode");
            this.addHelix = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("new-secondary.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SecondaryCanvas canvas = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas();
                    Model2D model2D = canvas.getModel2D();
                    if (model2D != null && canvas.getCurrentResidues().size() == 4) {
                        Iterator<Residue2D> it = canvas.getCurrentResidues().iterator();
                        Residue2D r1 = it.next();
                        Residue2D r2 = it.next();
                        Residue2D r3 = it.next();
                        Residue2D r4 = it.next();
                        ParadiseID id1 = r1.getMoleculeId();
                        ParadiseID id2 = r2.getMoleculeId();
                        ParadiseID id3 = r3.getMoleculeId();
                        ParadiseID id4 = r4.getMoleculeId();
                        ArrayList<Residue2D> sortedResidues = new ArrayList<Residue2D>(4);
                        if (id1 == id2 && id3 == id4) {
                            if (r1.getAbsolutePosition() < r2.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r2);
                            } else {
                                sortedResidues.add(r2);
                                sortedResidues.add(r1);
                            }
                            if (r3.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r3);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r3);
                            }
                        } else if (id1 == id3 && id2 == id4) {
                            if (r1.getAbsolutePosition() < r3.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r3);
                            } else {
                                sortedResidues.add(r3);
                                sortedResidues.add(r1);
                            }
                            if (r2.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r2);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r2);
                            }
                        } else if (id1 == id4 && id2 == id3) {
                            if (r1.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r1);
                            }
                            if (r2.getAbsolutePosition() < r3.getAbsolutePosition()) {
                                sortedResidues.add(r2);
                                sortedResidues.add(r3);
                            } else {
                                sortedResidues.add(r3);
                                sortedResidues.add(r2);
                            }
                        }
                        it = sortedResidues.iterator();
                        try {
                            model2D.createHelix(it.next(), it.next(), it.next(), it.next());
                            Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(Rna2DViewer.this, ex.getMessage(), "Cannot create Helix", 0);
                        }
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                        Rna2DViewer.this.assembleMediator.getResidueManager().modelModified();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "Select exactly four residues to use this option", "Cannot create Helix", 0);
                    }
                }
            });
            this.addHelix.setToolTipText("Create new helix");
            this.removeHelix = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("delete-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int transformAsTertiaryInteractions = JOptionPane.showConfirmDialog(Rna2DViewer.this, "Do you want to keep the secondary interactions as tertiary ones?");
                    if (transformAsTertiaryInteractions == 2) {
                        return;
                    }
                    Model2D model2D = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getModel2D();
                    if (model2D != null) {
                        ArrayList<StructuralDomain2D> domains = new ArrayList<StructuralDomain2D>(Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentStructures());
                        for (StructuralDomain2D sd : domains) {
                            if (!Helix2D.class.isInstance(sd)) continue;
                            Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().removeCurrentStructure(sd);
                            try {
                                model2D.removeHelix((Helix2D)sd, transformAsTertiaryInteractions == 0);
                            }
                            catch (BiologicalSymbolException e1) {
                                JOptionPane.showMessageDialog(Rna2DViewer.this, e1.getMessage(), "Cannot remove Helix", 0);
                                return;
                            }
                        }
                    }
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    Rna2DViewer.this.assembleMediator.getResidueManager().modelModified();
                }
            });
            this.removeHelix.setToolTipText("Remove helix");
            this.addTertiaryInteraction = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("new-tertiary.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Residue2D> residues = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentResidues();
                    if (residues.size() == 2) {
                        new InteractionSelector(residues.get(0), residues.get(1), true);
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                        Rna2DViewer.this.assembleMediator.getResidueManager().modelModified();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "You have to select two residues to create a new tertiary interaction", "No residues selected!!", 0);
                    }
                }
            });
            this.addTertiaryInteraction.setToolTipText("Create new tertiary interaction");
            this.removeTertiaryInteraction = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("delete-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Interaction2D> interactions = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentInteractions();
                    if (interactions.isEmpty()) {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "No interactions selected !!");
                    } else {
                        ArrayList<BaseBaseInteraction> interactionsRemoved = new ArrayList<BaseBaseInteraction>();
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                        for (Interaction2D i : interactions) {
                            if (!BaseBaseInteraction2D.class.isInstance(i) || ((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature().isSecondaryInteraction() || ((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature().getMolecules().size() != 1) continue;
                            Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getModel2D().removeTertiaryInteraction((BaseBaseInteraction2D)i);
                            interactionsRemoved.add(((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature());
                        }
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                        Rna2DViewer.this.assembleMediator.getResidueManager().modelModified();
                    }
                }
            });
            this.removeTertiaryInteraction.setToolTipText("Remove tertiary interactions");
            this.modifyInteractionType = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("modify-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Interaction2D> interactions = Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getCurrentInteractions();
                    if (interactions.size() == 1 && BaseBaseInteraction2D.class.isInstance(interactions.get(0))) {
                        new InteractionSelector((BaseBaseInteraction2D)interactions.get(0));
                        Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "You have to select a single interaction!!");
                    }
                }
            });
            this.modifyInteractionType.setToolTipText("Modify interaction's type");
            Rna2DViewer.this.selectAtoms = new JButton(new ImageIcon(RessourcesUtils.getImage("22/atom.png")));
            Rna2DViewer.this.selectAtoms.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    Rna2DViewer.this.selectAtoms.setBackground(Color.lightGray);
                    Rna2DViewer.this.selectAtoms.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    Rna2DViewer.this.selectAtoms.setBackground(Color.white);
                    Rna2DViewer.this.selectAtoms.setBorderPainted(false);
                }
            });
            Rna2DViewer.this.selectAtoms.setMargin(new Insets(0, 0, 0, 0));
            Rna2DViewer.this.selectAtoms.setBorderPainted(false);
            Rna2DViewer.this.selectAtoms.setBackground(Color.white);
            Rna2DViewer.this.selectAtoms.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.lastSelectionButtonClicked != null) {
                        Rna2DViewer.this.lastSelectionButtonClicked.setEnabled(true);
                    }
                    Rna2DViewer.this.selectAtoms.setEnabled(false);
                    Rna2DViewer.this.lastSelectionButtonClicked = Rna2DViewer.this.selectAtoms;
                    Rna2DViewer.this.rna2DViewerMediator.setSelectMode(1);
                    Rna2DViewer.this.assembleMediator.getRenderer().setSelectMode(0);
                }
            });
            Rna2DViewer.this.selectAtoms.setToolTipText("Select Atoms");
            this.add(Rna2DViewer.this.selectAtoms);
            Rna2DViewer.this.selectResidues = new JButton(new ImageIcon(RessourcesUtils.getImage("22/adenine.png")));
            Rna2DViewer.this.selectResidues.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    Rna2DViewer.this.selectResidues.setBackground(Color.lightGray);
                    Rna2DViewer.this.selectResidues.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    Rna2DViewer.this.selectResidues.setBackground(Color.white);
                    Rna2DViewer.this.selectResidues.setBorderPainted(false);
                }
            });
            Rna2DViewer.this.selectResidues.setMargin(new Insets(0, 0, 0, 0));
            Rna2DViewer.this.selectResidues.setBorderPainted(false);
            Rna2DViewer.this.selectResidues.setBackground(Color.white);
            Rna2DViewer.this.selectResidues.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.lastSelectionButtonClicked != null) {
                        Rna2DViewer.this.lastSelectionButtonClicked.setEnabled(true);
                    }
                    Rna2DViewer.this.selectResidues.setEnabled(false);
                    Rna2DViewer.this.lastSelectionButtonClicked = Rna2DViewer.this.selectResidues;
                    Rna2DViewer.this.rna2DViewerMediator.setSelectMode(1);
                    Rna2DViewer.this.assembleMediator.getRenderer().setSelectMode(1);
                }
            });
            Rna2DViewer.this.selectResidues.setToolTipText("Select Residues");
            this.add(Rna2DViewer.this.selectResidues);
            Rna2DViewer.this.selectInteractions = new JButton(new ImageIcon(RessourcesUtils.getImage("10.png")));
            Rna2DViewer.this.selectInteractions.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    Rna2DViewer.this.selectInteractions.setBackground(Color.lightGray);
                    Rna2DViewer.this.selectInteractions.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    Rna2DViewer.this.selectInteractions.setBackground(Color.white);
                    Rna2DViewer.this.selectInteractions.setBorderPainted(false);
                }
            });
            Rna2DViewer.this.selectInteractions.setMargin(new Insets(0, 0, 0, 0));
            Rna2DViewer.this.selectInteractions.setBorderPainted(false);
            Rna2DViewer.this.selectInteractions.setBackground(Color.white);
            Rna2DViewer.this.selectInteractions.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.lastSelectionButtonClicked != null) {
                        Rna2DViewer.this.lastSelectionButtonClicked.setEnabled(true);
                    }
                    Rna2DViewer.this.selectInteractions.setEnabled(false);
                    Rna2DViewer.this.lastSelectionButtonClicked = Rna2DViewer.this.selectInteractions;
                    Rna2DViewer.this.rna2DViewerMediator.setSelectMode(3);
                    Rna2DViewer.this.assembleMediator.getRenderer().setSelectMode(1);
                }
            });
            Rna2DViewer.this.selectInteractions.setToolTipText("Select Interactions");
            this.add(Rna2DViewer.this.selectInteractions);
            Rna2DViewer.this.selectChains = new JButton(new ImageIcon(RessourcesUtils.getImage("22/chain.png")));
            Rna2DViewer.this.selectChains.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    Rna2DViewer.this.selectChains.setBackground(Color.lightGray);
                    Rna2DViewer.this.selectChains.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    Rna2DViewer.this.selectChains.setBackground(Color.white);
                    Rna2DViewer.this.selectChains.setBorderPainted(false);
                }
            });
            Rna2DViewer.this.selectChains.setMargin(new Insets(0, 0, 0, 0));
            Rna2DViewer.this.selectChains.setBorderPainted(false);
            Rna2DViewer.this.selectChains.setBackground(Color.white);
            Rna2DViewer.this.selectChains.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.lastSelectionButtonClicked != null) {
                        Rna2DViewer.this.lastSelectionButtonClicked.setEnabled(true);
                    }
                    Rna2DViewer.this.selectChains.setEnabled(false);
                    Rna2DViewer.this.lastSelectionButtonClicked = Rna2DViewer.this.selectChains;
                    Rna2DViewer.this.rna2DViewerMediator.setSelectMode(1);
                    Rna2DViewer.this.assembleMediator.getRenderer().setSelectMode(2);
                }
            });
            Rna2DViewer.this.selectChains.setToolTipText("Select Chains");
            this.add(Rna2DViewer.this.selectChains);
            Rna2DViewer.this.selectStructuralDomains = new JButton(new ImageIcon(RessourcesUtils.getImage("22/block.png")));
            Rna2DViewer.this.selectStructuralDomains.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    Rna2DViewer.this.selectStructuralDomains.setBackground(Color.lightGray);
                    Rna2DViewer.this.selectStructuralDomains.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    Rna2DViewer.this.selectStructuralDomains.setBackground(Color.white);
                    Rna2DViewer.this.selectStructuralDomains.setBorderPainted(false);
                }
            });
            Rna2DViewer.this.selectStructuralDomains.setMargin(new Insets(0, 0, 0, 0));
            Rna2DViewer.this.selectStructuralDomains.setBorderPainted(false);
            Rna2DViewer.this.selectStructuralDomains.setBackground(Color.white);
            Rna2DViewer.this.selectStructuralDomains.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.lastSelectionButtonClicked != null) {
                        Rna2DViewer.this.lastSelectionButtonClicked.setEnabled(true);
                    }
                    Rna2DViewer.this.selectStructuralDomains.setEnabled(false);
                    Rna2DViewer.this.lastSelectionButtonClicked = Rna2DViewer.this.selectStructuralDomains;
                    Rna2DViewer.this.rna2DViewerMediator.setSelectMode(4);
                    Rna2DViewer.this.assembleMediator.getRenderer().setSelectMode(4);
                }
            });
            Rna2DViewer.this.selectStructuralDomains.setToolTipText("Select Structural Domains");
            this.add(Rna2DViewer.this.selectStructuralDomains);
            Rna2DViewer.this.selectStructuralDomains.setEnabled(false);
            Rna2DViewer.this.lastSelectionButtonClicked = Rna2DViewer.this.selectStructuralDomains;
            Rna2DViewer.this.rna2DViewerMediator.setSelectMode(4);
            Rna2DViewer.this.assembleMediator.getRenderer().setSelectMode(4);
            Rna2DViewer.this.clearSelection = new JButton(new ImageIcon(RessourcesUtils.getImage("22/unselect.png")));
            Rna2DViewer.this.clearSelection.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    Rna2DViewer.this.clearSelection.setBackground(Color.lightGray);
                    Rna2DViewer.this.clearSelection.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    Rna2DViewer.this.clearSelection.setBackground(Color.white);
                    Rna2DViewer.this.clearSelection.setBorderPainted(false);
                }
            });
            Rna2DViewer.this.clearSelection.setMargin(new Insets(0, 0, 0, 0));
            Rna2DViewer.this.clearSelection.setBorderPainted(false);
            Rna2DViewer.this.clearSelection.setBackground(Color.white);
            Rna2DViewer.this.clearSelection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                    Rna2DViewer.this.assembleMediator.getGlobalSelection().clear();
                    Rna2DViewer.this.assembleMediator.getAssemble().getSecondaryStructureNavigator().clearSelections();
                }
            });
            Rna2DViewer.this.clearSelection.setToolTipText("Clear Selection");
            this.add(Rna2DViewer.this.clearSelection);
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.actions[5]);
            this.add(this.actions[0]);
            this.reorganizeHelices = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("22/magic.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("2D drawing"));
                    if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                        SecondaryStructure ss = Rna2DViewer.this.getSecondaryCanvas().getModel2D().getSecondaryStructure();
                        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                        for (Molecule m : ss.getMolecules()) {
                            m.removeAllSelectedFeatures();
                            m.addSelectedFeature((ParadiseFeature)ss);
                            molecules.add(m);
                        }
                        ev.addParameter((Object)new HelixReorganizationRequestAnswerBehaviour(molecules, new Parameters()));
                        ((AssembleAgent)Rna2DViewer.this.assembleMediator.getAssemble().getAgent()).postGuiEvent(ev);
                    }
                }
            });
            this.reorganizeHelices.setToolTipText("Reorganize helices");
            this.add(this.reorganizeHelices);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.addHelix);
            this.add(this.removeHelix);
            this.add(this.addTertiaryInteraction);
            this.add(this.removeTertiaryInteraction);
            this.add(this.modifyInteractionType);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            ActionButton tileVertically = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("tile_vertical.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.assembleMediator.getAssemble().tileVertically();
                }
            });
            tileVertically.setToolTipText("Tile vertically");
            this.add(tileVertically);
            ActionButton tileHorinzontally = new ActionButton(null, (Icon)new ImageIcon(RessourcesUtils.getImage("tile_horizontal.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rna2DViewer.this.assembleMediator.getAssemble().tileHorizontally();
                }
            });
            tileHorinzontally.setToolTipText("Tile horizontally");
            this.add(tileHorinzontally);
            this.add(new CaptureViewButton());
            this.generate3DButton = new Generate3DButton();
            this.add(this.generate3DButton);
            this.add(Box.createHorizontalGlue());
        }

        private class CaptureViewButton
        extends JButton
        implements MouseListener {
            private CaptureViewButton() {
                super(new ImageIcon(RessourcesUtils.getImage("capture.png")));
                this.setToolTipText("Capture the view");
                this.setBackground(Color.white);
                this.setBorderPainted(false);
                this.addMouseListener(this);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (Rna2DViewer.this.rna2DViewerMediator.getModel2D() != null) {
                            final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                            fileChooser.setFileFilter(new FileFilter(){

                                public boolean accept(File f) {
                                    return f.isDirectory() || f.getName().endsWith(".png");
                                }

                                public String getDescription() {
                                    return "PNG files";
                                }
                            });
                            if (fileChooser.showSaveDialog(Rna2DViewer.this) == 0) {
                                new ParadiseTask((Application)Rna2DViewer.this.assembleMediator.getAssemble(), Rna2DViewer.this.assembleMediator.getAssemble().getProgressMonitor()){

                                    protected Object doInBackground() {
                                        PrintWriter pw = null;
                                        try {
                                            File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".png", (Component)Rna2DViewer.this.assembleMediator.getAssemble().getFrame());
                                            if (savingFile == null) {
                                                this.finished();
                                                return null;
                                            }
                                            ImageIO.write((RenderedImage)Rna2DViewer.this.rna2DViewerMediator.getSecondaryCanvas().getImage(false), "png", savingFile);
                                            this.monitor.printMessage("Export successful");
                                        }
                                        catch (Exception e) {
                                            this.monitor.printException(e);
                                        }
                                        if (pw != null) {
                                            pw.close();
                                        }
                                        this.finished();
                                        return null;
                                    }
                                }.execute();
                            }
                        }
                    }
                });
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class ActionButton
        extends JButton
        implements MouseListener {
            private ActionButton(String name, Icon image, String toolTipText, ActionListener listener) {
                this(name, image, listener);
                this.setToolTipText(toolTipText);
            }

            private ActionButton(String name, Icon image, ActionListener listener) {
                super(name, image);
                this.addActionListener(listener);
                this.addMouseListener(this);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setBackground(Color.white);
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }
    }
}

