/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.event.RenderingListener;
import fr.unistra.ibmc.assemble.structures.Drawable;
import java.util.Vector;

public abstract class AbstractDrawable
implements Drawable {
    protected transient Vector<RenderingListener> renderingListeners;
    protected Mediator mediator;
    protected int renderingMode = 1;

    protected AbstractDrawable(Mediator mediator) {
        this.mediator = mediator;
        this.renderingListeners = new Vector();
        this.addRenderingListener(mediator.getRenderer());
    }

    public int getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(int renderingMode) {
        this.renderingMode = renderingMode;
        this.fireRenderingModified();
    }

    public synchronized void addRenderingListener(RenderingListener l) {
        if (this.renderingListeners == null) {
            this.renderingListeners = new Vector();
        }
        this.renderingListeners.addElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRenderingModified() {
        if (this.renderingListeners != null && !this.renderingListeners.isEmpty()) {
            Vector targets;
            AbstractDrawable abstractDrawable = this;
            synchronized (abstractDrawable) {
                targets = (Vector)this.renderingListeners.clone();
            }
            for (RenderingListener l : targets) {
                l.renderingModified();
            }
        }
    }
}

