/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import fr.unistra.ibmc.paradise.core.utils.matrix.Matrix;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomsSelection
extends AbstractDrawable {
    protected List<Atom> selectedAtoms = new ArrayList<Atom>();

    public AtomsSelection(Mediator mediator) {
        super(mediator);
    }

    public void setColor(Color c) {
        for (Atom a : this.selectedAtoms) {
            a.setColor(c);
        }
        this.fireRenderingModified();
    }

    public void clear() {
        this.selectedAtoms.clear();
    }

    public void add(Atom atom) {
        if (atom != null && !this.selectedAtoms.contains(atom)) {
            this.selectedAtoms.add(atom);
        }
    }

    public void add(Residue r) {
        for (Atom a : r.getAtoms()) {
            this.add(a);
        }
    }

    public void add(Collection<Atom> atoms) {
        for (Atom a : atoms) {
            this.add(a);
        }
    }

    public void add(AtomSet ats) {
        for (Atom atom : ats.getAtoms()) {
            this.add(atom);
        }
    }

    public void add(Chain c) {
        for (Residue res : c.getResidues()) {
            for (Atom atom : res.getAtoms()) {
                this.add(atom);
            }
        }
    }

    public void removeAtom(Atom atom) {
        this.selectedAtoms.remove(atom);
    }

    public boolean contains(Atom atom) {
        return this.selectedAtoms.contains(atom);
    }

    @Override
    public void draw(GL gl) {
        if (!this.selectedAtoms.isEmpty()) {
            gl.glEnable(2896);
            gl.glDisable(2884);
            gl.glDepthMask(false);
            gl.glBlendFunc(770, 1);
            gl.glEnable(3042);
            for (Atom atom : this.selectedAtoms) {
                atom.drawSelection(gl);
            }
            gl.glDepthMask(true);
            gl.glDisable(3042);
            gl.glEnable(2884);
            gl.glDisable(2896);
        }
    }

    public float[] getSelectionCenter() {
        if (this.selectedAtoms.isEmpty()) {
            return null;
        }
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        for (Atom atom : this.selectedAtoms) {
            float[] atc = atom.getFloat();
            for (int i = 0; i < 3; ++i) {
                int n = i;
                center[n] = center[n] + atc[i];
            }
        }
        int s = this.selectedAtoms.size();
        if (s > 0) {
            for (int i = 0; i < 3; ++i) {
                center[i] = center[i] / (float)s;
            }
        }
        return center;
    }

    public void rotate(float[] vector, float angle) {
        float[] pivot = this.mediator.getRenderer().getSelectionPivot();
        for (Atom atom : this.selectedAtoms) {
            float[] coord = atom.getFloat();
            for (int i = 0; i < 3; ++i) {
                coord[i] = coord[i] - pivot[i];
            }
            float[] res = TBMath.rotateVector((float[])coord, (float[])vector, (float)angle);
            atom.setCoord(res[0] + pivot[0], res[1] + pivot[1], res[2] + pivot[2]);
        }
    }

    public void translate(float[] f) {
        for (Atom atom : this.selectedAtoms) {
            atom.translate(f);
        }
    }

    public void translate(float x, float y, float z) {
        for (Atom atom : this.selectedAtoms) {
            atom.translate(x, y, z);
        }
    }

    public void transform(Matrix t) {
        for (Atom atom : this.selectedAtoms) {
            atom.transform(t);
        }
    }

    public void rotateAroundLinkDegree(Link axis, float angle) {
        for (Atom atom : this.selectedAtoms) {
            if (atom == null) continue;
            atom.rotateAroundLinkDegree(axis, angle);
        }
    }

    public List<Atom> getSelectedAtoms() {
        return this.selectedAtoms;
    }
}

