/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Model3D;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.ResidueNA;
import fr.unistra.ibmc.assemble.structures.Undoable;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
extends AbstractDrawable
implements Undoable {
    public static char chainID = (char)65;
    public Model3D model3D;
    private char name;
    private List<Residue> residues;
    private List<Link> phosphodiesterBonds;
    private Map<String, List<Residue>> undoResidues;
    private Map<String, List<Link>> undoPhosphodiesterBonds;

    public Chain(Mediator mediator, char name) {
        super(mediator);
        this.name = name;
        this.residues = new ArrayList<Residue>();
        this.phosphodiesterBonds = new ArrayList<Link>();
        this.undoResidues = new HashMap<String, List<Residue>>();
        this.undoPhosphodiesterBonds = new HashMap<String, List<Link>>();
    }

    @Override
    public void addUndoStep(String stateName) {
        this.undoResidues.put(stateName, new ArrayList<Residue>(this.residues));
        this.undoPhosphodiesterBonds.put(stateName, new ArrayList<Link>(this.phosphodiesterBonds));
        for (Residue res : this.residues) {
            res.addUndoStep(stateName);
        }
    }

    @Override
    public void restoreState(String stateName) {
        this.residues = new ArrayList<Residue>((Collection)this.undoResidues.get(stateName));
        this.phosphodiesterBonds = new ArrayList<Link>((Collection)this.undoPhosphodiesterBonds.get(stateName));
        for (Residue r : this.residues) {
            r.setChain(this);
            r.restoreState(stateName);
        }
    }

    @Override
    public void removeState(String stateName) {
        List<Residue> _residues = this.undoResidues.get(stateName);
        for (Residue r : _residues) {
            r.removeState(stateName);
        }
        this.undoResidues.remove(stateName);
    }

    public Residue getResidue(int i) {
        return this.residues.get(i);
    }

    public Molecule getMolecule() {
        if (this.residues.size() > 0) {
            return ((Molecule.Annotation)this.residues.get(0).getResidue3D().getAnnotations().get(0)).getMolecule();
        }
        return null;
    }

    public List<Residue> getResidues() {
        return this.residues;
    }

    public void extendChain(Residue r) {
        if (r != null) {
            if (r.getChain() != null) {
                r.getChain().removeResidue(r);
            }
            r.setChain(this);
            this.residues.add(r);
            if (this.residues.size() > 1) {
                this.phosphodiesterBonds.add(Link.createLink(this.mediator, r.getAtom("P"), this.residues.get(this.residues.size() - 2).getAtom("O3'")));
            }
        }
    }

    public void sortResidues() {
        Collections.sort(this.residues, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Residue)o1).getResidue3D().getFullLocation((Molecule)((Residue)o1).getResidue3D().getMolecules().iterator().next()).getStart() - ((Residue)o2).getResidue3D().getFullLocation((Molecule)((Residue)o2).getResidue3D().getMolecules().iterator().next()).getStart();
            }
        });
    }

    public void removeResidue(Residue r) {
        r.setChain(null);
        this.residues.remove(r);
        for (Link l : new ArrayList<Link>(this.phosphodiesterBonds)) {
            if (l.getFirst().getResidue() != r && l.getSecond().getResidue() != r) continue;
            this.phosphodiesterBonds.remove(l);
        }
        if (this.getLength() == 0) {
            this.mediator.get3DModel().removeChain(this);
        }
    }

    public int getLength() {
        return this.residues.size();
    }

    public int indexOf(Residue r) {
        return this.residues.indexOf(r);
    }

    @Override
    public void draw(GL gl) {
        for (Residue residue : this.residues) {
            if (!residue.isDisplayed()) continue;
            residue.draw(gl);
        }
        for (Link l : this.phosphodiesterBonds) {
            l.draw(gl);
        }
    }

    public void drawSelectScene(GL gl) {
        for (Residue residue : this.residues) {
            residue.drawSelectScene(gl);
        }
    }

    public void translate(float x, float y, float z) {
        for (Residue residue : this.residues) {
            residue.translate(x, y, z);
        }
    }

    public char getName() {
        return this.name;
    }

    public void setName(char name) {
        this.name = name;
    }

    public void restoreAFormConformation() {
        for (Residue residue : this.residues) {
            ((ResidueNA)residue).restoreAFormConformation();
        }
    }

    public Residue getResidueFor(Residue3D paradiseResidue) {
        for (Residue residue : this.residues) {
            if (!residue.matches(paradiseResidue)) continue;
            return residue;
        }
        return null;
    }

    public void saveCoordinatesToParadise() {
        for (Residue residue : this.residues) {
            residue.saveCoordinatesToParadise();
        }
    }

    public void setColor(Color c) {
        for (Residue r : this.residues) {
            r.setColor(c);
        }
        this.fireRenderingModified();
    }

    @Override
    public void setRenderingMode(int mode) {
        for (Residue r : this.residues) {
            r.setRenderingMode(mode);
        }
        this.fireRenderingModified();
    }
}

