/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Chi;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.ResidueNA;
import fr.unistra.ibmc.paradise.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import javax.media.opengl.GL;

public class CytosineNA
extends ResidueNA {
    public CytosineNA(Mediator mediator, Cytosine3D cyt3D) {
        super((Residue3D)cyt3D, mediator);
        this.firstChi = (Atom)this.atoms.get("N1");
        this.secondChi = (Atom)this.atoms.get("C2");
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("N1"), (Atom)this.atoms.get("C2")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C2"), (Atom)this.atoms.get("O2")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C2"), (Atom)this.atoms.get("N3")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("N3"), (Atom)this.atoms.get("C4")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C4"), (Atom)this.atoms.get("N4")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C4"), (Atom)this.atoms.get("C5")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C5"), (Atom)this.atoms.get("C6")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C6"), (Atom)this.atoms.get("N1")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C1'"), this.firstChi));
        this.chi = new Chi(this, this.firstChi, this.secondChi, new Atom[]{(Atom)this.atoms.get("N1"), (Atom)this.atoms.get("C6"), (Atom)this.atoms.get("C5"), (Atom)this.atoms.get("N4"), (Atom)this.atoms.get("C4"), (Atom)this.atoms.get("N3"), (Atom)this.atoms.get("O2"), (Atom)this.atoms.get("C2")}, "\u03c7", mediator);
    }

    public void drawPlane(GL gl) {
        gl.glBegin(9);
        gl.glColor3fv(this.getColor().getRGBOpenGl(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("N1")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C2")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("N3")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C4")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C5")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C6")).getFloat(), 0);
        gl.glEnd();
        gl.glBegin(9);
        gl.glVertex3fv(((Atom)this.atoms.get("C6")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C5")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C4")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("N3")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("C2")).getFloat(), 0);
        gl.glVertex3fv(((Atom)this.atoms.get("N1")).getFloat(), 0);
        gl.glEnd();
    }

    public void setResidueDefaultColor() {
        for (Atom atom : this.atoms.values()) {
            atom.setColor(new OpenGLColor(Assemble.CYTOSINE_COLOR));
        }
    }
}

