/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.structures.AtomsSelection;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;

public abstract class DihedralAngle {
    protected AtomsSelection atomsToRotate;
    protected Residue residue;
    protected String name;
    protected Mediator mediator;

    public DihedralAngle(Residue r, String name, Mediator mediator) {
        this.mediator = mediator;
        this.atomsToRotate = new AtomsSelection(this.mediator);
        this.residue = r;
        this.name = name;
    }

    protected abstract float computeValue(boolean var1);

    public float getDegreeValue(boolean upstreamDirection) {
        return this.computeValue(upstreamDirection) * (float)TBMath.RadianToDegree;
    }

    public Residue getResidue() {
        return this.residue;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isValid();

    public abstract Link getAxis(boolean var1);

    public void torsDegree(float degreeAngle, boolean upstreamDirection) {
        this.atomsToRotate.rotateAroundLinkDegree(this.getAxis(upstreamDirection), degreeAngle);
        this.mediator.get3DModel().fireModelModified();
    }

    public void gatherAtomsToRotate(boolean upstreamDirection, boolean rotateTertiaryInteractions) {
        this.atomsToRotate.clear();
        if (!upstreamDirection) {
            for (Residue next = this.residue.getNext(); next != null; next = next.getNext()) {
                this.atomsToRotate.add(next);
                for (BaseBaseInteraction2D interaction : this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D((fr.unistra.ibmc.paradise.core.utils.Residue)next.getResidue3D().getResidues().iterator().next()).getInteractions()) {
                    if (!interaction.getBaseBaseInteractionFeature().isSecondaryInteraction() && !rotateTertiaryInteractions) continue;
                    Residue r = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getResidue().getResidue2DFeature().getResidues().iterator().next());
                    Residue partnerR = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getPartnerResidue().getResidue2DFeature().getResidues().iterator().next());
                    if (r != this.residue) {
                        this.atomsToRotate.add(r);
                        continue;
                    }
                    if (partnerR == null) continue;
                    this.atomsToRotate.add(partnerR);
                }
            }
        } else {
            for (Residue previous = this.residue.getPrev(); previous != null; previous = previous.getPrev()) {
                this.atomsToRotate.add(previous);
                for (BaseBaseInteraction2D interaction : this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D((fr.unistra.ibmc.paradise.core.utils.Residue)previous.getResidue3D().getResidues().iterator().next()).getInteractions()) {
                    if (!interaction.getBaseBaseInteractionFeature().isSecondaryInteraction() && !rotateTertiaryInteractions) continue;
                    Residue r = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getResidue().getResidue2DFeature().getResidues().iterator().next());
                    Residue partnerR = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getPartnerResidue().getResidue2DFeature().getResidues().iterator().next());
                    if (r != this.residue) {
                        this.atomsToRotate.add(r);
                        continue;
                    }
                    if (partnerR == null) continue;
                    this.atomsToRotate.add(partnerR);
                }
            }
        }
    }

    public void torsToDegree(float degreeAngle, boolean upstreamDirection) {
        float valueCanonical = (degreeAngle + 360.0f) % 360.0f;
        float actualValue = (this.getDegreeValue(upstreamDirection) + 360.0f) % 360.0f;
        this.torsDegree(actualValue - valueCanonical, upstreamDirection);
    }
}

