/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.event.ModelListener;
import fr.unistra.ibmc.assemble.gui.labels.Label;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.ResidueNA;
import fr.unistra.ibmc.assemble.structures.Undoable;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.Protein;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model3D
extends AbstractDrawable
implements Undoable {
    private List<ModelListener> modelListeners;
    private List<Label> labels;
    private List<Chain> chains = new ArrayList<Chain>();
    private TertiaryStructure tertiaryStructure;
    private SecondaryStructure secondaryStructure;
    private Map<String, List<Chain>> undoChains;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    public Model3D(Mediator mediator, SecondaryStructure ss, TertiaryStructure ts) {
        super(mediator);
        this.modelListeners = new ArrayList<ModelListener>();
        this.labels = new ArrayList<Label>();
        this.setSecondaryStructure(ss);
        this.tertiaryStructure = ts;
        this.undoChains = new HashMap<String, List<Chain>>();
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public void translate(float[] f) {
        for (Chain c : this.chains) {
            for (Residue r : c.getResidues()) {
                for (Atom a : r.getAtoms()) {
                    a.translate(f);
                }
            }
        }
        this.minX += f[0];
        this.maxX += f[0];
        this.minY += f[1];
        this.maxY += f[1];
        this.minZ += f[2];
        this.maxZ += f[2];
    }

    public float[] getCenter() {
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        int atomNb = 0;
        for (Chain c : this.chains) {
            for (Residue r : c.getResidues()) {
                for (Atom a : r.getAtoms()) {
                    ++atomNb;
                    float[] atc = a.getFloat();
                    for (int i = 0; i < 3; ++i) {
                        int n = i;
                        center[n] = center[n] + atc[i];
                    }
                }
            }
        }
        for (int i = 0; i < 3; ++i) {
            center[i] = center[i] / (float)atomNb;
        }
        return center;
    }

    public List<Residue> getResidues() {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        for (Chain c : this.chains) {
            residues.addAll(c.getResidues());
        }
        return residues;
    }

    public List<Atom> getAtoms() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Residue r : this.getResidues()) {
            atoms.addAll(r.getAtoms());
        }
        return atoms;
    }

    public void addLabel(Label label) {
        this.labels.add(label);
        this.fireRenderingModified();
    }

    public void hideLabelsForSelection() {
        ArrayList<Label> _labels = new ArrayList<Label>(this.labels);
        block0: for (Label l : _labels) {
            for (Atom a : l.getAtoms()) {
                if (this.mediator.getGlobalSelection().getSelectedAtoms().contains(a)) continue;
                continue block0;
            }
            this.labels.remove(l);
        }
        this.fireRenderingModified();
    }

    public void hideLabels() {
        this.labels.clear();
        this.fireRenderingModified();
    }

    public Residue getResidue(fr.unistra.ibmc.paradise.core.utils.Residue paradiseResidue) {
        for (Chain c : this.chains) {
            for (Residue _r : c.getResidues()) {
                if (!((fr.unistra.ibmc.paradise.core.utils.Residue)_r.getResidue3D().getResidues().getResidues().iterator().next()).equals((Object)paradiseResidue)) continue;
                return _r;
            }
        }
        return null;
    }

    public void addModelListener(ModelListener l) {
        this.modelListeners.add(l);
    }

    public void eraseResidue(Residue r) {
        this.mediator.get3DModel().getTertiaryStructure().removeResidue3D(r.getResidue3D());
        r.getChain().removeResidue(r);
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    public boolean contains(Molecule m) {
        for (Chain c : this.chains) {
            if (c.getMolecule() != m) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Chain> getChains(Molecule molecule) {
        ArrayList<Chain> ret = new ArrayList<Chain>();
        for (Chain chain : this.chains) {
            if (chain.getMolecule() != molecule) continue;
            ret.add(chain);
        }
        return ret;
    }

    public void addChain(Chain chain) {
        chain.model3D = this;
        this.chains.add(chain);
    }

    public void addChainAt(int index, Chain chain) {
        chain.model3D = this;
        this.chains.add(index, chain);
    }

    public void removeChain(Chain chain) {
        chain.model3D = null;
        this.chains.remove(chain);
    }

    public Residue3D getResidue3DAt(Molecule m, int position) {
        List anns = m.getAnnotations(new Location(position));
        for (Molecule.Annotation ann : anns) {
            if (!(ann.getFeature() instanceof Residue3D)) continue;
            return (Residue3D)ann.getFeature();
        }
        return null;
    }

    public void initialize() {
        this.extendModel(this.tertiaryStructure.getResidues3D());
        float[] c = this.mediator.getGlobalSelection().getSelectionCenter();
        this.mediator.getRenderer().setGeneralPivot(c);
        this.mediator.getRenderer().setSelectionPivot(c);
        this.mediator.getGlobalSelection().clear();
        this.mediator.addUndoStep("undo");
        this.mediator.addUndoStep("current");
    }

    public void extendModel(List<Residue3D> residues) {
        if (residues.size() > 0) {
            this.mediator.getGlobalSelection().clear();
            int lastPosition = -1;
            int lastMoleculeID = -1;
            int lastStructuralDomainID = -1;
            char newChainStart = Chain.chainID;
            Chain chain = null;
            for (Residue3D residue3D : residues) {
                fr.unistra.ibmc.paradise.core.utils.Residue _r = (fr.unistra.ibmc.paradise.core.utils.Residue)residue3D.getResidues().iterator().next();
                StructuralDomain sd = this.secondaryStructure.getEnclosingStructuralDomain(_r);
                if (sd == null) continue;
                int currentStructuralDomainID = sd.hashCode();
                ResidueNA residueNA = ResidueNA.createResidueNA(this.mediator, residue3D);
                int currentPosition = _r.getAbsolutePosition();
                int currentMoleculeID = _r.getMoleculeId().hashCode();
                if (currentPosition - 1 != lastPosition || currentMoleculeID != lastMoleculeID || currentStructuralDomainID != lastStructuralDomainID) {
                    char c = Chain.chainID;
                    Chain.chainID = (char)(c + '\u0001');
                    chain = new Chain(this.mediator, c);
                    this.addChain(chain);
                }
                chain.extendChain(residueNA);
                lastPosition = currentPosition;
                lastMoleculeID = currentMoleculeID;
                lastStructuralDomainID = currentStructuralDomainID;
            }
            for (Chain c : this.chains) {
                if (c.getName() < newChainStart) continue;
                c.sortResidues();
                this.mediator.getGlobalSelection().add(c);
            }
            this.sortChains();
            this.mediator.addUndoStep("undo");
            this.mediator.addUndoStep("current");
            this.fireModelModified();
        }
    }

    public void sortChains() {
        Collections.sort(this.chains, new Comparator<Chain>(){

            @Override
            public int compare(Chain c1, Chain c2) {
                return c1.getResidue(0).getNumber() - c2.getResidue(0).getNumber();
            }
        });
    }

    private void defineLimits() {
        float minZ;
        float minY;
        float minX;
        List<Atom> atoms = this.getAtoms();
        float maxX = minX = atoms.get(0).getX();
        float maxY = minY = atoms.get(0).getY();
        float maxZ = minZ = atoms.get(0).getZ();
        for (int i = 1; i < atoms.size(); ++i) {
            Atom a = atoms.get(i);
            minX = a.getX() < minX ? a.getX() : minX;
            minY = a.getY() < minY ? a.getY() : minY;
            minZ = a.getZ() < minZ ? a.getZ() : minZ;
            maxX = a.getX() > maxX ? a.getX() : maxX;
            maxY = a.getY() > maxY ? a.getY() : maxY;
            maxZ = a.getZ() > maxZ ? a.getZ() : maxZ;
        }
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public TertiaryStructure getTertiaryStructure() {
        return this.tertiaryStructure;
    }

    public SecondaryStructure getSecondaryStructure() {
        return this.secondaryStructure;
    }

    public boolean hasStructuralInformation(SecondaryStructure ss, RNA rna) {
        for (Helix f : ss.getHelices()) {
            if (!f.annotates((Molecule)rna)) continue;
            return true;
        }
        for (Helix f : ss.getSingleStrands()) {
            if (!f.annotates((Molecule)rna)) continue;
            return true;
        }
        return false;
    }

    public void bindAllChains() {
        for (Molecule molecule : this.mediator.getAssemble().getWorkingSession().getMolecules()) {
            this.bindAllChains(molecule);
        }
    }

    public void bindAllChains(Molecule molecule) {
    }

    public void renameChains() {
        int id = 65;
        for (Chain chain : this.getChains()) {
            chain.setName((char)id);
            id = (char)(id + '\u0001');
            if (id == 91) {
                id = 97;
            }
            if (id == 123) {
                id = 48;
            }
            if (id != 58) continue;
            id = 65;
        }
    }

    public void fireModelModified() {
        this.mediator.addUndoStep("current");
        for (ModelListener m : this.modelListeners) {
            m.modelModified();
        }
    }

    public void fireModelRejected() {
        for (ModelListener m : this.modelListeners) {
            m.modelRejected();
        }
    }

    public void exportAsPDB(File f, boolean exportNumberingSystem) throws IOException, ParsingException {
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        for (Residue r : this.mediator.get3DModel().getResidues()) {
            r.saveCoordinatesToParadise();
            residues.add(r.getResidue3D());
        }
        try {
            PDBFileIO.writePDBFile(residues, (boolean)exportNumberingSystem, (File)f);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Override
    public void draw(GL gl) {
        if (!this.chains.isEmpty()) {
            this.chains.get(0).draw(gl);
            for (int i = 1; i < this.chains.size(); ++i) {
                Chain chain = this.chains.get(i);
                chain.draw(gl);
                if (!Assemble.DRAW_BACKBONE_BETWEEN_MOLECULAR_CHAINS) continue;
                Chain previousChain = this.chains.get(i - 1);
                Residue r1 = previousChain.getResidue(previousChain.getLength() - 1);
                Residue r2 = chain.getResidue(0);
                if (!r1.showBackBone || !r1.isDisplayed() || !r2.showBackBone || !r2.isDisplayed()) continue;
                gl.glLineWidth((float)this.mediator.getRenderer().getLINE_BACKBONE_WIDTH());
                gl.glBegin(1);
                gl.glColor3fv(r1.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(r1.backBone.getFloat(), 0);
                gl.glColor3fv(r2.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(r2.backBone.getFloat(), 0);
                gl.glEnd();
            }
        }
        for (Label l : this.labels) {
            l.draw(gl);
        }
    }

    public Residue3D getResidue(Molecule m, int p, TertiaryStructure ts) {
        for (Residue3D r : ts.getResidues3D()) {
            if (!r.annotates(m) || r.getFullLocation(m).getStart() != p) continue;
            return r;
        }
        return null;
    }

    public boolean containsProteins() {
        for (Molecule mol : this.mediator.getAssemble().getWorkingSession().getMolecules()) {
            if (!(mol instanceof Protein)) continue;
            return true;
        }
        return false;
    }

    public void drawSelectScene(GL gl) {
        for (Chain chain : this.getChains()) {
            chain.drawSelectScene(gl);
        }
    }

    @Override
    public void addUndoStep(String stateName) {
        this.undoChains.put(stateName, new ArrayList<Chain>(this.chains));
        for (Chain chain : this.chains) {
            chain.addUndoStep(stateName);
        }
    }

    @Override
    public void restoreState(String stateName) {
        this.chains = new ArrayList<Chain>((Collection)this.undoChains.get(stateName));
        for (Chain c : this.chains) {
            c.restoreState(stateName);
        }
    }

    @Override
    public void removeState(String stateName) {
        List<Chain> _chains = this.undoChains.get(stateName);
        if (_chains != null) {
            for (Chain c : _chains) {
                c.removeState(stateName);
            }
        }
        this.undoChains.remove(stateName);
    }

    public Residue getResidueFor(Residue3D paradiseResidue) {
        for (Chain chain : this.chains) {
            Residue residue = chain.getResidueFor(paradiseResidue);
            if (residue == null) continue;
            return residue;
        }
        return null;
    }

    public Atom getAtomFor(Residue3D.Atom paradiseAtom) {
        Residue residue = this.getResidueFor(paradiseAtom.getResidue3D());
        if (residue != null) {
            return residue.getAtomFor(paradiseAtom);
        }
        return null;
    }

    public Atom getAtomByID(int id) {
        for (Chain c : this.chains) {
            for (Residue r : c.getResidues()) {
                for (Atom atom : r.getAtoms()) {
                    if (atom.getObjId() != id) continue;
                    return atom;
                }
            }
        }
        return null;
    }

    public void saveCoordinatesToParadise() {
        for (Chain chain : this.chains) {
            chain.saveCoordinatesToParadise();
        }
    }

    public SecondaryStructure getCurrentSecondaryStructure() {
        return this.secondaryStructure;
    }

    public void setSecondaryStructure(SecondaryStructure ss) {
        for (BaseBaseInteraction bbi : ss.getBaseBaseInteractions()) {
            if (bbi.getAtomAtomInteractions().size() != 0) continue;
            bbi.generateAtomAtomInteractions();
        }
        this.secondaryStructure = ss;
    }

    public void stackBuildingBlockInOrder(RNA rna) {
    }
}

