/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.event.AtomListener;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.C;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.H;
import fr.unistra.ibmc.assemble.structures.N;
import fr.unistra.ibmc.assemble.structures.O;
import fr.unistra.ibmc.assemble.structures.P;
import fr.unistra.ibmc.assemble.structures.S;
import fr.unistra.ibmc.assemble.structures.Undoable;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;

public abstract class Residue
extends AtomSet
implements Undoable,
AtomListener {
    protected Chain chain;
    protected String name;
    protected boolean showBackBone = true;
    protected boolean showPlane = false;
    public Atom backBone = null;
    public Atom begining = null;
    public Atom ending = null;
    public Residue3D res3D;
    private Map<String, Chain> undoChains;
    private boolean isDisplayed = true;

    public Residue(Residue3D res3D, Mediator mediator) {
        super(mediator);
        this.res3D = res3D;
        this.name = res3D.getName();
        this.undoChains = new HashMap<String, Chain>();
        for (Residue3D.Atom a : res3D.getAtoms()) {
            if (!a.hasCoordinatesFilled()) continue;
            if (a.getName().indexOf("O") != -1) {
                this.atoms.put(a.getName(), new O(mediator, a, this));
                continue;
            }
            if (a.getName().indexOf("P") != -1) {
                this.atoms.put(a.getName(), new P(mediator, a, this));
                continue;
            }
            if (a.getName().indexOf("H") != -1) {
                this.atoms.put(a.getName(), new H(mediator, a, this));
                continue;
            }
            if (a.getName().indexOf("C") != -1) {
                this.atoms.put(a.getName(), new C(mediator, a, this));
                continue;
            }
            if (a.getName().indexOf("N") != -1) {
                this.atoms.put(a.getName(), new N(mediator, a, this));
                continue;
            }
            if (a.getName().indexOf("S") == -1) continue;
            this.atoms.put(a.getName(), new S(mediator, a, this));
        }
    }

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public void setDisplayed(boolean displayed) {
        this.isDisplayed = displayed;
        if (!displayed) {
            for (Atom a : this.getAtoms()) {
                a.setRenderingMode(7);
            }
        } else {
            for (Atom a : this.getAtoms()) {
                a.setRenderingMode(1);
            }
        }
    }

    public boolean hasState(String stateName) {
        return this.undoChains.containsKey(stateName);
    }

    public void addUndoStep(String stateName) {
        this.undoChains.put(stateName, this.chain);
        for (Atom atom : this.getAtoms()) {
            atom.addUndoStep(stateName);
        }
    }

    public void restoreState(String stateName) {
        this.chain = this.undoChains.get(stateName);
        for (Atom atom : this.atoms.values()) {
            atom.restoreState(stateName);
        }
    }

    public void removeState(String stateName) {
        this.undoChains.remove(stateName);
        for (Atom atom : this.atoms.values()) {
            atom.removeState(stateName);
        }
    }

    public void setRenderingMode(int mode) {
        for (Atom atom : this.atoms.values()) {
            atom.setRenderingMode(mode);
        }
        this.fireRenderingModified();
    }

    public Chain getChain() {
        return this.chain;
    }

    public void setChain(Chain chain) {
        this.chain = chain;
    }

    public void setBackBoneDisplayed(boolean b) {
        this.showBackBone = b;
        this.fireRenderingModified();
    }

    public boolean isPlaneDisplayed() {
        return this.showPlane;
    }

    public void setPlaneDisplayed(boolean showPlane) {
        this.showPlane = showPlane;
        this.fireRenderingModified();
    }

    public void setName(String s) {
        this.name = s;
        this.fireRenderingModified();
    }

    public String getName() {
        return this.name;
    }

    public void draw(GL gl) {
        super.draw(gl);
        if (this.showBackBone && this.renderingMode != 7) {
            gl.glLineWidth((float)this.mediator.getRenderer().getLINE_BACKBONE_WIDTH());
            if (this.getPrev() != null) {
                gl.glBegin(1);
                gl.glColor3fv(this.getPrev().getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(this.getPrev().backBone.getFloat(), 0);
                gl.glColor3fv(this.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(this.backBone.getFloat(), 0);
                gl.glEnd();
            }
        }
    }

    public void drawBackBoneAsRod(GL gl) {
        gl.glLineWidth((float)this.mediator.getRenderer().getLINE_BACKBONE_WIDTH());
        if (this.getPrev() != null) {
            float[] a = this.getPrev().backBone.getFloat();
            float[] b = this.backBone.getFloat();
            float[] c = new float[]{(a[0] + b[0]) / 2.0f, (a[1] + b[1]) / 2.0f, (a[2] + b[2]) / 2.0f};
            gl.glColor3fv(this.getPrev().getColor().getRGBOpenGl(), 0);
            this.mediator.getRenderer().displaySphere(gl, this.mediator.getRenderer().getBB_RADIUS(), a);
            this.mediator.getRenderer().drawCylinder(a, c, this.mediator.getRenderer().getBB_RADIUS());
            gl.glColor3fv(this.getColor().getRGBOpenGl(), 0);
            this.mediator.getRenderer().drawCylinder(c, b, this.mediator.getRenderer().getBB_RADIUS());
            this.mediator.getRenderer().displaySphere(gl, this.mediator.getRenderer().getBB_RADIUS(), b);
        }
    }

    public int getNumber() {
        return ((Molecule.Annotation)this.getResidue3D().getAnnotations().get(0)).getLocation().getStart();
    }

    public Residue getPrev() {
        if (this.chain == null) {
            return null;
        }
        int index = this.chain.indexOf(this);
        if (index > 0) {
            return this.chain.getResidue(index - 1);
        }
        return null;
    }

    public Residue getNext() {
        if (this.chain == null) {
            return null;
        }
        int index = this.chain.indexOf(this);
        if (index < this.chain.getLength() - 1) {
            return this.chain.getResidue(index + 1);
        }
        return null;
    }

    public Residue3D getResidue3D() {
        return this.res3D;
    }

    public Atom getAtomFor(Residue3D.Atom paradiseAtom) {
        for (Atom atom : this.getAtoms()) {
            if (!atom.matches(paradiseAtom)) continue;
            return atom;
        }
        return null;
    }

    public boolean matches(Residue3D paradiseResidue) {
        return this.res3D == paradiseResidue;
    }

    public void saveCoordinatesToParadise() {
        for (Atom atom : this.getAtoms()) {
            atom.saveCoordinatesToParadise();
        }
    }

    public void updateCoordinatesFromParadise() {
        for (Atom atom : this.getAtoms()) {
            atom.updateCoordinatesFromParadise();
        }
    }
}

