/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import Jama.Matrix;
import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.ChooseDominant;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.structures.AdenineNA;
import fr.unistra.ibmc.assemble.structures.Alpha53;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Beta53;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.CytosineNA;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.Epsilon53;
import fr.unistra.ibmc.assemble.structures.Gamma53;
import fr.unistra.ibmc.assemble.structures.GuanineNA;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.UracilNA;
import fr.unistra.ibmc.assemble.structures.Zeta53;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.Uracil3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResidueNA
extends Residue {
    DihedralAngle alpha53;
    DihedralAngle beta53;
    DihedralAngle gamma53;
    DihedralAngle epsilon53;
    DihedralAngle zeta53;
    DihedralAngle chi;
    public Atom C1prim;
    public Atom C2prim;
    public Atom C3prim;
    public Atom C4prim;
    public Atom O4prim;
    Atom firstChi;
    Atom secondChi;

    public static ResidueNA createResidueNA(Mediator mediator, Residue3D residue3D) {
        if (residue3D instanceof Adenine3D) {
            return new AdenineNA(mediator, (Adenine3D)residue3D);
        }
        if (residue3D instanceof Cytosine3D) {
            return new CytosineNA(mediator, (Cytosine3D)residue3D);
        }
        if (residue3D instanceof Guanine3D) {
            return new GuanineNA(mediator, (Guanine3D)residue3D);
        }
        if (residue3D instanceof Uracil3D) {
            return new UracilNA(mediator, (Uracil3D)residue3D);
        }
        System.err.println("Unknown residue3D for Assemble: " + residue3D.getClass().getName());
        return null;
    }

    protected ResidueNA(Residue3D res3D, Mediator mediator) {
        super(res3D, mediator);
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("P"), (Atom)this.atoms.get("O1P")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("P"), (Atom)this.atoms.get("O2P")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("P"), (Atom)this.atoms.get("O3P")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PA"), (Atom)this.atoms.get("O1A")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PA"), (Atom)this.atoms.get("O2A")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PA"), (Atom)this.atoms.get("O3A")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PB"), (Atom)this.atoms.get("O1B")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PB"), (Atom)this.atoms.get("O2B")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PB"), (Atom)this.atoms.get("O3B")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PG"), (Atom)this.atoms.get("O1G")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PG"), (Atom)this.atoms.get("O2G")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PG"), (Atom)this.atoms.get("O3G")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PA"), (Atom)this.atoms.get("PB")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PB"), (Atom)this.atoms.get("PG")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("PA"), (Atom)this.atoms.get("O5'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("P"), (Atom)this.atoms.get("O5'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("O5'"), (Atom)this.atoms.get("C5'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C5'"), (Atom)this.atoms.get("C4'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C4'"), (Atom)this.atoms.get("C3'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C3'"), (Atom)this.atoms.get("O3'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C3'"), (Atom)this.atoms.get("C2'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C2'"), (Atom)this.atoms.get("C1'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C1'"), (Atom)this.atoms.get("O4'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("O4'"), (Atom)this.atoms.get("C4'")));
        this.links.add(Link.createLink(mediator, (Atom)this.atoms.get("C2'"), (Atom)this.atoms.get("O2'")));
        this.begining = this.getAtom("P");
        if (this.begining == null) {
            this.begining = this.getAtoms().iterator().next();
        }
        this.ending = this.getAtom("O3'");
        if (this.ending == null) {
            this.ending = this.getAtoms().iterator().next();
        }
        this.backBone = this.getAtom("P");
        if (this.backBone == null) {
            this.backBone = this.getAtoms().iterator().next();
        }
        this.C1prim = this.getAtom("C1'");
        this.C2prim = this.getAtom("C2'");
        this.C3prim = this.getAtom("C3'");
        this.C4prim = this.getAtom("C4'");
        this.O4prim = this.getAtom("O4'");
        if (this.begining != null) {
            this.begining.addAtomListener(this);
        }
        if (this.ending != null) {
            this.ending.addAtomListener(this);
        }
        if (this.backBone != null) {
            this.backBone.addAtomListener(this);
        }
        if (this.C1prim != null) {
            this.C1prim.addAtomListener(this);
        }
        if (this.C2prim != null) {
            this.C2prim.addAtomListener(this);
        }
        if (this.C3prim != null) {
            this.C3prim.addAtomListener(this);
        }
        if (this.C4prim != null) {
            this.C4prim.addAtomListener(this);
        }
        if (this.O4prim != null) {
            this.O4prim.addAtomListener(this);
        }
        this.alpha53 = new Alpha53(this, "\u03b1 5'-3' (P-O5')", mediator);
        this.beta53 = new Beta53(this, "\u03b2 5'-3' (O5'-C5')", mediator);
        this.gamma53 = new Gamma53(this, "\u03b3 5'-3' (C5'-C4')", mediator);
        this.epsilon53 = new Epsilon53(this, "\u03b5 5'-3' (C3'-O3')", mediator);
        this.zeta53 = new Zeta53(this, "\u03b6 5'-3' (O3'-P)", mediator);
    }

    public DihedralAngle getAlpha53() {
        return this.alpha53;
    }

    public DihedralAngle getBeta53() {
        return this.beta53;
    }

    public DihedralAngle getGamma53() {
        return this.gamma53;
    }

    public DihedralAngle getEpsilon53() {
        return this.epsilon53;
    }

    public DihedralAngle getZeta53() {
        return this.zeta53;
    }

    public DihedralAngle getChi() {
        return this.chi;
    }

    public abstract void drawPlane(GL var1);

    private Matrix calculateMatrixToBringResidueCloserAtTheThreePrimeEnd(ResidueNA residue) {
        float ap = -0.51939f;
        float bp = 1.70925f;
        float cp = -1.08467f;
        float ao1 = -0.60246f;
        float bo1 = 0.530618f;
        float co1 = -0.883508f;
        float ao2 = -1.52441f;
        float bo2 = 4.57711f;
        float co2 = -1.77632f;
        float ao5 = 0.33345f;
        float bo5 = 1.29635f;
        float co5 = -1.54795f;
        float ax = this.getCoordC2()[0] - this.getCoordO3()[0];
        float bx = this.getCoordC3()[0] - this.getCoordO3()[0];
        float cx = this.getCoordC4()[0] - this.getCoordO3()[0];
        float dx = this.getCoordO3()[0];
        float ay = this.getCoordC2()[1] - this.getCoordO3()[1];
        float by = this.getCoordC3()[1] - this.getCoordO3()[1];
        float cy = this.getCoordC4()[1] - this.getCoordO3()[1];
        float dy = this.getCoordO3()[1];
        float az = this.getCoordC2()[2] - this.getCoordO3()[2];
        float bz = this.getCoordC3()[2] - this.getCoordO3()[2];
        float cz = this.getCoordC4()[2] - this.getCoordO3()[2];
        float dz = this.getCoordO3()[2];
        float px = ap * ax + bp * bx + cp * cx + dx;
        float py = ap * ay + bp * by + cp * cy + dy;
        float pz = ap * az + bp * bz + cp * cz + dz;
        float o1x = ao1 * ax + bo1 * bx + co1 * cx + dx;
        float o1y = ao1 * ay + bo1 * by + co1 * cy + dy;
        float o1z = ao1 * az + bo1 * bz + co1 * cz + dz;
        float o2x = ao2 * ax + bo2 * bx + co2 * cx + dx;
        float o2y = ao2 * ay + bo2 * by + co2 * cy + dy;
        float o2z = ao2 * az + bo2 * bz + co2 * cz + dz;
        float o5x = ao5 * ax + bo5 * bx + co5 * cx + dx;
        float o5y = ao5 * ay + bo5 * by + co5 * cy + dy;
        float o5z = ao5 * az + bo5 * bz + co5 * cz + dz;
        float[] ra = new float[]{px, py, pz};
        float[] rb = new float[]{o1x, o1y, o1z};
        float[] rc = new float[]{o2x, o2y, o2z};
        float[] rd = new float[]{o5x, o5y, o5z};
        float[] oa = residue.getCoordP();
        float[] ob = residue.getCoordO1P();
        float[] oc = residue.getCoordO2P();
        float[] od = residue.getCoordO5();
        double[][] mr = new double[][]{{ra[0], rb[0], rc[0], rd[0]}, {ra[1], rb[1], rc[1], rd[1]}, {ra[2], rb[2], rc[2], rd[2]}, {1.0, 1.0, 1.0, 1.0}};
        double[][] mo = new double[][]{{oa[0], ob[0], oc[0], od[0]}, {oa[1], ob[1], oc[1], od[1]}, {oa[2], ob[2], oc[2], od[2]}, {1.0, 1.0, 1.0, 1.0}};
        Matrix r = new Matrix((double[][])mr);
        Matrix o = new Matrix((double[][])mo);
        return r.times(o.inverse());
    }

    public void bringNextResidueCloser() {
        Matrix q;
        Residue nextAssembleResidue = this.mediator.getAssemble().getAssembleResidue(new fr.unistra.ibmc.paradise.core.utils.Residue(this.getNumber() + 1, this.getChain().getMolecule()));
        if (nextAssembleResidue != null && (q = this.calculateMatrixToBringResidueCloserAtTheThreePrimeEnd((ResidueNA)nextAssembleResidue)) != null) {
            for (Atom atom : nextAssembleResidue.getAtoms()) {
                float x = atom.getFloat()[0];
                float y = atom.getFloat()[1];
                float z = atom.getFloat()[2];
                double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                atom.setCoord((float)x2, (float)y2, (float)z2);
            }
        }
    }

    public void bringResiduesCloser(Collection<Residue> residues) {
        Matrix q;
        Residue nextAssembleResidue = this.mediator.getAssemble().getAssembleResidue(new fr.unistra.ibmc.paradise.core.utils.Residue(this.getNumber() + 1, this.getChain().getMolecule()));
        if (nextAssembleResidue != null && (q = this.calculateMatrixToBringResidueCloserAtTheThreePrimeEnd((ResidueNA)nextAssembleResidue)) != null) {
            for (Residue r : residues) {
                for (Atom atom : r.getAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
        }
    }

    public void bringMolecularChainOfNextResidueCloser() {
        Matrix q;
        Residue nextAssembleResidue = this.mediator.getAssemble().getAssembleResidue(new fr.unistra.ibmc.paradise.core.utils.Residue(this.getNumber() + 1, this.getChain().getMolecule()));
        if (nextAssembleResidue != null && (q = this.calculateMatrixToBringResidueCloserAtTheThreePrimeEnd((ResidueNA)nextAssembleResidue)) != null) {
            for (Residue r : nextAssembleResidue.getChain().getResidues()) {
                for (Atom atom : r.getAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
        }
    }

    public void bringStructuralDomainOfNextResidueCloser() {
        Residue nextAssembleResidue = this.mediator.getAssemble().getAssembleResidue(new fr.unistra.ibmc.paradise.core.utils.Residue(this.getNumber() + 1, this.getChain().getMolecule()));
        ArrayList<Residue> residuesToMove = new ArrayList<Residue>();
        if (nextAssembleResidue != null) {
            StructuralDomain sd = this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((fr.unistra.ibmc.paradise.core.utils.Residue)nextAssembleResidue.getResidue3D().getResidues().iterator().next());
            for (fr.unistra.ibmc.paradise.core.utils.Residue r : sd.getResidues().getResidues()) {
                Residue assembleResidue = this.mediator.getAssemble().getAssembleResidue(r);
                if (assembleResidue == null) continue;
                residuesToMove.add(assembleResidue);
            }
            Matrix q = this.calculateMatrixToBringResidueCloserAtTheThreePrimeEnd((ResidueNA)nextAssembleResidue);
            if (q != null) {
                for (Residue r : residuesToMove) {
                    for (Atom atom : r.getAtoms()) {
                        float x = atom.getFloat()[0];
                        float y = atom.getFloat()[1];
                        float z = atom.getFloat()[2];
                        double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                        double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                        double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                        atom.setCoord((float)x2, (float)y2, (float)z2);
                    }
                }
            }
        }
    }

    public void bringUserSelectionOfNextResidueCloser(UserSelection selection) {
        Matrix q;
        Residue nextAssembleResidue = this.mediator.getAssemble().getAssembleResidue(new fr.unistra.ibmc.paradise.core.utils.Residue(this.getNumber() + 1, this.getChain().getMolecule()));
        if (nextAssembleResidue != null && (q = this.calculateMatrixToBringResidueCloserAtTheThreePrimeEnd((ResidueNA)nextAssembleResidue)) != null) {
            for (Residue r : selection.getResidues()) {
                for (Atom atom : r.getAtoms()) {
                    float x = atom.getFloat()[0];
                    float y = atom.getFloat()[1];
                    float z = atom.getFloat()[2];
                    double x2 = (double)x * q.get(0, 0) + (double)y * q.get(0, 1) + (double)z * q.get(0, 2) + q.get(0, 3);
                    double y2 = (double)x * q.get(1, 0) + (double)y * q.get(1, 1) + (double)z * q.get(1, 2) + q.get(1, 3);
                    double z2 = (double)x * q.get(2, 0) + (double)y * q.get(2, 1) + (double)z * q.get(2, 2) + q.get(2, 3);
                    atom.setCoord((float)x2, (float)y2, (float)z2);
                }
            }
        }
    }

    public void bind(ResidueNA r, boolean displayErrorMessage) {
        if (this.chain != r.chain && this.chain.getMolecule() == r.chain.getMolecule() && this.chain.getLength() > 0 && r.chain.getLength() > 0) {
            int pos2;
            int pos1 = this.getResidue3D().getFullLocation(this.chain.getMolecule()).getStart();
            if (Math.abs(pos1 - (pos2 = r.getResidue3D().getFullLocation(r.chain.getMolecule()).getStart())) == 1) {
                if (pos1 > pos2) {
                    Residue[] residues;
                    for (Residue _r : residues = this.chain.getResidues().toArray(new Residue[0])) {
                        r.chain.extendChain(_r);
                    }
                } else {
                    Residue[] residues;
                    for (Residue _r : residues = r.chain.getResidues().toArray(new Residue[0])) {
                        this.chain.extendChain(_r);
                    }
                }
                this.mediator.get3DModel().fireModelModified();
                System.gc();
                this.chain.sortResidues();
                r.chain.sortResidues();
                this.mediator.get3DModel().sortChains();
            } else if (displayErrorMessage) {
                JOptionPane.showMessageDialog(this.mediator.getAssemble().getFrame(), "The two residues have to be contiguous in the original sequence");
            }
        } else if (this.chain == r.chain && displayErrorMessage) {
            JOptionPane.showMessageDialog(this.mediator.getAssemble().getFrame(), "The two residues are already linked");
        } else if (this.chain.getMolecule() != r.chain.getMolecule() && displayErrorMessage) {
            JOptionPane.showMessageDialog(this.mediator.getAssemble().getFrame(), "The two residues are located in different sequences");
        }
    }

    public void splitChain() {
        Chain newChain = new Chain(this.mediator, this.chain.getName());
        Residue[] residues = this.chain.getResidues().toArray(new Residue[0]);
        for (int i = this.chain.getResidues().indexOf(this); i < residues.length; ++i) {
            newChain.extendChain(residues[i]);
        }
        newChain.sortResidues();
        this.chain.sortResidues();
        this.mediator.get3DModel().addChainAt(this.mediator.get3DModel().getChains().indexOf(this.chain) + 1, newChain);
        this.mediator.get3DModel().sortChains();
        this.mediator.get3DModel().fireModelModified();
    }

    @Override
    public void draw(GL gl) {
        super.draw(gl);
        if (this.isPlaneDisplayed()) {
            this.drawPlane(gl);
        }
    }

    public float[] getCoordC2() {
        return this.getAtom("C2'").getFloat();
    }

    public float[] getCoordC1() {
        return this.getAtom("C1'").getFloat();
    }

    public float[] getCoordC3() {
        return this.getAtom("C3'").getFloat();
    }

    public float[] getCoordC4() {
        return this.getAtom("C4'").getFloat();
    }

    public float[] getCoordO3() {
        return this.getAtom("O3'").getFloat();
    }

    public float[] getCoordP() {
        return this.getAtom("P").getFloat();
    }

    public float[] getCoordO1P() {
        return this.getAtom("O1P").getFloat();
    }

    public float[] getCoordO2P() {
        return this.getAtom("O2P").getFloat();
    }

    public float[] getCoordO5() {
        return this.getAtom("O5'").getFloat();
    }

    public void restoreAFormConformation() {
        if (this.epsilon53.isValid()) {
            this.epsilon53.torsToDegree(-151.7f, true);
        }
        if (this.zeta53.isValid()) {
            this.zeta53.torsToDegree(-73.6f, true);
        }
        if (this.alpha53.isValid()) {
            this.alpha53.torsToDegree(-62.1f, true);
        }
        if (this.beta53.isValid()) {
            this.beta53.torsToDegree(-179.9f, true);
        }
        if (this.gamma53.isValid()) {
            this.gamma53.torsToDegree(47.4f, true);
        }
        if (this.chi.isValid()) {
            this.chi.torsToDegree(-165.7f, true);
        }
    }

    public ResidueNA getPair() {
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions('W')) {
            if (bbi.getOrientation() != 'C' || bbi.getEdge1() != 'W' || bbi.getEdge2() != 'W') continue;
            return this.getPartner(bbi);
        }
        return null;
    }

    public Set<ResidueNA> getPartners() {
        HashSet<ResidueNA> partners = new HashSet<ResidueNA>();
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions()) {
            partners.add(this.getPartner(bbi));
        }
        return partners;
    }

    public ResidueNA getPartner(BaseBaseInteraction bbi) {
        Molecule molecule = (Molecule)this.getResidue3D().getMolecules().iterator().next();
        Location rloc = this.getResidue3D().getFullLocation(molecule);
        List annotations = bbi.getAnnotations();
        if (annotations.size() == 1) {
            Location loc = bbi.getFullLocation(molecule);
            int other = loc.getStart() == rloc.getStart() ? loc.getEnd() : loc.getStart();
            if (molecule.getAnnotations(Residue3D.class, new Location(other)).size() != 0) {
                return (ResidueNA)this.mediator.get3DModel().getResidueFor((Residue3D)((Molecule.Annotation)molecule.getAnnotations(Residue3D.class, new Location(other)).get(0)).getFeature());
            }
            return null;
        }
        Molecule.Annotation an = ((Molecule.Annotation)annotations.get(0)).getMolecule() == molecule ? (Molecule.Annotation)annotations.get(1) : (Molecule.Annotation)annotations.get(0);
        if (an.getMolecule().getAnnotations(Residue3D.class, new Location(an.getLocation())).size() != 0) {
            return (ResidueNA)this.mediator.get3DModel().getResidueFor((Residue3D)((Molecule.Annotation)an.getMolecule().getAnnotations(Residue3D.class, new Location(an.getLocation())).get(0)).getFeature());
        }
        return null;
    }

    public void removeBaseBaseInteractions(char edge) {
        Residue3D r3d = this.getResidue3D();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions(edge)) {
            if (!ss.getBaseBaseInteractions().contains(bbi)) continue;
            for (Molecule.Annotation annotation : bbi.getAnnotations()) {
                for (AtomAtomInteraction aai : bbi.getAtomAtomInteractions()) {
                    annotation.getMolecule().removeFeature((ParadiseFeature)aai);
                }
                annotation.getMolecule().removeFeature((ParadiseFeature)bbi);
            }
        }
    }

    public void setBaseBaseInteraction(ResidueNA pair, char edge1, char edge2, char orientation) throws BiologicalSymbolException {
        Residue3D r3d = this.getResidue3D();
        Residue3D pair3D = pair.getResidue3D();
        Molecule mol = (Molecule)r3d.getMolecules().iterator().next();
        Molecule pairMol = (Molecule)pair3D.getMolecules().iterator().next();
        int loc = mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart();
        int pairLoc = pairMol.getAnnotation((ParadiseFeature)pair3D).getLocation().getStart();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        this.removeBaseBaseInteractions(edge1);
        pair.removeBaseBaseInteractions(edge2);
        StructuralFeatureFactory factory = this.mediator.getAssemble().getStructuralFeatureFactory();
        if (BaseBaseInteraction.isAmbiguous((char)this.getName().charAt(0), (char)pair.getName().charAt(0), (char)edge1, (char)edge2, (char)orientation)) {
            new ChooseDominant(this, pair, edge1, edge2, orientation);
        } else if (mol.getParadiseID().equals((Object)pairMol.getParadiseID())) {
            if (loc <= pairLoc) {
                Location location = new Location(new Location(loc), new Location(pairLoc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, 1, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            } else {
                Location location = new Location(new Location(pairLoc), new Location(loc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge2, edge1, orientation, 1, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            }
        } else {
            BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, 1, ss, mol, new Location(loc), pairMol, new Location(pairLoc));
            bbi.generateAtomAtomInteractions();
        }
    }

    public void setBaseBaseInteraction(ResidueNA pair, char edge1, char edge2, char orientation, int dominant) throws BiologicalSymbolException {
        Residue3D r3d = this.getResidue3D();
        Residue3D pair3D = pair.getResidue3D();
        Molecule mol = (Molecule)r3d.getMolecules().iterator().next();
        Molecule pairMol = (Molecule)pair3D.getMolecules().iterator().next();
        int loc = mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart();
        int pairLoc = pairMol.getAnnotation((ParadiseFeature)pair3D).getLocation().getStart();
        StructuralFeatureFactory factory = this.mediator.getAssemble().getStructuralFeatureFactory();
        SecondaryStructure ss = this.mediator.get3DModel().getCurrentSecondaryStructure();
        if (mol.getParadiseID().equals((Object)pairMol.getParadiseID())) {
            if (loc <= pairLoc) {
                Location location = new Location(new Location(loc), new Location(pairLoc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, dominant, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            } else {
                Location location = new Location(new Location(pairLoc), new Location(loc));
                BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge2, edge1, orientation, 3 - dominant, ss, mol, location);
                bbi.generateAtomAtomInteractions();
            }
        } else {
            BaseBaseInteraction bbi = factory.createBaseBaseInteraction(edge1, edge2, orientation, dominant, ss, mol, new Location(loc), pairMol, new Location(pairLoc));
            bbi.generateAtomAtomInteractions();
        }
    }

    public Set<BaseBaseInteraction> getBaseBaseInteractions() {
        HashSet<BaseBaseInteraction> bbis = new HashSet<BaseBaseInteraction>();
        bbis.addAll(this.getBaseBaseInteractions('H'));
        bbis.addAll(this.getBaseBaseInteractions('S'));
        bbis.addAll(this.getBaseBaseInteractions('W'));
        return bbis;
    }

    public Set<BaseBaseInteraction> getBaseBaseInteractions(char edge) {
        HashSet<BaseBaseInteraction> ret = new HashSet<BaseBaseInteraction>();
        Residue3D r3d = this.getResidue3D();
        Molecule mol = (Molecule)r3d.getMolecules().iterator().next();
        for (Molecule.Annotation annotation : mol.getAnnotations(BaseBaseInteraction.class)) {
            if (!annotation.getLocation().contains(mol.getAnnotation((ParadiseFeature)r3d).getLocation())) continue;
            BaseBaseInteraction bbi = (BaseBaseInteraction)annotation.getFeature();
            List anns = bbi.getAnnotations();
            if (anns.size() == 1) {
                if (((Molecule.Annotation)anns.get(0)).getLocation().getStart() == mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart() && edge == bbi.getEdge1()) {
                    ret.add(bbi);
                    continue;
                }
                if (((Molecule.Annotation)anns.get(0)).getLocation().getEnd() != mol.getAnnotation((ParadiseFeature)r3d).getLocation().getStart() || edge != bbi.getEdge2()) continue;
                ret.add(bbi);
                continue;
            }
            if (((Molecule.Annotation)anns.get(0)).getMolecule().getParadiseID().equals((Object)mol.getParadiseID()) && bbi.getEdge1() == edge) {
                ret.add(bbi);
                continue;
            }
            if (!((Molecule.Annotation)anns.get(1)).getMolecule().getParadiseID().equals((Object)mol.getParadiseID()) || bbi.getEdge1() != edge) continue;
            ret.add(bbi);
        }
        return ret;
    }

    public void setPair(ResidueNA p) throws BiologicalSymbolException {
        if (p != null) {
            this.setBaseBaseInteraction(p, 'W', 'W', 'C');
        } else {
            this.removeBaseBaseInteractions('W');
        }
        if (this == p) {
            this.setPair(null);
        }
        this.mediator.get3DModel().fireModelModified();
        this.fireRenderingModified();
    }

    @Override
    public void atomMoved() {
        this.mediator.get3DModel().fireModelModified();
    }

    public float[] getPNext() {
        float a = -0.51939f;
        float b = 1.70925f;
        float c = -1.08467f;
        float[] P2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            P2[i] = a * (this.getCoordC2()[i] - this.getCoordO3()[i]) + b * (this.getCoordC3()[i] - this.getCoordO3()[i]) + c * (this.getCoordC4()[i] - this.getCoordO3()[i]) + this.getCoordO3()[i];
        }
        return P2;
    }

    public float[] getPPrev() {
        float a = -5.44361f;
        float b = 14.3799f;
        float c = -0.773307f;
        float[] P2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            P2[i] = a * (this.getCoordC2()[i] - this.getCoordO3()[i]) + b * (this.getCoordC3()[i] - this.getCoordO3()[i]) + c * (this.getCoordC4()[i] - this.getCoordO3()[i]) + this.getCoordO3()[i];
        }
        return P2;
    }

    public float[] getPPair() {
        float a = 2.96263f;
        float b = 14.3449f;
        float c = -6.88677f;
        float[] P2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            P2[i] = a * (this.getCoordC2()[i] - this.getCoordO3()[i]) + b * (this.getCoordC3()[i] - this.getCoordO3()[i]) + c * (this.getCoordC4()[i] - this.getCoordO3()[i]) + this.getCoordO3()[i];
        }
        return P2;
    }
}

