/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;

public class Zeta53
extends DihedralAngle {
    public Zeta53(Residue r, String name, Mediator mediator) {
        super(r, name, mediator);
    }

    protected float computeValue(boolean upstreamDirection) {
        if (this.isValid()) {
            Residue nextResidue = this.residue.getNext();
            if (!upstreamDirection) {
                return TBMath.dihedral((float[])this.residue.getAtom("C3'").getFloat(), (float[])this.residue.getAtom("O3'").getFloat(), (float[])nextResidue.getAtom("P").getFloat(), (float[])nextResidue.getAtom("O5'").getFloat());
            }
            return TBMath.dihedral((float[])nextResidue.getAtom("O5'").getFloat(), (float[])nextResidue.getAtom("P").getFloat(), (float[])this.residue.getAtom("O3'").getFloat(), (float[])this.residue.getAtom("C3'").getFloat());
        }
        return 0.0f;
    }

    public boolean isValid() {
        Residue nextResidue = this.residue.getNext();
        if (nextResidue == null) {
            return false;
        }
        return this.residue.getAtom("C3'") != null && this.residue.getAtom("O3'") != null && nextResidue.getAtom("P") != null && nextResidue.getAtom("O5'") != null;
    }

    public Link getAxis(boolean upstreamDirection) {
        Residue nextResidue = this.residue.getNext();
        if (!upstreamDirection) {
            return new Link(this.mediator, this.residue.getAtom("O3'"), nextResidue.getAtom("P"));
        }
        return new Link(this.mediator, nextResidue.getAtom("P"), this.residue.getAtom("O3'"));
    }

    public void gatherAtomsToRotate(boolean upstreamDirection, boolean rotateTertiaryInteractions) {
        super.gatherAtomsToRotate(upstreamDirection, rotateTertiaryInteractions);
        if (upstreamDirection) {
            this.atomsToRotate.add(this.residue);
            for (BaseBaseInteraction2D interaction : this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D((fr.unistra.ibmc.paradise.core.utils.Residue)this.residue.getResidue3D().getResidues().iterator().next()).getInteractions()) {
                if (!interaction.getBaseBaseInteractionFeature().isSecondaryInteraction() && !rotateTertiaryInteractions) continue;
                Residue r = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getResidue().getResidue2DFeature().getResidues().iterator().next());
                Residue partnerR = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getPartnerResidue().getResidue2DFeature().getResidues().iterator().next());
                if (r != this.residue) {
                    this.atomsToRotate.add(r);
                    continue;
                }
                if (partnerR == null) continue;
                this.atomsToRotate.add(partnerR);
            }
            Atom a = this.residue.getAtom("O3'");
            if (a != null) {
                this.atomsToRotate.removeAtom(a);
            }
        }
    }
}

