/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.utils;

import fr.unistra.ibmc.assemble.gui.Assemble;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AssembleConfig {
    private static Document document;

    public static void parseConfigFile() throws BackingStoreException, IOException {
        File configFile;
        File assembleUserDir = Assemble.getUserDir();
        if (!assembleUserDir.exists()) {
            assembleUserDir.mkdir();
        }
        if (!(configFile = new File(assembleUserDir, "config.xml")).exists()) {
            Element root = new Element("assemble-config");
            root.setAttribute("version", "1.0.4");
            document = new Document(root);
            root.addContent((Content)new Element("platform-addresses"));
            AssembleConfig.save();
        } else {
            SAXBuilder builder = new SAXBuilder();
            try {
                document = builder.build(configFile);
                if (document.getRootElement().getAttribute("version") == null) {
                    configFile.delete();
                    Element root = new Element("assemble-config");
                    root.setAttribute("version", "1.0.4");
                    document = new Document(root);
                    root.addContent((Content)new Element("platform-addresses"));
                    AssembleConfig.save();
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getPlatformAddresses() {
        ArrayList<String> adresses = new ArrayList<String>();
        for (Object o : document.getRootElement().getChild("platform-addresses").getChildren()) {
            adresses.add(((Element)o).getText());
        }
        adresses.add("localhost");
        return adresses.toArray(new String[0]);
    }

    public static void addPlatformAddress(String address) {
        Element e = new Element("platform-address");
        e.setText(address);
        document.getRootElement().getChild("platform-addresses").addContent((Content)e);
    }

    public static boolean useBetaUpdates() {
        Element e = document.getRootElement().getChild("use-beta-updates");
        if (e == null) {
            e = new Element("use-beta-updates");
            e.setText("No");
            document.getRootElement().addContent((Content)e);
        }
        return e.getText().equals("Yes");
    }

    public static void useBetaUpdates(boolean useBetaUpdates) {
        document.getRootElement().getChild("use-beta-updates").setText(useBetaUpdates ? "Yes" : "No");
    }

    public static String getUpdateServer() {
        Element e = document.getRootElement().getChild("update-server");
        if (e == null) {
            e = new Element("update-server");
            e.setText("http://ftp.bioinformatics.org/pub/assemble/");
            document.getRootElement().addContent((Content)e);
        }
        return e.getText();
    }

    public static void save() throws BackingStoreException, IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        FileWriter writer = new FileWriter(new File(Assemble.getUserDir(), "config.xml"));
        outputter.output(document, (Writer)writer);
        writer.close();
    }
}

