/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.utils;

import Jama.Matrix;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUtils {
    public static void applyFold(List<Residue> assembleResidues, List<Residue3D> referenceResidues, Residue referenceAssembleResidue) {
        try {
            if (referenceAssembleResidue == null) {
                for (Residue3D residue3D : referenceResidues) {
                    ModelingUtils.applyFold(assembleResidues.get(referenceResidues.indexOf(residue3D)), residue3D);
                }
            } else {
                float[] c1_1 = referenceAssembleResidue.getAtom("C1'").getFloat();
                float[] c2_1 = referenceAssembleResidue.getAtom("C2'").getFloat();
                float[] c3_1 = referenceAssembleResidue.getAtom("C3'").getFloat();
                float[] c4_1 = referenceAssembleResidue.getAtom("C4'").getFloat();
                for (Residue3D residue3D : referenceResidues) {
                    ModelingUtils.applyFold(assembleResidues.get(referenceResidues.indexOf(residue3D)), residue3D);
                }
                float[] c1_2 = referenceAssembleResidue.getAtom("C1'").getFloat();
                float[] c2_2 = referenceAssembleResidue.getAtom("C2'").getFloat();
                float[] c3_2 = referenceAssembleResidue.getAtom("C3'").getFloat();
                float[] c4_2 = referenceAssembleResidue.getAtom("C4'").getFloat();
                ModelingUtils.transformResidues(ModelingUtils.getTransformationMatrix(new float[][]{c1_2, c2_2, c3_2, c4_2}, new float[][]{c1_1, c2_1, c3_1, c4_1}), assembleResidues);
            }
        }
        catch (BiologicalSymbolException e1) {
            e1.printStackTrace();
            return;
        }
    }

    private static void applyFold(Residue assembleResidue, Residue3D referenceResidue) throws BiologicalSymbolException {
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        boolean atomNb = false;
        if (referenceResidue.getName().charAt(0) != assembleResidue.getName().charAt(0)) {
            referenceResidue = referenceResidue.mutateResidue3D(assembleResidue.getName().charAt(0));
        }
        for (Residue3D.Atom a : referenceResidue.getAtoms()) {
            Atom _a;
            if (!a.hasCoordinatesFilled() || (_a = assembleResidue.getAtom(a.getName())) == null) continue;
            _a.setCoord(a.getX(), a.getY(), a.getZ());
        }
    }

    public static Matrix getTransformationMatrix(float[][] atoms1, float[][] atoms2) {
        Matrix m1 = new Matrix((double[][])new double[][]{{atoms1[0][0], atoms1[1][0], atoms1[2][0], atoms1[3][0]}, {atoms1[0][1], atoms1[1][1], atoms1[2][1], atoms1[3][1]}, {atoms1[0][2], atoms1[1][2], atoms1[2][2], atoms1[3][2]}, {1.0, 1.0, 1.0, 1.0}});
        Matrix m2 = new Matrix((double[][])new double[][]{{atoms2[0][0], atoms2[1][0], atoms2[2][0], atoms2[3][0]}, {atoms2[0][1], atoms2[1][1], atoms2[2][1], atoms2[3][1]}, {atoms2[0][2], atoms2[1][2], atoms2[2][2], atoms2[3][2]}, {1.0, 1.0, 1.0, 1.0}});
        return m2.times(m1.inverse());
    }

    public static void transformResidues(Matrix transformationMatrix, List<Residue> assembleResidues) {
        for (Residue residue : assembleResidues) {
            for (Atom atom : residue.getAtoms()) {
                float x = atom.getFloat()[0];
                float y = atom.getFloat()[1];
                float z = atom.getFloat()[2];
                double x2 = (double)x * transformationMatrix.get(0, 0) + (double)y * transformationMatrix.get(0, 1) + (double)z * transformationMatrix.get(0, 2) + transformationMatrix.get(0, 3);
                double y2 = (double)x * transformationMatrix.get(1, 0) + (double)y * transformationMatrix.get(1, 1) + (double)z * transformationMatrix.get(1, 2) + transformationMatrix.get(1, 3);
                double z2 = (double)x * transformationMatrix.get(2, 0) + (double)y * transformationMatrix.get(2, 1) + (double)z * transformationMatrix.get(2, 2) + transformationMatrix.get(2, 3);
                atom.setCoord((float)x2, (float)y2, (float)z2);
            }
        }
    }
}

