/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.core.messaging.TopicManagementHelper;
import jade.core.messaging.TopicManagementSlice;
import jade.core.messaging.TopicRegistration;
import jade.core.messaging.TopicTable;
import jade.core.messaging.TopicUtility;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TopicManagementService
extends BaseService {
    public static final String NAME = "jade.core.messaging.TopicManagement";
    private AgentContainer myContainer;
    private MainContainer myMain;
    private Filter incFilter;
    private Filter outFilter;
    private ServiceComponent localSlice;
    private TopicTable topicTable = new TopicTable();
    private MessagingService theMessagingService;
    static /* synthetic */ Class class$jade$core$messaging$TopicManagementSlice;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.myMain = ac.getMain();
        this.outFilter = new CommandOutgoingFilter();
        this.incFilter = new CommandIncomingFilter();
        this.localSlice = new ServiceComponent();
    }

    public void boot(Profile p) throws ServiceException {
        super.boot(p);
        try {
            if (this.myContainer.getPlatformID().equals("TOPIC_")) {
                throw new ServiceException("The TopicManagementService cannot be used within a platform called with the reserved name TOPIC_");
            }
            this.theMessagingService = (MessagingService)this.myContainer.getServiceFinder().findService("jade.core.messaging.Messaging");
        }
        catch (IMTPException imtpe) {
            throw new ServiceException("Cannot retrieve the local MessagingService.", imtpe);
        }
    }

    public String getName() {
        return NAME;
    }

    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.incFilter;
        }
        return this.outFilter;
    }

    public Class getHorizontalInterface() {
        return class$jade$core$messaging$TopicManagementSlice == null ? (class$jade$core$messaging$TopicManagementSlice = TopicManagementService.class$("jade.core.messaging.TopicManagementSlice")) : class$jade$core$messaging$TopicManagementSlice;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public ServiceHelper getHelper(Agent a) throws ServiceException {
        return new TopicHelperImpl();
    }

    public String dump(String key) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.topicTable.toString());
        sb.append(super.dump(key));
        return sb.toString();
    }

    private final void sendMessage(AID sender, GenericMessage gMsg, AID receiver) {
        GenericCommand cmd = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
        cmd.addParam(sender);
        cmd.addParam(gMsg);
        cmd.addParam(receiver);
        try {
            this.theMessagingService.submit(cmd);
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    private void handleInformKilled(VerticalCommand cmd) {
        block3: {
            Object[] params = cmd.getParams();
            AID aid = (AID)params[0];
            List topics = this.topicTable.getRelevantTopics(aid);
            if (topics.size() <= 0) break block3;
            try {
                Service.Slice[] slices = this.getAllSlices();
                Iterator it = topics.iterator();
                while (it.hasNext()) {
                    this.broadcastDeregistration(aid, (AID)it.next(), slices);
                }
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Error retrieving topic-management-slices when trying to broadcast topic de-registration due to agent death. ", t);
            }
        }
    }

    private void handleNewSlice(VerticalCommand cmd) {
        block3: {
            if (!cmd.getService().equals(NAME)) break block3;
            Object[] params = cmd.getParams();
            String newSliceName = (String)params[0];
            try {
                TopicManagementSlice newSlice = (TopicManagementSlice)this.getFreshSlice(newSliceName);
                List registrations = this.topicTable.getAllRegistrations();
                Iterator it = registrations.iterator();
                while (it.hasNext()) {
                    TopicRegistration reg = (TopicRegistration)it.next();
                    newSlice.register(reg.getAID(), reg.getTopic());
                }
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Error notifying new slice " + newSliceName + " about current topic registrations", t);
            }
        }
    }

    private void handleReattached(VerticalCommand cmd) {
        try {
            TopicManagementSlice newSlice = (TopicManagementSlice)this.getFreshSlice("$$$Main-Slice$$$");
            List registrations = this.topicTable.getAllRegistrations();
            Iterator it = registrations.iterator();
            while (it.hasNext()) {
                TopicRegistration reg = (TopicRegistration)it.next();
                AID aid = reg.getAID();
                if (this.myContainer.acquireLocalAgent(aid) == null) continue;
                try {
                    newSlice.register(aid, reg.getTopic());
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Error notifying main slice about current local topic registrations", e);
                }
                this.myContainer.releaseLocalAgent(aid);
            }
        }
        catch (Throwable t) {
            this.myLogger.log(Logger.WARNING, "Error retrieving main slice.", t);
        }
    }

    private void broadcastRegistration(AID aid, AID topic, Service.Slice[] slices) throws ServiceException {
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Registering agent " + aid.getName() + " to topic " + topic.getLocalName());
        }
        int i = 0;
        while (i < slices.length) {
            String sliceName = null;
            try {
                TopicManagementSlice slice = (TopicManagementSlice)slices[i];
                sliceName = slice.getNode().getName();
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, "Propagating registration of agent " + aid.getName() + " to slice " + sliceName);
                }
                slice.register(aid, topic);
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Error propagating topic registration to slice  " + sliceName, t);
            }
            ++i;
        }
    }

    private void broadcastDeregistration(AID aid, AID topic, Service.Slice[] slices) throws ServiceException {
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Deregistering agent " + aid.getName() + " from topic " + topic.getLocalName());
        }
        int i = 0;
        while (i < slices.length) {
            String sliceName = null;
            try {
                TopicManagementSlice slice = (TopicManagementSlice)slices[i];
                sliceName = slice.getNode().getName();
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, "Propagating deregistration of agent " + aid.getName() + " to slice " + sliceName);
                }
                slice.deregister(aid, topic);
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Error propagating topic de-registration to slice  " + sliceName, t);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TopicHelperImpl
    implements TopicManagementHelper {
        private AID aid;

        private TopicHelperImpl() {
        }

        public void init(Agent a) {
            this.aid = a.getAID();
        }

        public AID createTopic(String topicName) {
            return TopicUtility.createTopic(topicName);
        }

        public boolean isTopic(AID id) {
            return TopicUtility.isTopic(id);
        }

        public void register(AID topic) throws ServiceException {
            Service.Slice[] slices = TopicManagementService.this.getAllSlices();
            TopicManagementService.this.broadcastRegistration(this.aid, topic, slices);
        }

        public void deregister(AID topic) throws ServiceException {
            Service.Slice[] slices = TopicManagementService.this.getAllSlices();
            TopicManagementService.this.broadcastDeregistration(this.aid, topic, slices);
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return TopicManagementService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return TopicManagementService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Error retrieving local node", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("R")) {
                    AID aid = (AID)params[0];
                    AID topic = (AID)params[1];
                    if (TopicManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        TopicManagementService.this.myLogger.log(Logger.FINE, "Received registration of agent " + aid.getName() + " to topic " + topic.getLocalName());
                    }
                    this.register(aid, topic);
                } else if (cmdName.equals("D")) {
                    AID aid = (AID)params[0];
                    AID topic = (AID)params[1];
                    if (TopicManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        TopicManagementService.this.myLogger.log(Logger.FINE, "Received deregistration of agent " + aid.getName() + " from topic " + topic.getLocalName());
                    }
                    this.deregister(aid, topic);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }

        private void register(AID aid, AID topic) {
            TopicManagementService.this.topicTable.register(aid, topic);
        }

        private void deregister(AID aid, AID topic) {
            TopicManagementService.this.topicTable.deregister(aid, topic);
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        private CommandIncomingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            if (TopicManagementService.this.myMain != null) {
                if (name.equals("Inform-Killed")) {
                    TopicManagementService.this.handleInformKilled(cmd);
                }
                if (name.equals("New-Slice")) {
                    TopicManagementService.this.handleNewSlice(cmd);
                }
            } else if (name.equals("Reattached")) {
                TopicManagementService.this.handleReattached(cmd);
            }
            return true;
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        public CommandOutgoingFilter() {
            this.setPreferredPosition(2);
        }

        public final boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            if (name.equals("Send-Message")) {
                AID sender = (AID)cmd.getParam(0);
                GenericMessage gMsg = (GenericMessage)cmd.getParam(1);
                AID receiver = (AID)cmd.getParam(2);
                if (TopicUtility.isTopic(receiver)) {
                    AID topic = receiver;
                    if (TopicManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        TopicManagementService.this.myLogger.log(Logger.FINE, "Handling message about topic " + topic.getLocalName());
                    }
                    ACLMessage msg = gMsg.getACLMessage();
                    Collection interestedAgents = TopicManagementService.this.topicTable.getInterestedAgents(topic, msg);
                    if (interestedAgents.size() > 0) {
                        msg.addUserDefinedParameter("JADE-ignore-failure", "true");
                        gMsg.setModifiable(false);
                        Iterator it = interestedAgents.iterator();
                        while (it.hasNext()) {
                            AID target = (AID)it.next();
                            if (TopicManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                                TopicManagementService.this.myLogger.log(Logger.FINE, "Forwarding message to agent " + target.getName());
                            }
                            TopicManagementService.this.sendMessage(sender, gMsg, target);
                        }
                    }
                    return false;
                }
            }
            return true;
        }
    }
}

