/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.proto.Initiator;
import jade.util.leap.Serializable;
import java.util.Vector;

public class ContractNetInitiator
extends Initiator {
    public final String CFP_KEY;
    public final String ALL_CFPS_KEY;
    public final String ALL_ACCEPTANCES_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_RESULT_NOTIFICATIONS_KEY;
    private static final String HANDLE_PROPOSE = "Handle-propose";
    private static final String HANDLE_REFUSE = "Handle-refuse";
    private static final String HANDLE_INFORM = "Handle-inform";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final String HANDLE_ALL_RESULT_NOTIFICATIONS = "Handle-all-result-notifications";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int ALL_RESULT_NOTIFICATIONS_RECEIVED = 2;
    private int step;
    private boolean skipNextRespFlag;
    private String[] toBeReset;

    public ContractNetInitiator(Agent a, ACLMessage cfp) {
        this(a, cfp, new DataStore());
    }

    public ContractNetInitiator(Agent a, ACLMessage cfp, DataStore store) {
        super(a, cfp, store);
        this.CFP_KEY = this.INITIATION_K;
        this.ALL_CFPS_KEY = this.ALL_INITIATIONS_K;
        this.ALL_ACCEPTANCES_KEY = "__all-acceptances" + this.hashCode();
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_RESULT_NOTIFICATIONS_KEY = "__all-result-notifications" + this.hashCode();
        this.step = 1;
        this.skipNextRespFlag = false;
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_PROPOSE, 11);
        this.registerTransition("Check-in-seq", HANDLE_REFUSE, 14);
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerDefaultTransition(HANDLE_PROPOSE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_REFUSE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerTransition("Check-sessions", HANDLE_ALL_RESULT_NOTIFICATIONS, 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Send-initiations", this.getToBeReset());
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895819003L;

            public void action() {
                Vector acceptances = (Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_ACCEPTANCES_KEY);
                ACLMessage propose = (ACLMessage)this.getDataStore().get(ContractNetInitiator.this.REPLY_K);
                ContractNetInitiator.this.handlePropose(propose, acceptances);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_PROPOSE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895819004L;

            public void action() {
                ContractNetInitiator.this.handleRefuse((ACLMessage)this.getDataStore().get(ContractNetInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_REFUSE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818006L;

            public void action() {
                ContractNetInitiator.this.handleInform((ACLMessage)this.getDataStore().get(ContractNetInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_INFORM);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                Vector responses = (Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_RESPONSES_KEY);
                Vector acceptances = (Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_ACCEPTANCES_KEY);
                ContractNetInitiator.this.handleAllResponses(responses, acceptances);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ContractNetInitiator.this.handleAllResultNotifications((Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_RESULT_NOTIFICATIONS_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerLastState(b, HANDLE_ALL_RESULT_NOTIFICATIONS);
    }

    protected Vector prepareInitiations(ACLMessage initiation) {
        return this.prepareCfps(initiation);
    }

    protected void sendInitiations(Vector initiations) {
        if (this.step == 2) {
            initiations = (Vector)this.getDataStore().get(this.ALL_ACCEPTANCES_KEY);
        }
        super.sendInitiations(initiations);
    }

    protected boolean checkInSequence(ACLMessage reply) {
        boolean ret = false;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null) {
            int perf = reply.getPerformative();
            if (s.update(perf)) {
                Vector all = (Vector)this.getDataStore().get(this.step == 1 ? this.ALL_RESPONSES_KEY : this.ALL_RESULT_NOTIFICATIONS_KEY);
                all.addElement(reply);
                ret = true;
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
        }
        return ret;
    }

    protected int checkSessions(ACLMessage reply) {
        int ret;
        if (this.skipNextRespFlag) {
            this.sessions.clear();
        }
        int n = ret = this.step == 1 ? 1 : 2;
        if (reply != null) {
            if (this.sessions.size() > 0) {
                ret = -1;
            }
        } else {
            this.sessions.clear();
        }
        if (ret != -1) {
            ++this.step;
        }
        return ret;
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_PROPOSE, HANDLE_REFUSE, "Handle-not-understood", HANDLE_INFORM, "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected Vector prepareCfps(ACLMessage cfp) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        v.addElement(cfp);
        return v;
    }

    protected void handlePropose(ACLMessage propose, Vector acceptances) {
    }

    protected void handleRefuse(ACLMessage refuse) {
    }

    protected void handleInform(ACLMessage inform) {
    }

    protected void handleAllResponses(Vector responses, Vector acceptances) {
    }

    protected void handleAllResultNotifications(Vector resultNotifications) {
    }

    public void registerPrepareCfps(Behaviour b) {
        this.registerPrepareInitiations(b);
    }

    public void registerHandlePropose(Behaviour b) {
        this.registerState(b, HANDLE_PROPOSE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleRefuse(Behaviour b) {
        this.registerState(b, HANDLE_REFUSE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleInform(Behaviour b) {
        this.registerState(b, HANDLE_INFORM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResultNotifications(Behaviour b) {
        this.registerLastState(b, HANDLE_ALL_RESULT_NOTIFICATIONS);
        b.setDataStore(this.getDataStore());
    }

    public void skipNextResponses() {
        this.skipNextRespFlag = true;
    }

    protected void reinit() {
        this.step = 1;
        this.skipNextRespFlag = false;
        super.reinit();
    }

    protected void initializeDataStore(ACLMessage msg) {
        super.initializeDataStore(msg);
        DataStore ds = this.getDataStore();
        Vector l = new Vector();
        ds.put(this.ALL_RESPONSES_KEY, l);
        l = new Vector();
        ds.put(this.ALL_RESULT_NOTIFICATIONS_KEY, l);
        l = new Vector();
        ds.put(this.ALL_ACCEPTANCES_KEY, l);
    }

    protected Initiator.ProtocolSession getSession(ACLMessage msg, int sessionIndex) {
        if (msg.getPerformative() == 3) {
            return new Session(1);
        }
        if (msg.getPerformative() == 0) {
            return new Session(2);
        }
        return null;
    }

    class Session
    implements Initiator.ProtocolSession,
    Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;
        private int step;

        public Session(int step) {
            this.step = step;
        }

        public String getId() {
            return null;
        }

        public boolean update(int perf) {
            if (this.state == 0) {
                if (this.step == 1) {
                    switch (perf) {
                        case 6: 
                        case 10: 
                        case 11: 
                        case 14: {
                            this.state = 1;
                            return true;
                        }
                    }
                    return false;
                }
                switch (perf) {
                    case 6: 
                    case 7: 
                    case 10: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

