/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.BasicProperties;
import jade.util.EnhancedProperties;
import jade.util.PropertiesException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;

public class ExpandedProperties
extends EnhancedProperties {
    BasicProperties envProperties = null;
    boolean expandedSearch = false;

    public static void main(String[] args) {
        ExpandedProperties prop = new ExpandedProperties(args);
        prop.list(System.out);
    }

    public ExpandedProperties() {
    }

    public ExpandedProperties(String[] theArgs) {
        this.parseArgs(theArgs);
    }

    public ExpandedProperties(String aFileName) throws IOException {
        super(aFileName);
    }

    protected String getEnvironmentProperty(String key) {
        String value = super.getEnvironmentProperty(key.toLowerCase());
        if (value == null) {
            value = this.getEnvProperties().getProperty(key);
        }
        return value;
    }

    protected BasicProperties getEnvProperties() {
        block2: {
            if (this.envProperties != null) break block2;
            try {
                this.envProperties = ExpandedProperties.getEnvironmentProperties();
            }
            catch (Exception e) {
                this.envProperties = new EnhancedProperties();
            }
        }
        return this.envProperties;
    }

    public static BasicProperties getEnvironmentProperties() {
        EnhancedProperties properties = new EnhancedProperties();
        String command = null;
        String osName = System.getProperty("os.name").toLowerCase();
        command = osName.startsWith("windows") ? "set" : "env";
        String commandOutput = ExpandedProperties.getCommandOutput(command, true);
        if (commandOutput != null) {
            StringTokenizer parser = new StringTokenizer(commandOutput, System.getProperty("line.separator"));
            while (parser.hasMoreTokens()) {
                String line = parser.nextToken();
                int i = line.indexOf(61);
                properties.setProperty(line.substring(0, i), line.substring(i + 1));
            }
        }
        return properties;
    }

    public String locatePropertyFile(String aPropertyFileName, String aSearchCeiling) {
        File dir;
        File searchCeilingFile = null;
        if (aSearchCeiling != null) {
            searchCeilingFile = new File(aSearchCeiling);
        }
        String result = null;
        String path = new File(".").getAbsolutePath();
        path = path.substring(0, path.length() - 2);
        this.expandedSearch = false;
        while ((result = this.scanDirectory(aPropertyFileName, path = (dir = new File(path)).getPath(), 0)) == null && (searchCeilingFile == null || dir.compareTo(searchCeilingFile) != 0)) {
            path = dir.getParent();
            this.expandedSearch = true;
            if (path != null) continue;
        }
        return result;
    }

    protected static String getCommandOutput(String aCommand, boolean isShellCommand) {
        StringBuffer result = new StringBuffer();
        boolean success = false;
        try {
            String osName;
            String prefix = null;
            prefix = isShellCommand ? ((osName = System.getProperty("os.name").toLowerCase()).startsWith("windows") ? (osName.startsWith("windows 95") || osName.startsWith("windows 98") ? "command.com /e:16000 /c " : "cmd.exe /c ") : "/bin/sh -c ") : "";
            Process shell = Runtime.getRuntime().exec(prefix + aCommand);
            BufferedReader commandOutput = new BufferedReader(new InputStreamReader(shell.getInputStream()));
            String line = null;
            int lineCount = 0;
            String eol = System.getProperty("line.separator");
            while ((line = commandOutput.readLine()) != null) {
                if (lineCount > 0) {
                    result.append(eol);
                }
                result.append(line);
                ++lineCount;
            }
            shell.waitFor();
            success = shell.exitValue() == 0;
            commandOutput.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!success) {
            return null;
        }
        return result.toString();
    }

    protected String scanDirectory(String aPropertyFileName, String aPath, int depth) {
        aPath = aPath.replace('\\', '/');
        String result = null;
        File dir = new File(aPath);
        if (!dir.isDirectory()) {
            throw new PropertiesException("Not directory: " + aPath);
        }
        String[] names = dir.list();
        if (names == null) {
            return null;
        }
        int i = 0;
        while (i < names.length) {
            File target;
            String fileName = names[i];
            String fullName = aPath;
            if (!fullName.endsWith("/")) {
                fullName = fullName + "/";
            }
            fullName = fullName + fileName;
            if (this.expandedSearch && depth == 0 && (target = new File(fullName)).isDirectory() && (result = this.scanDirectory(aPropertyFileName, fullName, depth + 1)) != null) break;
            if (fileName.equalsIgnoreCase(aPropertyFileName)) {
                String string = result = this.expandedSearch ? this.testPropertyFile(fullName) : fullName;
                if (result != null) break;
            }
            ++i;
        }
        return result;
    }

    protected String testPropertyFile(String aPropertyFileName) {
        Properties prop = new Properties();
        String result = null;
        try {
            prop.load(new FileInputStream(aPropertyFileName));
            String importName = this.doSubstitutions(prop.getProperty(this.importKey));
            result = importName != null ? importName : aPropertyFileName;
        }
        catch (IOException ioe) {}
        return result;
    }
}

