/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AgentManager;
import jade.core.ContainerID;
import jade.core.event.MTPEvent;
import jade.security.JADESecurityException;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jade.wrapper.PlatformController;
import jade.wrapper.PlatformEvent;
import jade.wrapper.PlatformState;
import jade.wrapper.State;
import java.util.Hashtable;

class PlatformControllerImpl
implements PlatformController {
    private ContainerController myContainer;
    private AgentManager myMain;
    private Hashtable listeners = new Hashtable();
    private State platformState = PlatformState.PLATFORM_STATE_VOID;

    PlatformControllerImpl(ContainerController c, AgentManager m) {
        this.myContainer = c;
        this.myMain = m;
        this.platformState = PlatformState.PLATFORM_STATE_READY;
        this.myMain.addListener(new AgentManagerListenerAdapter(){

            public void removedContainer(jade.core.event.PlatformEvent ev) {
                ContainerID cid = ev.getContainer();
                try {
                    if (cid.getName().equals(PlatformControllerImpl.this.myContainer.getContainerName())) {
                        PlatformControllerImpl.this.platformState = PlatformState.PLATFORM_STATE_KILLED;
                    }
                }
                catch (ControllerException ce) {
                    ce.printStackTrace();
                }
            }
        });
    }

    public String getName() {
        return this.myContainer.getPlatformName();
    }

    public void start() throws ControllerException {
    }

    public void suspend() throws ControllerException {
        throw new ControllerException("Not_Yet_Implemented");
    }

    public void resume() throws ControllerException {
        throw new ControllerException("Not_Yet_Implemented");
    }

    public void kill() throws ControllerException {
        try {
            this.platformState = PlatformState.PLATFORM_STATE_KILLING;
            this.myMain.shutdownPlatform(null, null);
        }
        catch (JADESecurityException jse) {
            throw new ControllerException("Security error. " + jse.getMessage());
        }
    }

    public AgentController getAgent(String localAgentName) throws ControllerException {
        return this.myContainer.getAgent(localAgentName);
    }

    public AgentController createNewAgent(String nickname, String className, Object[] args) throws ControllerException {
        return this.myContainer.createNewAgent(nickname, className, args);
    }

    public State getState() {
        return this.platformState;
    }

    public synchronized void addPlatformListener(PlatformController.Listener aListener) throws ControllerException {
        ListenerWrapper wrapper = new ListenerWrapper(aListener);
        this.myMain.addListener(wrapper);
        this.listeners.put(aListener, wrapper);
    }

    public synchronized void removePlatformListener(PlatformController.Listener aListener) throws ControllerException {
        ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(aListener);
        if (wrapper != null) {
            this.myMain.removeListener(wrapper);
        }
    }

    class ListenerWrapper
    extends AgentManagerListenerAdapter {
        private PlatformController.Listener myListener;

        ListenerWrapper(PlatformController.Listener l) {
            this.myListener = l;
        }

        public void removedContainer(jade.core.event.PlatformEvent ev) {
            ContainerID cid = ev.getContainer();
            try {
                if (cid.getName().equals(PlatformControllerImpl.this.myContainer.getContainerName())) {
                    this.myListener.killedPlatform(new PlatformEvent(this){
                        private final /* synthetic */ ListenerWrapper this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getAgentGUID() {
                            return null;
                        }

                        public String getPlatformName() {
                            return PlatformControllerImpl.access$000(ListenerWrapper.access$200(this.this$1)).getPlatformName();
                        }

                        public int getEventType() {
                            return 103;
                        }
                    });
                }
            }
            catch (ControllerException ce) {
                ce.printStackTrace();
            }
        }

        public void bornAgent(jade.core.event.PlatformEvent ev) {
            this.myListener.bornAgent(ev);
        }

        public void deadAgent(jade.core.event.PlatformEvent ev) {
            this.myListener.deadAgent(ev);
        }

        static /* synthetic */ PlatformControllerImpl access$200(ListenerWrapper x0) {
            return x0.PlatformControllerImpl.this;
        }
    }

    class AgentManagerListenerAdapter
    implements AgentManager.Listener {
        AgentManagerListenerAdapter() {
        }

        public void addedContainer(jade.core.event.PlatformEvent ev) {
        }

        public void removedContainer(jade.core.event.PlatformEvent ev) {
        }

        public void bornAgent(jade.core.event.PlatformEvent ev) {
        }

        public void deadAgent(jade.core.event.PlatformEvent ev) {
        }

        public void movedAgent(jade.core.event.PlatformEvent ev) {
        }

        public void suspendedAgent(jade.core.event.PlatformEvent ev) {
        }

        public void resumedAgent(jade.core.event.PlatformEvent ev) {
        }

        public void frozenAgent(jade.core.event.PlatformEvent ev) {
        }

        public void thawedAgent(jade.core.event.PlatformEvent ev) {
        }

        public void addedMTP(MTPEvent ev) {
        }

        public void removedMTP(MTPEvent ev) {
        }

        public void messageIn(MTPEvent ev) {
        }

        public void messageOut(MTPEvent ev) {
        }
    }
}

