/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.shell.impl.AbstractStarter;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.impl.StandardConsole;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartLocalClient
extends AbstractStarter {
    public static final String ARG_PATH = "path";
    public static final String ARG_READONLY = "readonly";

    public static void main(String[] args) {
        Map<String, String> argMap = StartLocalClient.parseArgs(args);
        String dbPath = argMap.get(ARG_PATH);
        if (dbPath == null) {
            System.err.println("ERROR: To start a local neo4j service and a shell client on top of that you need to supply a path to a neo4j store or just a new path where a new store will be created if it doesn't exist. -path /my/path/here");
            return;
        }
        try {
            boolean readOnly = argMap.containsKey(ARG_READONLY) && StartLocalClient.stringAsBoolean(argMap.get(ARG_READONLY), true) != false;
            StartLocalClient.tryStartLocalServerAndClient(dbPath, readOnly, args);
        }
        catch (Exception e) {
            if (StartLocalClient.storeWasLocked(e)) {
                if (StartLocalClient.wantToConnectReadOnlyInstead()) {
                    try {
                        StartLocalClient.tryStartLocalServerAndClient(dbPath, true, args);
                    }
                    catch (Exception innerException) {
                        StartLocalClient.handleException(innerException, argMap);
                    }
                } else {
                    StartLocalClient.handleException(e, argMap);
                }
            }
            StartLocalClient.handleException(e, argMap);
        }
        System.exit(0);
    }

    private static boolean wantToConnectReadOnlyInstead() {
        StandardConsole console = new StandardConsole();
        console.format("\nThe store seem locked. Start a read-only client instead (y/n) [y]? ", new Object[0]);
        String input = console.readLine();
        return input.length() == 0 || input.equals("y");
    }

    private static boolean storeWasLocked(Exception e) {
        return StartLocalClient.mineException(e, IllegalStateException.class, "Unable to lock store");
    }

    private static boolean mineException(Throwable e, Class<IllegalStateException> eClass, String startOfMessage) {
        if (eClass.isInstance(e) && e.getMessage().startsWith(startOfMessage)) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return StartLocalClient.mineException(cause, eClass, startOfMessage);
        }
        return false;
    }

    private static void tryStartLocalServerAndClient(String dbPath, boolean readOnly, String[] args) throws Exception {
        final GraphDatabaseService graph = readOnly ? new EmbeddedReadOnlyGraphDatabase(dbPath) : new EmbeddedGraphDatabase(dbPath);
        final GraphDatabaseShellServer server = new GraphDatabaseShellServer(graph);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                server.shutdown();
                graph.shutdown();
            }
        });
        System.out.println("NOTE: Connected to local neo4j service at '" + dbPath + "'");
        SameJvmClient client = new SameJvmClient(server);
        StartLocalClient.setSessionVariablesFromArgs(client, args);
        client.grabPrompt();
        server.shutdown();
        graph.shutdown();
    }
}

