/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.Map;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.impl.AbstractStarter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartRemoteClient
extends AbstractStarter {
    public static final String ARG_PORT = "port";
    public static final String ARG_NAME = "name";

    public static void main(String[] args) {
        Map<String, String> argMap = StartRemoteClient.parseArgs(args);
        try {
            int port = StartRemoteClient.getPort(argMap);
            String name = StartRemoteClient.getShellName(argMap);
            ShellClient client = ShellLobby.newClient(port, name);
            System.out.println("NOTE: Connected to remote neo4j service '" + name + "' at port " + port);
            StartRemoteClient.setSessionVariablesFromArgs(client, args);
            client.grabPrompt();
        }
        catch (Exception e) {
            StartRemoteClient.handleException(e, argMap);
        }
    }

    private static int getPort(Map<String, String> argMap) {
        String arg = argMap.get(ARG_PORT);
        return arg != null ? Integer.parseInt(arg) : 1337;
    }

    private static String getShellName(Map<String, String> argMap) {
        String arg = argMap.get(ARG_NAME);
        return arg != null ? arg : "shell";
    }
}

