/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.neo4j.shell.App;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.impl.AbstractAppServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Man
extends AbstractApp {
    private static Collection<String> availableCommands;

    @Override
    public String execute(AppCommandParser parser, Session session, Output out) throws ShellException {
        try {
            if (parser.arguments().size() == 0) {
                out.println((Serializable)((Object)Man.getHelpString(this.getServer())));
                return null;
            }
            App app = this.getApp(parser);
            out.println((Serializable)((Object)""));
            out.println((Serializable)((Object)this.fixDesciption(app.getDescription())));
            this.println(out, "");
            boolean hasOptions = false;
            for (String option : app.getAvailableOptions()) {
                hasOptions = true;
                String description = this.fixDesciption(app.getDescription(option));
                String[] descriptionLines = description.split(Pattern.quote("\n"));
                for (int i = 0; i < descriptionLines.length; ++i) {
                    String line = "";
                    if (i == 0) {
                        String optionPrefix = option.length() > 1 ? "--" : "-";
                        line = optionPrefix + option;
                    }
                    line = line + "\t ";
                    line = line + descriptionLines[i];
                    if (i == descriptionLines.length - 1) {
                        // empty if block
                    }
                    this.println(out, line);
                }
            }
            if (hasOptions) {
                this.println(out, "");
            }
        }
        catch (RemoteException e) {
            throw new ShellException(e);
        }
        return null;
    }

    private static String getShortUsageString() {
        return "man <command>";
    }

    private String fixDesciption(String description) {
        if (description == null) {
            description = "";
        } else if (!description.endsWith(".")) {
            description = description + ".";
        }
        return description;
    }

    private void println(Output out, String string) throws RemoteException {
        out.println((Serializable)((Object)("  " + string)));
    }

    private App getApp(AppCommandParser parser) throws ShellException {
        String appName = parser.arguments().get(0);
        try {
            App app = this.getServer().findApp(appName);
            if (app == null) {
                throw new ShellException("No manual entry for '" + appName + "'");
            }
            return app;
        }
        catch (RemoteException e) {
            throw new ShellException(e);
        }
    }

    @Override
    public String getDescription() {
        return "Display a manual for a command or a general help message.\nUsage: " + Man.getShortUsageString();
    }

    public static String getHelpString(ShellServer server) {
        return "Available commands: " + Man.availableCommandsAsString(server) + "\n" + "Use " + Man.getShortUsageString() + " for info about each command.";
    }

    public static synchronized Collection<String> getAvailableCommands(ShellServer server) {
        if (availableCommands == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String name : ((AbstractAppServer)server).getAllAvailableCommands()) {
                list.add(name);
            }
            availableCommands = list;
        }
        return availableCommands;
    }

    private static synchronized String availableCommandsAsString(ShellServer server) {
        StringBuffer commands = new StringBuffer();
        for (String command : Man.getAvailableCommands(server)) {
            if (commands.length() > 0) {
                commands.append(" ");
            }
            commands.append(command);
        }
        return commands.toString();
    }
}

