/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.impl.AbstractApp;

public class Script
extends AbstractApp {
    public Script() {
        this.addValueType("v", new AbstractApp.OptionContext(OptionValueType.NONE, "Verbose, print commands"));
    }

    public String getDescription() {
        return "Executes a script of shell commands, supply a file namecontaining the script";
    }

    public String execute(AppCommandParser parser, Session session, Output out) throws ShellException {
        BufferedReader reader;
        File file;
        boolean verbose;
        block8: {
            verbose = parser.options().containsKey("v");
            file = new File(parser.arguments().get(0));
            reader = null;
            if (file.exists()) break block8;
            out.println((Serializable)((Object)("Couldn't find file '" + file.getAbsolutePath() + "'")));
            String string = null;
            Script.safeClose(reader);
            return string;
        }
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            int counter = 0;
            while ((line = reader.readLine()) != null) {
                if (verbose) {
                    if (counter++ > 0) {
                        out.println();
                    }
                    out.println((Serializable)((Object)("[" + line + "]")));
                }
                this.getServer().interpretLine(line, session, out);
            }
        }
        catch (IOException e) {
            try {
                throw new ShellException(e);
            }
            catch (Throwable throwable) {
                Script.safeClose(reader);
                throw throwable;
            }
        }
        Script.safeClose(reader);
        return null;
    }
}

