/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.neo4j.shell.App;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.impl.AbstractServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppServer
extends AbstractServer
implements AppShellServer {
    private Map<String, Class<? extends App>> apps = new TreeMap<String, Class<? extends App>>();
    private Map<Class<? extends App>, App> appInstances = new HashMap<Class<? extends App>, App>();

    public void addApp(Class<? extends App> appClass) {
        this.apps.put(appClass.getSimpleName().toLowerCase(), appClass);
    }

    public Set<Class<? extends App>> getApps() {
        return new TreeSet<Class<? extends App>>(this.apps.values());
    }

    @Override
    public App findApp(String command) {
        Class<? extends App> app = this.apps.get(command);
        if (app == null) {
            return null;
        }
        App result = this.appInstances.get(app);
        if (result == null) {
            try {
                result = app.newInstance();
                ((AbstractApp)result).setServer(this);
                this.appInstances.put(app, result);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void shutdown() {
        for (App app : this.appInstances.values()) {
            app.shutdown();
        }
        super.shutdown();
    }

    @Override
    public String interpretLine(String line, Session session, Output out) throws ShellException {
        if (line == null || line.trim().length() == 0) {
            return "";
        }
        line = this.replaceAlias(line, session);
        AppCommandParser parser = new AppCommandParser(this, line);
        return parser.app().execute(parser, session, out);
    }

    protected String replaceAlias(String line, Session session) throws ShellException {
        boolean changed = true;
        HashSet<String> appNames = new HashSet<String>();
        while (changed) {
            changed = false;
            String appName = AppCommandParser.parseOutAppName(line);
            String prefixedKey = "ALIAS_" + appName;
            String alias = (String)((Object)AbstractApp.safeGet(session, prefixedKey));
            if (alias == null || !appNames.add(alias)) continue;
            changed = true;
            line = alias + line.substring(appName.length());
        }
        return line;
    }

    @Override
    public Iterable<String> getAllAvailableCommands() {
        return new ArrayList<String>(this.apps.keySet());
    }
}

