/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.SimpleAppServer;
import org.neo4j.shell.impl.BashVariableInterpreter;
import org.neo4j.shell.kernel.apps.Cd;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.Gsh;
import org.neo4j.shell.kernel.apps.Index;
import org.neo4j.shell.kernel.apps.Jsh;
import org.neo4j.shell.kernel.apps.Ls;
import org.neo4j.shell.kernel.apps.Mkrel;
import org.neo4j.shell.kernel.apps.Mv;
import org.neo4j.shell.kernel.apps.Pwd;
import org.neo4j.shell.kernel.apps.Rm;
import org.neo4j.shell.kernel.apps.Rmrel;
import org.neo4j.shell.kernel.apps.Set;
import org.neo4j.shell.kernel.apps.Trav;

public class GraphDatabaseShellServer
extends SimpleAppServer {
    private GraphDatabaseService graphDb;
    private BashVariableInterpreter bashInterpreter;

    public GraphDatabaseShellServer(GraphDatabaseService graphDb) throws RemoteException {
        this.addNeoApps();
        this.graphDb = graphDb;
        this.bashInterpreter = new BashVariableInterpreter();
        this.bashInterpreter.addReplacer("W", new WorkingDirReplacer());
        this.setProperty("PS1", (Serializable)((Object)this.getShellPrompt()));
        this.setProperty("TITLE_KEYS", (Serializable)((Object)".*name.*,.*title.*"));
        this.setProperty("TITLE_MAX_LENGTH", (Serializable)((Object)"40"));
    }

    protected String getShellPrompt() {
        String name = "neo4j-sh";
        if (this.graphDb instanceof EmbeddedReadOnlyGraphDatabase) {
            name = name + "[readonly]";
        }
        name = name + " \\W$ ";
        return name;
    }

    public String welcome() {
        return "Welcome to the Neo4j Shell! Enter 'help' for a list of commands";
    }

    private void addNeoApps() {
        this.addApp(Cd.class);
        this.addApp(Gsh.class);
        this.addApp(Jsh.class);
        this.addApp(Ls.class);
        this.addApp(Mkrel.class);
        this.addApp(Mv.class);
        this.addApp(Pwd.class);
        this.addApp(Rm.class);
        this.addApp(Rmrel.class);
        this.addApp(Set.class);
        this.addApp(Trav.class);
        this.addApp(Index.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable interpretVariable(String key, Serializable value, Session session) throws ShellException {
        Transaction tx = this.getDb().beginTx();
        try {
            Object result = value;
            if (key.equals("PS1")) {
                result = this.bashInterpreter.interpret((String)((Object)value), this, session);
            }
            tx.success();
            Serializable serializable = result;
            return serializable;
        }
        finally {
            tx.finish();
        }
    }

    public GraphDatabaseService getDb() {
        return this.graphDb;
    }

    public static class WorkingDirReplacer
    implements BashVariableInterpreter.Replacer {
        public String getReplacement(ShellServer server, Session session) throws ShellException {
            return GraphDatabaseApp.getDisplayName((GraphDatabaseShellServer)server, session, GraphDatabaseApp.getCurrent((GraphDatabaseShellServer)server, session), false).toString();
        }
    }
}

